/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.messages;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.quark.QuarkString;
import com.neeve.quark.QuarkStringDeserializer;
import com.neeve.service.messages.ICredentials;
import com.neeve.service.messages.MessageFactory;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="12/5/25 11:52 AM", buildInfo="nvx-eagle-2.9-SNAPSHOT Xbuf2 Encoding")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=132, ofid=132, typeId=1003)
@JsonPropertyOrder(value={"username", "password"})
public final class Credentials
implements ICredentials,
UtlPool.Item<Credentials>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final CredentialsPoolFactory _credentialsFactory = new CredentialsPoolFactory();
    private static final CredentialsPojoPoolFactory _credentialsPojoFactory = new CredentialsPojoPoolFactory();
    private static final CredentialsSerializerPoolFactory _credentialsSerializerFactory = new CredentialsSerializerPoolFactory();
    private static final CredentialsDeserializerPoolFactory _credentialsDeserializerFactory = new CredentialsDeserializerPoolFactory();
    static final UtlPool<Credentials> _entityPool = UtlPool.create((String)"quark.entity", (String)"CredentialsQuarkEntity.-100.1003", (UtlPool.Factory)_credentialsFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Credentials.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CredentialsPoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"CredentialsQuarkEntityPojo.-100.1003", (UtlPool.Factory)_credentialsPojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CredentialsPojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"CredentialsQuarkEntitySerializer.-100.1003", (UtlPool.Factory)_credentialsSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CredentialsSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"CredentialsQuarkEntityDeserializer.-100.1003", (UtlPool.Factory)_credentialsDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CredentialsDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<Credentials> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final Credentials[] EMPTY_ARRAY = new Credentials[0];

    Credentials() {
    }

    public static Credentials create() {
        Credentials entity = (Credentials)_entityPool.get(null);
        _memoryStats.onEntityAllocated(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final Credentials deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final Credentials deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final Credentials deserializeFrom(Credentials val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final Credentials deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final Credentials wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final Credentials deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final Credentials deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final Credentials deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final Credentials deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Credentials deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            Credentials credentials = this.deserializeFrom(bytebuf);
            return credentials;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final Credentials deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final Credentials deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final Credentials deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            Credentials credentials = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return credentials;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final Credentials deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final Credentials deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final Credentials deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(Credentials copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Credentials copy() {
        Credentials copy = Credentials.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getUsernameFieldId() {
        return 32752;
    }

    @Override
    @JsonProperty(value="username")
    public final void setUsername(String val) {
        this.pojo().setUsernameFrom(val);
    }

    @Override
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getUsername() {
        if (!this.hasUsername()) {
            return null;
        }
        return this.pojo()._usrUsername.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendUsername(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setUsername(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setUsernameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setUsernameFrom(long val) {
        this.pojo().setUsernameFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getUsernameTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getUsernameTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setUsernameFrom(XString val) {
        this.pojo().setUsernameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getUsernameTo(XString val) {
        this.pojo().getUsernameTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getUsernameUnsafe() {
        return this.pojo().getUsername();
    }

    @Override
    public final boolean hasUsername() {
        return this.pojo().hasUsername();
    }

    @Override
    public final void clearUsername() {
        this.pojo().clearUsername();
    }

    public static final int getPasswordFieldId() {
        return 32751;
    }

    @Override
    @JsonProperty(value="password")
    public final void setPassword(String val) {
        this.pojo().setPasswordFrom(val);
    }

    @Override
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getPassword() {
        if (!this.hasPassword()) {
            return null;
        }
        return this.pojo()._usrPassword.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendPassword(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setPassword(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setPasswordFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setPasswordFrom(long val) {
        this.pojo().setPasswordFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getPasswordTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getPasswordTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setPasswordFrom(XString val) {
        this.pojo().setPasswordFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getPasswordTo(XString val) {
        this.pojo().getPasswordTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getPasswordUnsafe() {
        return this.pojo().getPassword();
    }

    @Override
    public final boolean hasPassword() {
        return this.pojo().hasPassword();
    }

    @Override
    public final void clearPassword() {
        this.pojo().clearPassword();
    }

    public final Credentials init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final Credentials setPool(UtlPool<Credentials> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<Credentials> getPool() {
        return this._pool;
    }

    public final Credentials acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        Credentials clonee = Credentials.create();
        if (this.hasUsername()) {
            clonee.setUsername(this.getUsername());
        }
        if (this.hasPassword()) {
            clonee.setPassword(this.getPassword());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasUsername()) {
            builder.append(0 == c++ ? "" : ",").append("Username=").append(this.getUsername());
        }
        if (this.hasPassword()) {
            builder.append(0 == c++ ? "" : ",").append("Password=").append(this.getPassword());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private XString _usrUsername = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrPassword = XString.create((int)0, (boolean)true, (boolean)true);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasUsername() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final XString getUsername() {
            if (!this.hasUsername() || this._usrUsername.isNull()) {
                return null;
            }
            return this._usrUsername;
        }

        public final void getUsernameTo(XString val) {
            if (!this.hasUsername() || this._usrUsername.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrUsername);
        }

        public final void setUsernameFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearUsername();
                return;
            }
            this._usrUsername.setValue(val);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearUsername();
                return;
            }
            this._usrUsername.setValue(val);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearUsername();
                return;
            }
            this._usrUsername.setValue(val);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrUsername.setValue(val);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearUsername();
                return;
            }
            this._usrUsername.setValue(val, offset, len);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearUsername();
                return;
            }
            val.getTo(this._usrUsername);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void setUsernameFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearUsername();
                return;
            }
            val.getTo(this._usrUsername);
            if (!this.hasUsername()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            }
            this._dirty = true;
        }

        public final void clearUsername() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasUsername()) {
                return;
            }
            this._usrUsername.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final boolean hasPassword() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final XString getPassword() {
            if (!this.hasPassword() || this._usrPassword.isNull()) {
                return null;
            }
            return this._usrPassword;
        }

        public final void getPasswordTo(XString val) {
            if (!this.hasPassword() || this._usrPassword.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrPassword);
        }

        public final void setPasswordFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearPassword();
                return;
            }
            this._usrPassword.setValue(val);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearPassword();
                return;
            }
            this._usrPassword.setValue(val);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearPassword();
                return;
            }
            this._usrPassword.setValue(val);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrPassword.setValue(val);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearPassword();
                return;
            }
            this._usrPassword.setValue(val, offset, len);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearPassword();
                return;
            }
            val.getTo(this._usrPassword);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void setPasswordFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearPassword();
                return;
            }
            val.getTo(this._usrPassword);
            if (!this.hasPassword()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            }
            this._dirty = true;
        }

        public final void clearPassword() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasPassword()) {
                return;
            }
            this._usrPassword.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasUsername()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32752, (int)this._usrUsername.length());
            }
            if (this.hasPassword()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32751, (int)this._usrPassword.length());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasUsername()) {
                serializer.username(this._usrUsername);
            }
            if (this.hasPassword()) {
                serializer.password(this._usrPassword);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleUsername(QuarkStringDeserializer val) {
                Pojo.this.setUsernameFrom(val);
            }

            @Override
            public final void handlePassword(QuarkStringDeserializer val) {
                Pojo.this.setPasswordFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final QuarkStringDeserializer _stringDeserializer = QuarkStringDeserializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block10: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 32752: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32752");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleUsername(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block10;
                    }
                    case 32751: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32751");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handlePassword(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block10;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block10;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block10;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block10;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleUsername(QuarkStringDeserializer var1);

            public void handlePassword(QuarkStringDeserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private Credentials _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(Credentials entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer username(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer username(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer username(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer username(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer username(byte[] val) {
            return this.username(val, 0, val.length);
        }

        public final Serializer username(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer username(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32752, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262018);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer password(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer password(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer password(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer password(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer password(byte[] val) {
            return this.password(val, 0, val.length);
        }

        public final Serializer password(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer password(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(Credentials.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class CredentialsDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private CredentialsDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(Credentials.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CredentialsDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private CredentialsDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class CredentialsSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private CredentialsSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(Credentials.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CredentialsSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private CredentialsSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class CredentialsPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private CredentialsPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(Credentials.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CredentialsPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private CredentialsPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class CredentialsPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Credentials> {
        private CredentialsPoolEvictedItemReceiver() {
        }

        public final void process(Credentials evictedItem) {
            _memoryStats.onEntityLeaked(Credentials.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CredentialsPoolFactory
    implements UtlPool.Factory<Credentials> {
        private CredentialsPoolFactory() {
        }

        public final Credentials createItem(Object object) {
            return new Credentials();
        }

        public final Credentials[] createItemArray(int size) {
            return new Credentials[size];
        }
    }

    static final class CredentialsPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        CredentialsPoolFactoryItemCreateArgument() {
        }

        CredentialsPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(4330343, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

