/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.entities;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.ci.XRuntime;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.quark.QuarkBuffer;
import com.neeve.quark.QuarkHeuristics;
import com.neeve.quark.QuarkString;
import com.neeve.quark.QuarkStringDeserializer;
import com.neeve.service.entities.EntityFactory;
import com.neeve.service.entities.IMessageProcessingTime;
import com.neeve.util.UtlPool;
import com.neeve.xbuf2.XbufUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="Xbuf2", compatLevel="4.1.0", admVersion="Unknown Version", date="12/5/25 11:52 AM", buildInfo="nvx-eagle-2.9-SNAPSHOT Xbuf2 Encoding")
@AdmFactoryInfo(factoryClass=EntityFactory.class, vfid=133, ofid=133, typeId=1)
@JsonPropertyOrder(value={"timestamp", "queueTime", "procTime", "txnId", "agentName", "legName"})
public final class MessageProcessingTime
implements IMessageProcessingTime,
UtlPool.Item<MessageProcessingTime>,
AdmRuntime.BufferSizer {
    private static final MemoryStats _memoryStats = MemoryStats.getInstance();
    private static final MessageProcessingTimePoolFactory _messageProcessingTimeFactory = new MessageProcessingTimePoolFactory();
    private static final MessageProcessingTimePojoPoolFactory _messageProcessingTimePojoFactory = new MessageProcessingTimePojoPoolFactory();
    private static final MessageProcessingTimeSerializerPoolFactory _messageProcessingTimeSerializerFactory = new MessageProcessingTimeSerializerPoolFactory();
    private static final MessageProcessingTimeDeserializerPoolFactory _messageProcessingTimeDeserializerFactory = new MessageProcessingTimeDeserializerPoolFactory();
    static final UtlPool<MessageProcessingTime> _entityPool = UtlPool.create((String)"quark.entity", (String)"MessageProcessingTimeQuarkEntity.-101.1", (UtlPool.Factory)_messageProcessingTimeFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(MessageProcessingTime.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageProcessingTimePoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"MessageProcessingTimeQuarkEntityPojo.-101.1", (UtlPool.Factory)_messageProcessingTimePojoFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageProcessingTimePojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"MessageProcessingTimeQuarkEntitySerializer.-101.1", (UtlPool.Factory)_messageProcessingTimeSerializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageProcessingTimeSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"MessageProcessingTimeQuarkEntityDeserializer.-101.1", (UtlPool.Factory)_messageProcessingTimeDeserializerFactory, (UtlPool.Params)QuarkHeuristics.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new MessageProcessingTimeDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<MessageProcessingTime> _pool;
    private QuarkBuffer _serializedBuffer;
    private int _serializedBufferLength;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final MessageProcessingTime[] EMPTY_ARRAY = new MessageProcessingTime[0];

    MessageProcessingTime() {
    }

    public static MessageProcessingTime create() {
        MessageProcessingTime entity = (MessageProcessingTime)_entityPool.get(null);
        _memoryStats.onEntityAllocated(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final QuarkBuffer serializedBuffer(int len) {
        QuarkBuffer oldBuffer = this._serializedBuffer;
        int oldCapacity = oldBuffer != null ? oldBuffer.getCapacity() : 0;
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)len, (boolean)false);
        int newCapacity = this._serializedBuffer.getCapacity();
        if (newCapacity > oldCapacity) {
            if (oldBuffer != null) {
                _memoryStats.onEntityDataDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memoryStats.onEntityDataAllocated(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != null;
    }

    @JsonIgnore
    public final QuarkBuffer getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @Deprecated
    @JsonIgnore
    public final QuarkBuffer getBackingBuffer() {
        return this.getSerializedBuffer();
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferLength) {
            return addr;
        }
        int newLength = capacity <= this._serializedBuffer.getCapacity() ? capacity : Math.max(capacity, this._serializedBuffer.getCapacity() * 2);
        this._serializedBuffer = QuarkBuffer.ensureCapacity((QuarkBuffer)this._serializedBuffer, (int)newLength, (boolean)true);
        return this._serializedBuffer.getNativeAddress();
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo() {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        return this._pojo;
    }

    public final void disposeSerializedBuffer() {
        if (this._serializedBuffer != null) {
            int capacity = this._serializedBuffer.getCapacity();
            this._serializedBuffer.dispose();
            _memoryStats.onEntityDataDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, capacity, true);
            this._serializedBuffer = null;
            this._serializedBufferLength = 0;
        }
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory() {
        this.sync();
        this.disposeSerializer();
        this.disposeDeserializer();
        this.disposePojo(false);
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(XRuntime.optimizeMemoryUsage());
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            EntityFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(QuarkBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (!this.hasDirtyPojo()) {
            return;
        }
        this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
        this._pojo.clearDirty();
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, array, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, buffer, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength, (boolean)useNative);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(bytebuf.capacity());
            bytebuf.position(offset);
            int n = this.serializeTo(bytebuf);
            return n;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getIOBuffer(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            this._serializedBuffer.getTo(0, addr, offset, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final MessageProcessingTime deserializeFromRawJson(String json) {
        try {
            EntityFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final MessageProcessingTime deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final MessageProcessingTime deserializeFrom(MessageProcessingTime val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final MessageProcessingTime deserializeFrom(QuarkBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            this.serializedBuffer(len).putFrom(0, buffer, offset, len);
        }
        return this;
    }

    public final MessageProcessingTime wrap(QuarkBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer;
        this._serializedBufferLength = len;
        return this;
    }

    public final MessageProcessingTime deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final MessageProcessingTime deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            this.serializedBuffer(len).putFrom(0, array, offset, len);
        }
        return this;
    }

    public final MessageProcessingTime deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final MessageProcessingTime deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            this.serializedBuffer(this._serializedBufferLength).putFrom(0, buffer);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MessageProcessingTime deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (buffer == null) {
            return this.deserializeFrom((ByteBuffer)null);
        }
        ByteBuffer bytebuf = buffer.takeBuffer();
        try {
            bytebuf.limit(offset + len).position(offset);
            MessageProcessingTime messageProcessingTime = this.deserializeFrom(bytebuf);
            return messageProcessingTime;
        }
        finally {
            buffer.releaseBuffer();
        }
    }

    public final MessageProcessingTime deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getIOBuffer(), buffer.getOffset() + offset, len);
    }

    public final MessageProcessingTime deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final MessageProcessingTime deserializeFrom(PktPacket packet) {
        try {
            PktBuffer buffer = packet.getBody().getBuffer();
            MessageProcessingTime messageProcessingTime = this.deserializeFrom((IOElasticBuffer)buffer, 0, buffer.getLength());
            return messageProcessingTime;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final MessageProcessingTime deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        this.serializedBuffer(this._serializedBufferLength).putFrom(0, addr, offset, len);
        return this;
    }

    @Deprecated
    public final MessageProcessingTime deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final MessageProcessingTime deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(MessageProcessingTime copy) {
        copy.clear();
        this.sync();
        copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final MessageProcessingTime copy() {
        MessageProcessingTime copy = MessageProcessingTime.create();
        this.copyInto(copy);
        return copy;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getTimestampFieldId() {
        return 32752;
    }

    @Override
    @JsonProperty(value="timestamp")
    public final void setTimestamp(long val) {
        this.pojo().setTimestamp(val);
    }

    @Override
    @JsonIgnore
    public final void setTimestampAsObject(Long val) {
        if (val == null) {
            this.clearTimestamp();
        } else {
            this.setTimestamp(val);
        }
    }

    @Override
    @JsonIgnore
    public final long getTimestamp() {
        return this.pojo().getTimestamp();
    }

    @Override
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getTimestampAsObject() {
        if (!this.hasTimestamp()) {
            return null;
        }
        return this.getTimestamp();
    }

    @Override
    public final boolean hasTimestamp() {
        return this.pojo().hasTimestamp();
    }

    @Override
    public final void clearTimestamp() {
        this.pojo().clearTimestamp();
    }

    public static final int getQueueTimeFieldId() {
        return 32748;
    }

    @Override
    @JsonProperty(value="queueTime")
    public final void setQueueTime(int val) {
        this.pojo().setQueueTime(val);
    }

    @Override
    @JsonIgnore
    public final void setQueueTimeAsObject(Integer val) {
        if (val == null) {
            this.clearQueueTime();
        } else {
            this.setQueueTime(val);
        }
    }

    @Override
    @JsonIgnore
    public final int getQueueTime() {
        return this.pojo().getQueueTime();
    }

    @Override
    @JsonProperty(value="queueTime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getQueueTimeAsObject() {
        if (!this.hasQueueTime()) {
            return null;
        }
        return this.getQueueTime();
    }

    @Override
    public final boolean hasQueueTime() {
        return this.pojo().hasQueueTime();
    }

    @Override
    public final void clearQueueTime() {
        this.pojo().clearQueueTime();
    }

    public static final int getProcTimeFieldId() {
        return 32747;
    }

    @Override
    @JsonProperty(value="procTime")
    public final void setProcTime(int val) {
        this.pojo().setProcTime(val);
    }

    @Override
    @JsonIgnore
    public final void setProcTimeAsObject(Integer val) {
        if (val == null) {
            this.clearProcTime();
        } else {
            this.setProcTime(val);
        }
    }

    @Override
    @JsonIgnore
    public final int getProcTime() {
        return this.pojo().getProcTime();
    }

    @Override
    @JsonProperty(value="procTime")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Integer getProcTimeAsObject() {
        if (!this.hasProcTime()) {
            return null;
        }
        return this.getProcTime();
    }

    @Override
    public final boolean hasProcTime() {
        return this.pojo().hasProcTime();
    }

    @Override
    public final void clearProcTime() {
        this.pojo().clearProcTime();
    }

    public static final int getTxnIdFieldId() {
        return 32751;
    }

    @Override
    @JsonProperty(value="txnId")
    public final void setTxnId(String val) {
        this.pojo().setTxnIdFrom(val);
    }

    @Override
    @JsonProperty(value="txnId")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getTxnId() {
        if (!this.hasTxnId()) {
            return null;
        }
        return this.pojo()._usrTxnId.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendTxnId(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setTxnId(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setTxnIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setTxnIdFrom(long val) {
        this.pojo().setTxnIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getTxnIdTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getTxnIdTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setTxnIdFrom(XString val) {
        this.pojo().setTxnIdFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getTxnIdTo(XString val) {
        this.pojo().getTxnIdTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getTxnIdUnsafe() {
        return this.pojo().getTxnId();
    }

    @Override
    public final boolean hasTxnId() {
        return this.pojo().hasTxnId();
    }

    @Override
    public final void clearTxnId() {
        this.pojo().clearTxnId();
    }

    public static final int getAgentNameFieldId() {
        return 32750;
    }

    @Override
    @JsonProperty(value="agentName")
    public final void setAgentName(String val) {
        this.pojo().setAgentNameFrom(val);
    }

    @Override
    @JsonProperty(value="agentName")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getAgentName() {
        if (!this.hasAgentName()) {
            return null;
        }
        return this.pojo()._usrAgentName.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendAgentName(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setAgentName(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setAgentNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setAgentNameFrom(long val) {
        this.pojo().setAgentNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getAgentNameTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getAgentNameTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setAgentNameFrom(XString val) {
        this.pojo().setAgentNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getAgentNameTo(XString val) {
        this.pojo().getAgentNameTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getAgentNameUnsafe() {
        return this.pojo().getAgentName();
    }

    @Override
    public final boolean hasAgentName() {
        return this.pojo().hasAgentName();
    }

    @Override
    public final void clearAgentName() {
        this.pojo().clearAgentName();
    }

    public static final int getLegNameFieldId() {
        return 32749;
    }

    @Override
    @JsonProperty(value="legName")
    public final void setLegName(String val) {
        this.pojo().setLegNameFrom(val);
    }

    @Override
    @JsonProperty(value="legName")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getLegName() {
        if (!this.hasLegName()) {
            return null;
        }
        return this.pojo()._usrLegName.getValue();
    }

    @Override
    @JsonIgnore
    public final void lendLegName(XString val) {
        if (val == null || !val.isInitialized() || val.isNull()) {
            this.setLegName(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setLegNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setLegNameFrom(long val) {
        this.pojo().setLegNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getLegNameTo(XString.Factory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getLegNameTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setLegNameFrom(XString val) {
        this.pojo().setLegNameFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getLegNameTo(XString val) {
        this.pojo().getLegNameTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getLegNameUnsafe() {
        return this.pojo().getLegName();
    }

    @Override
    public final boolean hasLegName() {
        return this.pojo().hasLegName();
    }

    @Override
    public final void clearLegName() {
        this.pojo().clearLegName();
    }

    public final MessageProcessingTime init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final MessageProcessingTime setPool(UtlPool<MessageProcessingTime> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<MessageProcessingTime> getPool() {
        return this._pool;
    }

    public final MessageProcessingTime acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memoryStats.onEntityDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        MessageProcessingTime clonee = MessageProcessingTime.create();
        if (this.hasTimestamp()) {
            clonee.setTimestamp(this.getTimestamp());
        }
        if (this.hasQueueTime()) {
            clonee.setQueueTime(this.getQueueTime());
        }
        if (this.hasProcTime()) {
            clonee.setProcTime(this.getProcTime());
        }
        if (this.hasTxnId()) {
            clonee.setTxnId(this.getTxnId());
        }
        if (this.hasAgentName()) {
            clonee.setAgentName(this.getAgentName());
        }
        if (this.hasLegName()) {
            clonee.setLegName(this.getLegName());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasTimestamp()) {
            builder.append(0 == c++ ? "" : ",").append("Timestamp=").append(this.getTimestamp());
        }
        if (this.hasQueueTime()) {
            builder.append(0 == c++ ? "" : ",").append("QueueTime=").append(this.getQueueTime());
        }
        if (this.hasProcTime()) {
            builder.append(0 == c++ ? "" : ",").append("ProcTime=").append(this.getProcTime());
        }
        if (this.hasTxnId()) {
            builder.append(0 == c++ ? "" : ",").append("TxnId=").append(this.getTxnId());
        }
        if (this.hasAgentName()) {
            builder.append(0 == c++ ? "" : ",").append("AgentName=").append(this.getAgentName());
        }
        if (this.hasLegName()) {
            builder.append(0 == c++ ? "" : ",").append("LegName=").append(this.getLegName());
        }
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private long _usrTimestamp;
        private int _usrQueueTime;
        private int _usrProcTime;
        private XString _usrTxnId = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrAgentName = XString.create((int)0, (boolean)true, (boolean)true);
        private XString _usrLegName = XString.create((int)0, (boolean)true, (boolean)true);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memoryStats.onEntityPojoAllocated(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasTimestamp() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final long getTimestamp() {
            return this._usrTimestamp;
        }

        public final void setTimestamp(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrTimestamp = val;
            this._dirty = true;
        }

        public final void clearTimestamp() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasTimestamp()) {
                return;
            }
            this._usrTimestamp = 0L;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
        }

        public final boolean hasQueueTime() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final int getQueueTime() {
            return this._usrQueueTime;
        }

        public final void setQueueTime(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
            this._usrQueueTime = val;
            this._dirty = true;
        }

        public final void clearQueueTime() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasQueueTime()) {
                return;
            }
            this._usrQueueTime = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
        }

        public final boolean hasProcTime() {
            return (this._fieldBitmask[0] & 4L) != 0L;
        }

        public final int getProcTime() {
            return this._usrProcTime;
        }

        public final void setProcTime(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 4L;
            this._usrProcTime = val;
            this._dirty = true;
        }

        public final void clearProcTime() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasProcTime()) {
                return;
            }
            this._usrProcTime = 0;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFBL;
            this._dirty = true;
        }

        public final boolean hasTxnId() {
            return (this._fieldBitmask[0] & 8L) != 0L;
        }

        public final XString getTxnId() {
            if (!this.hasTxnId() || this._usrTxnId.isNull()) {
                return null;
            }
            return this._usrTxnId;
        }

        public final void getTxnIdTo(XString val) {
            if (!this.hasTxnId() || this._usrTxnId.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrTxnId);
        }

        public final void setTxnIdFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTxnId();
                return;
            }
            this._usrTxnId.setValue(val);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearTxnId();
                return;
            }
            this._usrTxnId.setValue(val);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTxnId();
                return;
            }
            this._usrTxnId.setValue(val);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrTxnId.setValue(val);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTxnId();
                return;
            }
            this._usrTxnId.setValue(val, offset, len);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearTxnId();
                return;
            }
            val.getTo(this._usrTxnId);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void setTxnIdFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearTxnId();
                return;
            }
            val.getTo(this._usrTxnId);
            if (!this.hasTxnId()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 8L;
            }
            this._dirty = true;
        }

        public final void clearTxnId() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasTxnId()) {
                return;
            }
            this._usrTxnId.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFF7L;
            this._dirty = true;
        }

        public final boolean hasAgentName() {
            return (this._fieldBitmask[0] & 0x10L) != 0L;
        }

        public final XString getAgentName() {
            if (!this.hasAgentName() || this._usrAgentName.isNull()) {
                return null;
            }
            return this._usrAgentName;
        }

        public final void getAgentNameTo(XString val) {
            if (!this.hasAgentName() || this._usrAgentName.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrAgentName);
        }

        public final void setAgentNameFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearAgentName();
                return;
            }
            this._usrAgentName.setValue(val);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearAgentName();
                return;
            }
            this._usrAgentName.setValue(val);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearAgentName();
                return;
            }
            this._usrAgentName.setValue(val);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrAgentName.setValue(val);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearAgentName();
                return;
            }
            this._usrAgentName.setValue(val, offset, len);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearAgentName();
                return;
            }
            val.getTo(this._usrAgentName);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void setAgentNameFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearAgentName();
                return;
            }
            val.getTo(this._usrAgentName);
            if (!this.hasAgentName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x10L;
            }
            this._dirty = true;
        }

        public final void clearAgentName() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasAgentName()) {
                return;
            }
            this._usrAgentName.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFEFL;
            this._dirty = true;
        }

        public final boolean hasLegName() {
            return (this._fieldBitmask[0] & 0x20L) != 0L;
        }

        public final XString getLegName() {
            if (!this.hasLegName() || this._usrLegName.isNull()) {
                return null;
            }
            return this._usrLegName;
        }

        public final void getLegNameTo(XString val) {
            if (!this.hasLegName() || this._usrLegName.isNull()) {
                val.clear();
                return;
            }
            val.setValue(this._usrLegName);
        }

        public final void setLegNameFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearLegName();
                return;
            }
            this._usrLegName.setValue(val);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearLegName();
                return;
            }
            this._usrLegName.setValue(val);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearLegName();
                return;
            }
            this._usrLegName.setValue(val);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrLegName.setValue(val);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearLegName();
                return;
            }
            this._usrLegName.setValue(val, offset, len);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(QuarkString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearLegName();
                return;
            }
            val.getTo(this._usrLegName);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void setLegNameFrom(QuarkStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearLegName();
                return;
            }
            val.getTo(this._usrLegName);
            if (!this.hasLegName()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x20L;
            }
            this._dirty = true;
        }

        public final void clearLegName() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasLegName()) {
                return;
            }
            this._usrLegName.reset();
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFDFL;
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this._usrTimestamp = 0L;
            this._usrQueueTime = 0;
            this._usrProcTime = 0;
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            if (this.hasTimestamp()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)32752, (long)this._usrTimestamp);
            }
            if (this.hasQueueTime()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)32748, (int)this._usrQueueTime);
            }
            if (this.hasProcTime()) {
                len += XbufUtil.primitiveFieldSerializedLength((int)32747, (int)this._usrProcTime);
            }
            if (this.hasTxnId()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32751, (int)this._usrTxnId.length());
            }
            if (this.hasAgentName()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32750, (int)this._usrAgentName.length());
            }
            if (this.hasLegName()) {
                len += XbufUtil.varlenFieldSerializedLength((int)32749, (int)this._usrLegName.length());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasTimestamp()) {
                serializer.timestamp(this._usrTimestamp);
            }
            if (this.hasQueueTime()) {
                serializer.queueTime(this._usrQueueTime);
            }
            if (this.hasProcTime()) {
                serializer.procTime(this._usrProcTime);
            }
            if (this.hasTxnId()) {
                serializer.txnId(this._usrTxnId);
            }
            if (this.hasAgentName()) {
                serializer.agentName(this._usrAgentName);
            }
            if (this.hasLegName()) {
                serializer.legName(this._usrLegName);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityPojoDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleTimestamp(long val) {
                Pojo.this.setTimestamp(val);
            }

            @Override
            public final void handleQueueTime(int val) {
                Pojo.this.setQueueTime(val);
            }

            @Override
            public final void handleProcTime(int val) {
                Pojo.this.setProcTime(val);
            }

            @Override
            public final void handleTxnId(QuarkStringDeserializer val) {
                Pojo.this.setTxnIdFrom(val);
            }

            @Override
            public final void handleAgentName(QuarkStringDeserializer val) {
                Pojo.this.setAgentNameFrom(val);
            }

            @Override
            public final void handleLegName(QuarkStringDeserializer val) {
                Pojo.this.setLegNameFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final QuarkStringDeserializer _stringDeserializer = QuarkStringDeserializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private final QuarkBuffer.VarintDeserializeLength _varintDeserializeLength = new QuarkBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memoryStats.onEntityDeserializerAllocated(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(QuarkBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            block14: for (int pos = this._offset; pos < lim; pos += tlen + flen) {
                int ftag = QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 32752: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 32752");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleTimestamp(QuarkBuffer.getVarint64((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block14;
                    }
                    case 32748: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 32748");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleQueueTime(QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block14;
                    }
                    case 32747: {
                        if (ftype != 0) {
                            throw new IllegalStateException("field type mismatch (exp=0x00, actual=" + ftype + ") for field 32747");
                        }
                        tlen = this._varintDeserializeLength.value;
                        cb.handleProcTime(QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength));
                        flen = this._varintDeserializeLength.value;
                        continue block14;
                    }
                    case 32751: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32751");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleTxnId(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block14;
                    }
                    case 32750: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32750");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleAgentName(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block14;
                    }
                    case 32749: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 32749");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleLegName(this._stringDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block14;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block14;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block14;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = QuarkBuffer.getVarint32((long)addr, (int)(pos + tlen), (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block14;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block14;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (QuarkBuffer.getVarint32((long)addr, (int)pos, (QuarkBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntityDeserializerDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static interface Callback {
            public void handleTimestamp(long var1);

            public void handleQueueTime(int var1);

            public void handleProcTime(int var1);

            public void handleTxnId(QuarkStringDeserializer var1);

            public void handleAgentName(QuarkStringDeserializer var1);

            public void handleLegName(QuarkStringDeserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memoryStats = MemoryStats.getInstance();
        private MessageProcessingTime _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memoryStats.onEntitySerializerAllocated(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(MessageProcessingTime entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(QuarkBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(QuarkBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(QuarkBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getCapacity() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            QuarkBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(QuarkBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            QuarkBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer timestamp(long val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)32752, (long)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262016);
            this._len += QuarkBuffer.putVarint64((long)this._addr, (int)this._len, (long)val);
            return this;
        }

        public final Serializer queueTime(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)32748, (int)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261984);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer procTime(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.primitiveFieldSerializedLength((int)32747, (int)val));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261976);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val);
            return this;
        }

        public final Serializer txnId(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer txnId(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer txnId(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer txnId(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer txnId(byte[] val) {
            return this.txnId(val, 0, val.length);
        }

        public final Serializer txnId(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer txnId(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32751, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262010);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer agentName(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer agentName(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer agentName(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer agentName(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer agentName(byte[] val) {
            return this.agentName(val, 0, val.length);
        }

        public final Serializer agentName(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer agentName(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32750, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)262002);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer legName(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)QuarkBuffer.calculateUTF8Length((CharSequence)val)));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += QuarkBuffer.putUTF8CharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            return this;
        }

        public final Serializer legName(QuarkString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.length()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer legName(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.length());
            val.getBackingBuffer().getToNative(val.getBackingBufferOffset(), this._addr, this._len, val.serializedLength());
            this._len += val.serializedLength();
            return this;
        }

        public final Serializer legName(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            QuarkBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer legName(byte[] val) {
            return this.legName(val, 0, val.length);
        }

        public final Serializer legName(QuarkStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)val.serializedLength()));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer legName(QuarkBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + XbufUtil.varlenFieldSerializedLength((int)32749, (int)len));
            }
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)261994);
            this._len += QuarkBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memoryStats.onEntitySerializerDisposed(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class MessageProcessingTimeDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private MessageProcessingTimeDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memoryStats.onEntityDeserializerLeaked(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageProcessingTimeDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private MessageProcessingTimeDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class MessageProcessingTimeSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private MessageProcessingTimeSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memoryStats.onEntitySerializerLeaked(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageProcessingTimeSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private MessageProcessingTimeSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class MessageProcessingTimePojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private MessageProcessingTimePojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memoryStats.onEntityPojoLeaked(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageProcessingTimePojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private MessageProcessingTimePojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class MessageProcessingTimePoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<MessageProcessingTime> {
        private MessageProcessingTimePoolEvictedItemReceiver() {
        }

        public final void process(MessageProcessingTime evictedItem) {
            _memoryStats.onEntityLeaked(MessageProcessingTime.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class MessageProcessingTimePoolFactory
    implements UtlPool.Factory<MessageProcessingTime> {
        private MessageProcessingTimePoolFactory() {
        }

        public final MessageProcessingTime createItem(Object object) {
            return new MessageProcessingTime();
        }

        public final MessageProcessingTime[] createItemArray(int size) {
            return new MessageProcessingTime[size];
        }
    }

    static final class MessageProcessingTimePoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        MessageProcessingTimePoolFactoryItemCreateArgument() {
        }

        MessageProcessingTimePoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props, boolean direct) {
            super(4362108, props, direct);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props, true);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

