/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.cdc;

import com.neeve.service.cdc.ICdcTracer;
import com.neeve.service.cdc.Runner;
import com.neeve.trace.Tracer;

public abstract class RunnerController {
    protected final Runner _cdcRunner;
    protected final Tracer _tracer;
    protected final String _module;

    public RunnerController(Runner cdcRunner, ICdcTracer tracer, String module) throws Exception {
        this._cdcRunner = cdcRunner;
        this._tracer = tracer.getTracer();
        this._module = module;
    }

    public final void openCdc(boolean async) throws Exception {
        this._cdcRunner.open(async);
        this._tracer.log("CDC (" + this._module + ") opened (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final void startCdc() throws Exception {
        this._cdcRunner.start();
        this._tracer.log("CDC (" + this._module + ") started (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final void stopCdc(boolean async) {
        this._cdcRunner.stop(async);
        this._tracer.log("CDC (" + this._module + ") stopped (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final void enableCdc() {
        this._cdcRunner.enable();
        this._tracer.log("CDC (" + this._module + ") enabled (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final void disableCdc() {
        this._cdcRunner.disable();
        this._tracer.log("CDC (" + this._module + ") disabled (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final void dumpCdcInfo() {
        this._cdcRunner.info();
    }

    public final void closeCdc() {
        this._cdcRunner.close();
        this._tracer.log("CDC (" + this._module + ") closed (state=" + (Object)((Object)this._cdcRunner.state()) + ").", Tracer.Level.INFO);
    }

    public final String handleCdcOpen(String command, String[] args) throws Exception {
        this.openCdc(true);
        return "OK ";
    }

    public final String handleCdcOpenDone(String command, String[] args) throws Exception {
        Runner.State state = this._cdcRunner.state();
        switch (state) {
            case Init: {
                return "NOK [ERROR] CDC was not opened [state = '" + (Object)((Object)state) + "']";
            }
            case Opening: {
                return "NOK CDC is still opening [state = " + (Object)((Object)this._cdcRunner.openingState()) + "]";
            }
        }
        return "OK ";
    }

    public final String handleCdcStart(String command, String[] args) throws Exception {
        this.startCdc();
        return "OK ";
    }

    public final String handleCdcState(String command, String[] args) throws Exception {
        return this._cdcRunner.state().toString();
    }

    public final String handleCdcStop(String command, String[] args) throws Exception {
        this.stopCdc(true);
        return "OK ";
    }

    public final String handleCdcStopDone(String command, String[] args) throws Exception {
        Runner.State state = this._cdcRunner.state();
        switch (state) {
            case Init: 
            case Opening: 
            case Opened: 
            case OpenFailed: 
            case Started: {
                return "NOK [ERROR] CDC stop was not initiated [state='" + (Object)((Object)state) + "']";
            }
            case Stopping: {
                return "NOK CDC is still stopping";
            }
        }
        return "OK ";
    }

    public final String handleCdcEnable(String command, String[] args) throws Exception {
        this.enableCdc();
        return "OK ";
    }

    public final String handleCdcDisable(String command, String[] args) throws Exception {
        this.disableCdc();
        return "OK ";
    }

    public final String handleCdcInfo(String command, String[] args) throws Exception {
        this.dumpCdcInfo();
        return "OK ";
    }

    public final String handleCdcClose(String command, String[] args) throws Exception {
        this.closeCdc();
        return "OK ";
    }
}

