/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.neeve.blog.Blogger;
import com.neeve.rog.IRogNode;
import com.neeve.service.IMessageProcessingStatsTracer;
import com.neeve.service.IdentityInformationProvider;
import com.neeve.service.entities.MessageProcessingTime;
import com.neeve.service.entities.MessageProcessingTimeLogElement;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

@Singleton
public final class MessageProcessingStatsCollector {
    private final Map<Class<?>, TypeStats> _typeStatsTable = new HashMap();
    private final IdentityInformationProvider _identityInfoProvider;
    private final String _logName;
    private final Blogger _blogger;
    private final int _traceInterval;
    private final ScheduledThreadPoolExecutor _traceExecutor;
    private final Tracer _tracer;
    private volatile long _startTime;
    private volatile long _deltaStartTime;
    private volatile boolean _loggingEnabled;

    @Inject
    public MessageProcessingStatsCollector(@Named(value="nv.service.mps.logging.enabled") Boolean loggingEnabled, @Named(value="nv.service.mps.logging.location") String loggingLocation, IdentityInformationProvider identityProvider, @Named(value="nv.service.mps.trace.interval") Integer traceInterval, IMessageProcessingStatsTracer tracer) {
        this._loggingEnabled = loggingEnabled;
        this._identityInfoProvider = identityProvider;
        this._logName = this._identityInfoProvider.getAgentName() + "-mps";
        this._blogger = Blogger.create((String)this._logName).setLocation(loggingLocation);
        this._traceInterval = traceInterval;
        this._traceExecutor = this._traceInterval > 0 ? new ScheduledThreadPoolExecutor(1, new TraceExecutorThreadFactory()) : null;
        if (this._traceExecutor != null) {
            this._traceExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
        this._tracer = tracer.getTracer();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stamp() {
        this._deltaStartTime = System.currentTimeMillis();
        Map<Class<?>, TypeStats> map = this._typeStatsTable;
        synchronized (map) {
            for (TypeStats stats : this._typeStatsTable.values()) {
                stats.stamp();
            }
        }
    }

    public final String getLogName() {
        return this._logName;
    }

    public final void open() throws Exception {
        this._blogger.open();
        if (this._traceExecutor != null) {
            this._traceExecutor.scheduleWithFixedDelay(new TraceExecutor(), this._traceInterval, this._traceInterval, TimeUnit.SECONDS);
        }
    }

    public final MessageProcessingStatsCollector enableLogging(boolean val) {
        this._loggingEnabled = val;
        return this;
    }

    public final boolean isLoggingEnabled() {
        return this._loggingEnabled;
    }

    public final void setLogCompactionThreshold(int val) throws Exception {
        this._blogger.setLogCompactionThreshold(val);
    }

    public final void scheduleLogCompactionOnNextWrite() throws Exception {
        this._blogger.scheduleLogCompactionOnNextWrite();
    }

    public final void log(MessageProcessingTime mpt) {
        if (this._loggingEnabled) {
            MessageProcessingTimeLogElement mptle = MessageProcessingTimeLogElement.create();
            mptle.setTime(mpt);
            try {
                this._blogger.log((IRogNode)mptle);
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to log message processing time [" + e.toString() + "]").append("\n");
                sb.append("Stack trace:").append("\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                this._tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Class<?>> getTypes() {
        Map<Class<?>, TypeStats> map = this._typeStatsTable;
        synchronized (map) {
            ArrayList list = new ArrayList();
            for (Class<?> type : this._typeStatsTable.keySet()) {
                list.add(type);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeStats getTypeStats(Class<?> type) {
        Map<Class<?>, TypeStats> map = this._typeStatsTable;
        synchronized (map) {
            TypeStats stats = this._typeStatsTable.get(type);
            if (stats == null) {
                stats = new TypeStats(type.getSimpleName());
                this._typeStatsTable.put(type, stats);
            }
            return stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Map<Class<?>, TypeStats> map = this._typeStatsTable;
        synchronized (map) {
            this._typeStatsTable.clear();
        }
        this._startTime = System.currentTimeMillis();
        this.stamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trace() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %s\n", "DISP", "RATE", "DRATE", "COMP", "RATE", "DRATE", "QMED", "QMEAN", "QMIN", "QMAX", "Q75", "Q90", "Q99", "PMED", "PMEAN", "PMIN", "PMAX", "P75", "P90", "P99", "TYPE"));
        Map<Class<?>, TypeStats> map = this._typeStatsTable;
        synchronized (map) {
            if (this._typeStatsTable.size() > 0) {
                for (TypeStats stats : this._typeStatsTable.values()) {
                    stats.get(sb);
                }
            } else {
                sb.append("...0 message types.");
            }
        }
        sb.append("\n");
        this.stamp();
        this._tracer.log("\n" + sb.toString(), Tracer.Level.INFO);
    }

    public final void close() {
        if (this._traceExecutor != null) {
            this._traceExecutor.shutdown();
        }
        if (this._blogger.isOpen()) {
            this._blogger.close();
        }
    }

    public final class TypeStats {
        private final String _typeName;
        private final Times _procTimes;
        private final Times _queueTimes;
        private volatile long _numDispatched;
        private volatile long _numComplete;
        private volatile long _numErrors;
        private volatile long _numDispatchedLast;
        private volatile long _numCompleteLast;
        private static final long billion = 1000000000L;
        private static final long million = 1000000L;
        private static final long hunthou = 100000L;
        private static final long thou = 1000L;
        private static final long ten = 10L;

        TypeStats(String typeName) {
            this._typeName = typeName;
            this._procTimes = new Times();
            this._queueTimes = new Times();
        }

        private final String counterToStr(long val) {
            if (val >= 1000000000L) {
                return String.format("%.1f", (double)val / 1.0E9) + "B";
            }
            if (val >= 1000000L) {
                return String.format("%.1f", (double)val / 1000000.0) + "M";
            }
            if (val >= 100000L) {
                return String.format("%d", val / 1000L) + "K";
            }
            return String.format("%d", val);
        }

        private final String rateToStr(double val) {
            if (val >= 1.0E9) {
                return String.format("%.2f", val / 1.0E9) + "B";
            }
            if (val >= 1000000.0) {
                return String.format("%.2f", val / 1000000.0) + "M";
            }
            if (val >= 100000.0) {
                return String.format("%d", (long)val / 1000L) + "K";
            }
            if (val >= 1000.0) {
                return String.format("%.1f", val / 1000.0) + "K";
            }
            if (val >= 10.0) {
                return String.format("%d", (long)val);
            }
            if (val >= 1.0) {
                return String.format("%.1f", val);
            }
            return String.format("%.2f", val);
        }

        private final String latencyToStr(double val) {
            if (val >= 1000000.0) {
                return String.format("%.2f", val / 1000000.0) + "s";
            }
            if (val >= 1000.0) {
                return String.format("%.1f", val / 1000.0) + "m";
            }
            return String.format("%d", (long)val) + "u";
        }

        final void stamp() {
            this._numDispatchedLast = this._numDispatched;
            this._numCompleteLast = this._numComplete;
        }

        final void get(StringBuilder sb) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - MessageProcessingStatsCollector.this._deltaStartTime;
            long deltaTotalTime = currentTime - MessageProcessingStatsCollector.this._startTime;
            long numDispatchedCurrent = this._numDispatched;
            long numCompleteCurrent = this._numComplete;
            long numErrorsCurrent = this._numErrors;
            double dispatchRate = (double)numDispatchedCurrent * 1000.0 / (double)deltaTotalTime;
            double deltaDispatchRate = ((double)numDispatchedCurrent - (double)this._numDispatchedLast) * 1000.0 / (double)deltaTime;
            double completionRate = (double)numCompleteCurrent * 1000.0 / (double)deltaTotalTime;
            double deltaCompletionRate = ((double)numCompleteCurrent - (double)this._numCompleteLast) * 1000.0 / (double)deltaTime;
            DoubleArrayList list = new DoubleArrayList(this._procTimes.size);
            for (int i = 0; i < this._procTimes.size; ++i) {
                list.add((double)this._procTimes.values[i]);
            }
            list.sort();
            double rmean = list.size() > 0 ? Descriptive.mean((DoubleArrayList)list) : 0.0;
            double rmedian = list.size() > 0 ? Descriptive.median((DoubleArrayList)list) : 0.0;
            double rmin = list.size() > 0 ? Descriptive.min((DoubleArrayList)list) : 0.0;
            double rmax = list.size() > 0 ? Descriptive.max((DoubleArrayList)list) : 0.0;
            double rpct75 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.75) : 0.0;
            double rpct90 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.9) : 0.0;
            double rpct99 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.99) : 0.0;
            list = new DoubleArrayList(this._queueTimes.size);
            for (int i = 0; i < this._queueTimes.size; ++i) {
                list.add((double)this._queueTimes.values[i]);
            }
            list.sort();
            double qmean = list.size() > 0 ? Descriptive.mean((DoubleArrayList)list) : 0.0;
            double qmedian = list.size() > 0 ? Descriptive.median((DoubleArrayList)list) : 0.0;
            double qmin = list.size() > 0 ? Descriptive.min((DoubleArrayList)list) : 0.0;
            double qmax = list.size() > 0 ? Descriptive.max((DoubleArrayList)list) : 0.0;
            double qpct75 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.75) : 0.0;
            double qpct90 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.9) : 0.0;
            double qpct99 = list.size() > 0 ? Descriptive.quantile((DoubleArrayList)list, (double)0.99) : 0.0;
            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %s\n", this.counterToStr(numDispatchedCurrent), this.rateToStr(dispatchRate), this.rateToStr(deltaDispatchRate), this.counterToStr(numCompleteCurrent), this.rateToStr(completionRate), this.rateToStr(deltaCompletionRate), this.latencyToStr(qmedian), this.latencyToStr(qmean), this.latencyToStr(qmin), this.latencyToStr(qmax), this.latencyToStr(qpct75), this.latencyToStr(qpct90), this.latencyToStr(qpct99), this.latencyToStr(rmedian), this.latencyToStr(rmean), this.latencyToStr(rmin), this.latencyToStr(rmax), this.latencyToStr(rpct75), this.latencyToStr(rpct90), this.latencyToStr(rpct99), this._typeName));
        }

        public final void onProcessingStart() {
            ++this._numDispatched;
        }

        public final void onProcessingComplete(String txnId, int queueTime, int procTime) {
            ++this._numComplete;
            this._queueTimes.add(queueTime);
            this._procTimes.add(procTime);
            if (MessageProcessingStatsCollector.this._loggingEnabled) {
                MessageProcessingTime mpt = MessageProcessingTime.create();
                mpt.setTimestamp(System.currentTimeMillis());
                mpt.setTxnId(txnId);
                mpt.setAgentName(MessageProcessingStatsCollector.this._identityInfoProvider.getAgentName());
                mpt.setLegName(this._typeName);
                mpt.setQueueTime(queueTime);
                mpt.setProcTime(procTime);
                MessageProcessingStatsCollector.this.log(mpt);
            }
        }

        public final void onError() {
            ++this._numErrors;
        }

        public final void getRawForCsv(StringBuilder sb) {
            int size = this._procTimes.size;
            if (size == this._procTimes.times.length) {
                int first = this._procTimes.next;
                for (int i = 0; i < size; ++i) {
                    int idx = first++ % this._procTimes.times.length;
                    sb.append(this._procTimes.times[idx]).append(",").append((double)this._procTimes.values[idx] / 1000000.0).append("\n");
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    sb.append(this._procTimes.times[i]).append(",").append((double)this._procTimes.values[i] / 1000000.0).append("\n");
                }
            }
        }

        private final class Times {
            private final long[] times = new long[1024];
            private final long[] values = new long[1024];
            private volatile int size = 0;
            private volatile int next = 0;

            private Times() {
            }

            final synchronized void add(long val) {
                if (this.next == this.values.length) {
                    this.next = 0;
                }
                this.times[this.next] = System.currentTimeMillis();
                this.values[this.next++] = val;
                this.size = Math.min(this.size + 1, this.values.length);
            }

            final synchronized long get(int idx) {
                return this.values[idx];
            }
        }
    }

    private final class TraceExecutor
    implements Runnable {
        private TraceExecutor() {
        }

        @Override
        public final void run() {
            MessageProcessingStatsCollector.this.trace();
        }
    }

    private final class TraceExecutorThreadFactory
    implements ThreadFactory {
        private int num;

        private TraceExecutorThreadFactory() {
        }

        @Override
        public final Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("X-Eagle-" + MessageProcessingStatsCollector.this._identityInfoProvider.getAgentName() + "-MpsTracer-" + ++this.num);
            thread.setDaemon(true);
            return thread;
        }
    }
}

