/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModel;
import com.neeve.asm.AsmModule;
import com.neeve.asm.AsmObject;
import com.neeve.asm.AsmOperation;
import com.neeve.asm.AsmStreamingPeer;
import com.neeve.asm.EAsmException;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgExtendedDOMBuilder;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.ECgException;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AsmXMLParser
extends AsmObject {
    private final File modelFile;
    private final File modelsDir;
    private final Document doc;
    private final Element messagesElement;
    private final Element stateElement;
    private final NodeList moduleElements;
    private final NodeList peerElements;
    private final NodeList streamingPeerElements;
    private final NodeList operationElements;

    private AsmXMLParser(File modelFile, File modelsDir, CgResourceChangeTracker parseContext) throws Exception {
        URL modelUrl;
        this.modelFile = modelFile;
        this.modelsDir = modelsDir;
        try {
            modelUrl = modelFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new EAsmException("Error opening model: " + modelFile + " " + ex.getMessage(), ex);
        }
        try {
            this.doc = CgExtendedDOMBuilder.readXML((URL)modelUrl, (String)"/x-asml.xsd", (PrintStream)System.out, (CgResourceChangeTracker)parseContext);
        }
        catch (ECgException ex) {
            if (ex.getCodeSource() != null) {
                throw new EAsmException(ex.getMessage(), (Throwable)ex, ex.getCodeSource());
            }
            if (ex.getAggregatedErrors() != null) {
                throw new EAsmException(ex.getMessage(), (Throwable)ex, ex.getAggregatedErrors());
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
        NodeList messagesElements = this.doc.getElementsByTagName("messages");
        this.messagesElement = (Element)messagesElements.item(0);
        NodeList stateElements = this.doc.getElementsByTagName("state");
        if (stateElements.getLength() != 1) {
            throw new IllegalStateException("There must be exactly one state element");
        }
        this.stateElement = (Element)stateElements.item(0);
        this.moduleElements = this.doc.getElementsByTagName("module");
        this.peerElements = this.doc.getElementsByTagName("service");
        NodeList streamingPeersElements = this.doc.getElementsByTagName("streaming-peers");
        this.streamingPeerElements = streamingPeersElements.getLength() > 0 ? ((Element)streamingPeersElements.item(0)).getElementsByTagName("peer") : null;
        this.operationElements = this.doc.getElementsByTagName("operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File resolveModelFile(AsmXMLParser parser, File thisModelFile, File modelsDir, String referencedModelFilename, String referencingElementName) throws IOException {
        if (referencedModelFilename == null || referencedModelFilename.trim().length() == 0) {
            throw new IllegalArgumentException("referenced model file name (in the '" + referencingElementName + "' element) cannot be null or empty");
        }
        File file = new File(referencedModelFilename);
        if (file.isAbsolute()) {
            return file;
        }
        if (modelsDir != null && (file = new File(modelsDir + File.separator + referencedModelFilename)).exists()) {
            return file;
        }
        if (thisModelFile != null && (file = new File(thisModelFile.getParentFile().getCanonicalPath() + File.separator + referencedModelFilename).getCanonicalFile()).exists()) {
            return file;
        }
        URL url = ((Object)((Object)parser)).getClass().getResource("/" + referencedModelFilename);
        if (url != null) {
            InputStream is = url.openStream();
            try {
                File file2 = UtlFile.copyToTempFile((InputStream)is);
                return file2;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new FileNotFoundException("model file '" + referencedModelFilename + " could not be located");
    }

    private final AsmDocumentation parseElementDocumentation(Element element, String modelType) throws EAdmException {
        NodeList documentation;
        Node briefDoc = element.getAttributes().getNamedItem("doc");
        String brief = null;
        if (briefDoc != null) {
            brief = briefDoc.getNodeValue();
        }
        if ((documentation = element.getElementsByTagName("documentation")).getLength() > 0 && documentation.item(0).getParentNode() == element) {
            AsmDocumentation doc = new AsmDocumentation(modelType);
            doc.setBrief(brief);
            Element docElement = (Element)documentation.item(0);
            if (docElement.hasAttribute("brief")) {
                doc.setBrief(docElement.getAttribute("brief"));
            }
            if (docElement.getChildNodes().getLength() > 0) {
                Text text = (Text)docElement.getChildNodes().item(0);
                doc.setFull(text.getWholeText());
            }
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)docElement));
            return doc;
        }
        if (brief != null) {
            AsmDocumentation doc = new AsmDocumentation(modelType);
            doc.setBrief(briefDoc.getTextContent());
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)element));
            return doc;
        }
        return null;
    }

    private final void parseModules(AsmModel model) throws Exception {
        for (int i = 0; i < this.moduleElements.getLength(); ++i) {
            Element moduleElement = (Element)this.moduleElements.item(i);
            AsmModule module = new AsmModule(moduleElement.getAttributes().getNamedItem("class").getNodeValue());
            module.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)moduleElement));
            model.addModule(module);
        }
    }

    private final void parsePeers(AsmModel model) throws Exception {
        for (int i = 0; i < this.peerElements.getLength(); ++i) {
            Element peerElement = (Element)this.peerElements.item(i);
            model.addPeer(AsmXMLParser.parse(AsmXMLParser.resolveModelFile(this, this.modelFile, this.modelsDir, peerElement.getAttributes().getNamedItem("modelFile").getNodeValue(), "service")));
        }
    }

    private final void parseStreamingPeers(AsmModel model) throws Exception {
        if (this.streamingPeerElements != null) {
            for (int i = 0; i < this.streamingPeerElements.getLength(); ++i) {
                Element peerElement = (Element)this.streamingPeerElements.item(i);
                AdmModel messagesModel = AdmXMLParser.parse((File)AsmXMLParser.resolveModelFile(this, this.modelFile, this.modelsDir, peerElement.getAttributes().getNamedItem("modelFile").getNodeValue(), "messages"));
                AsmStreamingPeer streamingPeer = new AsmStreamingPeer(messagesModel);
                NodeList messageElements = peerElement.getElementsByTagName("message");
                for (int j = 0; j < messageElements.getLength(); ++j) {
                    Element messageElement = (Element)messageElements.item(j);
                    String messageName = messageElement.getAttributes().getNamedItem("name").getNodeValue();
                    String channelName = messageElement.getAttributes().getNamedItem("channel").getNodeValue();
                    AdmMessage message = messagesModel.getMessage(messageName);
                    if (message == null) {
                        throw new EAsmException("failed to resolve streaming peer message '" + messageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
                    }
                    Node keyNode = messageElement.getAttributes().getNamedItem("key");
                    String key = keyNode != null ? keyNode.getNodeValue() : null;
                    Node filterNode = messageElement.getAttributes().getNamedItem("filter");
                    String filter = filterNode != null ? filterNode.getNodeValue() : null;
                    AsmStreamingPeer.Channel channel = streamingPeer.getChannel(channelName);
                    if (channel == null) {
                        channel = streamingPeer.addChannel(channelName, key, filter);
                    } else {
                        if (!StringUtils.equals((String)channel.getKey(), (String)key)) {
                            throw new EAsmException("channel '" + channelName + "' for streaming peer message '" + messageName + "' -- same channel across messages must have same key", CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
                        }
                        if (!StringUtils.equals((String)channel.getFilter(), (String)filter)) {
                            throw new EAsmException("channel '" + channelName + "' for streaming peer message '" + messageName + "' -- same channel across messages must have same filter", CgExtendedDOMBuilder.getCodeSource((Node)messageElement));
                        }
                    }
                    streamingPeer.addMessage(message, messageName, channel);
                }
                streamingPeer.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)peerElement));
                model.addStreamingPeer(streamingPeer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseOperations(AsmModel model, AdmModel eagleMessagesModel) throws Exception {
        AdmMessage nullMessage = eagleMessagesModel.getMessage("NullMessage");
        HashSet<String> operationNames = new HashSet<String>();
        HashSet<String> inMessageNames = new HashSet<String>();
        for (int i = 0; i < this.operationElements.getLength(); ++i) {
            void var16_20;
            List<Object> resolvedOutMessages;
            String outMessageName;
            Element operationElement = (Element)this.operationElements.item(i);
            String name = operationElement.getAttributes().getNamedItem("name").getNodeValue();
            if (operationNames.contains(name)) {
                throw new EAsmException("duplicate operation name '" + name + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            operationNames.add(name);
            String type = operationElement.getAttributes().getNamedItem("type").getNodeValue();
            String inMessageName = operationElement.getAttributes().getNamedItem("inMessage").getNodeValue();
            if (inMessageNames.contains(inMessageName)) {
                throw new EAsmException("duplicate operation inbound message '" + inMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            inMessageNames.add(inMessageName);
            List<AdmMessage> resolvedInMessages = model.resolveMessage(inMessageName);
            if (resolvedInMessages == null || resolvedInMessages.size() == 0) {
                throw new EAsmException("failed to resolve operation inbound message '" + inMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            if (resolvedInMessages.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("ambiguous operation inbound message '" + inMessageName + "'").append("\n");
                for (AdmMessage message : resolvedInMessages) {
                    sb.append("...").append(message.getFullName());
                }
                throw new EAsmException(sb.toString(), CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            String string = outMessageName = operationElement.getAttributes().getNamedItem("outMessage") != null ? operationElement.getAttributes().getNamedItem("outMessage").getNodeValue() : null;
            if (outMessageName == null) {
                resolvedOutMessages = new ArrayList();
                resolvedOutMessages.add(nullMessage);
            } else {
                resolvedOutMessages = model.resolveMessage(outMessageName);
            }
            if (resolvedOutMessages == null || resolvedOutMessages.size() == 0) {
                throw new EAsmException("failed to resolve operation outbound message '" + outMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            if (resolvedOutMessages != null && resolvedOutMessages.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("ambiguous operation outbound message '" + outMessageName + "'").append("\n");
                for (AdmMessage admMessage : resolvedOutMessages) {
                    sb.append("...").append(admMessage.getFullName());
                }
                throw new EAsmException(sb.toString(), CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            LinkedHashSet<AdmMessage> eventMessages = new LinkedHashSet<AdmMessage>();
            NodeList eventElements = operationElement.getElementsByTagName("event");
            boolean bl = false;
            while (var16_20 < eventElements.getLength()) {
                Element eventElement = (Element)eventElements.item((int)var16_20);
                String eventMessageName = eventElement.getAttributes().getNamedItem("message").getNodeValue();
                List<AdmMessage> resolvedEventMessages = model.resolveMessage(eventMessageName);
                if (resolvedEventMessages == null || resolvedEventMessages.size() == 0) {
                    throw new EAsmException("failed to resolve operation event message '" + eventMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)eventElement));
                }
                if (resolvedEventMessages.size() > 1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("ambiguous operation event message '" + eventMessageName + "'").append("\n");
                    for (AdmMessage message : resolvedEventMessages) {
                        sb.append("...").append(message.getFullName());
                    }
                    throw new EAsmException(sb.toString(), CgExtendedDOMBuilder.getCodeSource((Node)eventElement));
                }
                eventMessages.add(resolvedEventMessages.get(0));
                ++var16_20;
            }
            String string2 = operationElement.getAttributes().getNamedItem("RESTPath") != null ? operationElement.getAttributes().getNamedItem("RESTPath").getNodeValue() : null;
            String restMethod = operationElement.getAttributes().getNamedItem("RESTMethod") != null ? operationElement.getAttributes().getNamedItem("RESTMethod").getNodeValue() : "POST";
            int partition = operationElement.getAttributes().getNamedItem("partition") != null ? Integer.parseInt(operationElement.getAttributes().getNamedItem("partition").getNodeValue()) : 0;
            AsmDocumentation documentation = this.parseElementDocumentation(operationElement, "Operation");
            AsmOperation operation = new AsmOperation(name, AsmOperation.Type.valueOf(type), resolvedInMessages.get(0), resolvedOutMessages != null ? (AdmMessage)resolvedOutMessages.get(0) : null, eventMessages, string2, AsmOperation.RestMethod.valueOf(restMethod), partition, documentation);
            operation.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            model.addOperation(operation);
        }
    }

    @Deprecated
    public static final AsmModel parse(File modelFile, File modelsDir, String namespace) throws EAsmException {
        return AsmXMLParser.parse(modelFile, modelsDir, namespace, null);
    }

    public static final AsmModel parse(File modelFile, File modelsDir, String namespace, CgResourceChangeTracker parseContext) throws EAsmException {
        if (modelFile == null) {
            throw new IllegalArgumentException("model file cannot be null");
        }
        try {
            URL modelUrl;
            AsmXMLParser parser = new AsmXMLParser(modelFile, modelsDir, parseContext);
            Node nameAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("name");
            Node nsAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("namespace");
            Node msgsInAttr = parser.messagesElement.getAttributes().getNamedItem("modelFile");
            Node stateInAttr = parser.stateElement.getAttributes().getNamedItem("modelFile");
            Node stateRootAttr = parser.stateElement.getAttributes().getNamedItem("root");
            AdmModel eagleMessagesModel = AdmXMLParser.parse((File)AsmXMLParser.resolveModelFile(parser, null, null, "com/neeve/service/messages/messages.xml", null), (File)modelsDir, null);
            AdmModel messagesModel = AdmXMLParser.parse((File)AsmXMLParser.resolveModelFile(parser, modelFile, modelsDir, msgsInAttr.getNodeValue(), "messages"), (File)modelsDir, null);
            AdmModel stateModel = AdmXMLParser.parse((File)AsmXMLParser.resolveModelFile(parser, modelFile, modelsDir, stateInAttr.getNodeValue(), "state"), (File)modelsDir, null);
            String stateRootName = stateRootAttr.getNodeValue();
            if (!stateModel.isOf(stateRootName)) {
                throw new EAsmException("specified state root is not in the specified state model", CgExtendedDOMBuilder.getCodeSource((Node)parser.stateElement));
            }
            AdmType stateRoot = stateModel.getType(stateRootName);
            if (stateRoot == null) {
                throw new EAsmException("specified state root is not in the specified state model", CgExtendedDOMBuilder.getCodeSource((Node)parser.stateElement));
            }
            if (!(stateRoot instanceof AdmEntity)) {
                throw new EAsmException("specified state root is not an ADM entity", CgExtendedDOMBuilder.getCodeSource((Node)parser.stateElement));
            }
            String resolvedNamespace = namespace != null ? namespace : nsAttr.getNodeValue();
            AsmModel model = new AsmModel(nameAttr.getNodeValue(), resolvedNamespace, messagesModel, stateModel, (AdmEntity)stateRoot, eagleMessagesModel);
            model.setDocumentation(parser.parseElementDocumentation((Element)parser.doc.getElementsByTagName("model").item(0), "Model"));
            try {
                modelUrl = modelFile.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new EAsmException("Error opening model: " + modelFile + " " + ex.getMessage(), ex);
            }
            model.setCodeSource(new CgCodeSource(modelUrl, 1, 1));
            parser.parseModules(model);
            parser.parsePeers(model);
            parser.parseStreamingPeers(model);
            parser.parseOperations(model, eagleMessagesModel);
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof EAsmException) {
                throw (EAsmException)((Object)e);
            }
            throw new EAsmException(e);
        }
    }

    public static final AsmModel parse(File modelFile) throws EAsmException {
        return AsmXMLParser.parse(modelFile, null, null);
    }
}

