/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.adm.EAdmException;
import com.neeve.asm.AsmModel;
import com.neeve.asm.AsmXMLParser;
import com.neeve.asm.EAsmException;
import com.neeve.build.codegen.CgBuildParameters;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class AsmCodeGenerator {
    private static final Set<String> INPUT_PARAMS_PARSE_INFO_INCLUDE = new TreeSet<String>(Arrays.asList(GenerateParameter.MODEL_FILE.toString(), GenerateParameter.MODELS_DIR.toString(), GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString(), GenerateParameter.MODIFABLE_RESOURCES_DIR.toString(), GenerateParameter.UNMODIFIABLE_OUT_DIR.toString(), GenerateParameter.MODIFIABLE_OUT_DIR.toString(), GenerateParameter.NAMESPACE.toString(), GenerateParameter.ABSOLUTE.toString(), GenerateParameter.NAMESPACE.toString(), GenerateParameter.INCREMENTAL_BUILD.toString()));
    private Set<String> INPUT_PARAMS_PARSE_INFO_EXCLUDE = new TreeSet<String>(Arrays.asList(GenerateParameter.CODEGEN_EVENT_LISTENERS.toString()));
    public static final CgBuildParameters CODEGEN_PARAMS = CgBuildParameters.newInstance().newParameter(GenerateParameter.MODEL_FILE.toString(), "The input file.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.MODELS_DIR.toString(), "Models directory for the project.", new Class[]{File.class, String.class}, false, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString(), "Base resources directory for generated resources unmodifiable by the user.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.MODIFABLE_RESOURCES_DIR.toString(), "Base resources directory for generated resources modifiable by the user.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.UNMODIFIABLE_OUT_DIR.toString(), "Base out directory for the generated files unmodifiable by the user.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.MODIFIABLE_OUT_DIR.toString(), "Base out directory for the generated files modifiable by the user.", new Class[]{File.class, String.class}, true, null).setStringToFileConverter().getParent().newParameter(GenerateParameter.ABSOLUTE.toString(), "Generate all files in output directory (instead of a namespace based directory structure relative to output directory).", new Class[]{Boolean.class, String.class}, true, null).setStringToBooleanConverter().getParent().newParameter(GenerateParameter.NAMESPACE.toString(), "Namespace of model parsed from the input file (overrides namespace in model file if supplied).", new Class[]{String.class}, false, null).getParent().newParameter(GenerateParameter.INCREMENTAL_BUILD.toString(), "Trigger incremental code generation - run only if something changed since last run.", new Class[]{Boolean.class, String.class}, true, (Object)true).getParent().newParameter(GenerateParameter.CODEGEN_EVENT_LISTENERS.toString(), "Listeners to code generation events.", new Class[]{CodegenListener[].class}, false, (Object)new CodegenListener[0]).putAdditionalData("hidden", (Object)"This parameter is for internal use").getParent();
    private final CgBuildParameters parameters = CgBuildParameters.newInstance().adoptParameters(CODEGEN_PARAMS, null);

    private static final void printUsage() {
        System.err.println("Usage AsmCodeGenerator [{-f, --file} the model file] ");
        System.err.println("                       [{-m, --modelsdir} models directory for the project]");
        System.err.println("                       [{-e, --unmodresourcesdir} base resources directory for generated resources unmodifiable by he user]");
        System.err.println("                       [{-r, --modresourcesdir} base resources directory for generated resources modifiable by he user]");
        System.err.println("                       [{-o, --unmodoutdir} base out directory for the generated files unmodifiable by the user]");
        System.err.println("                       [{-p, --modoutdir} base out directory for the generated files modifiable by the user]");
        System.err.println("                       [{-a, --absolute} generate all files in output directory (instead of a namespace based directory structure relative to output directory)]");
        System.err.println("                       [{-n, --namespace} namespace of model parsed from the input file (overrides namespace in model file if supplied)");
        System.err.println("                       [{-h, --help} print this help string]");
        System.exit(1);
    }

    private final Map<String, String> inputOptionsToParseInfo() {
        HashMap<String, String> retVal = new HashMap<String, String>();
        HashSet allParamsSet = new HashSet();
        for (Map.Entry entry : this.parameters.getParameters().entrySet()) {
            allParamsSet.add(entry.getKey());
            if (!INPUT_PARAMS_PARSE_INFO_INCLUDE.contains(entry.getKey())) continue;
            String strValue = ((CgBuildParameters.AdmParameter)entry.getValue()).getValueAsString("null");
            retVal.put((String)entry.getKey(), strValue);
        }
        return retVal;
    }

    public AsmCodeGenerator() {
        TreeSet<String> includeExcludeUnion = new TreeSet<String>(INPUT_PARAMS_PARSE_INFO_INCLUDE);
        includeExcludeUnion.addAll(this.INPUT_PARAMS_PARSE_INFO_EXCLUDE);
        if (!includeExcludeUnion.equals(this.parameters.getParameters().keySet())) {
            throw new IllegalStateException("Incremental build include and exclude list of codegen input params does not add up " + Arrays.toString(this.parameters.getParameters().keySet().toArray()) + "/" + Arrays.toString(INPUT_PARAMS_PARSE_INFO_INCLUDE.toArray()) + "/" + Arrays.toString(this.INPUT_PARAMS_PARSE_INFO_EXCLUDE.toArray()));
        }
    }

    public AsmCodeGenerator setArgument(String name, Object value) {
        this.parameters.newArgument(name, value);
        return this;
    }

    public void generate() throws Exception {
        URL modelUrl;
        CgResourceChangeTracker parseContext = null;
        File modelFile = (File)this.parameters.getValue(GenerateParameter.MODEL_FILE.toString());
        File modelsDir = (File)this.parameters.getValue(GenerateParameter.MODELS_DIR.toString());
        File unmodResourcesDir = (File)this.parameters.getValue(GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString());
        File modResourcesDir = (File)this.parameters.getValue(GenerateParameter.MODIFABLE_RESOURCES_DIR.toString());
        File unmodOutDir = (File)this.parameters.getValue(GenerateParameter.UNMODIFIABLE_OUT_DIR.toString());
        File modOutDir = (File)this.parameters.getValue(GenerateParameter.MODIFIABLE_OUT_DIR.toString());
        boolean absolute = (Boolean)this.parameters.getValue(GenerateParameter.ABSOLUTE.toString());
        String namespace = (String)this.parameters.getValue(GenerateParameter.NAMESPACE.toString());
        if (modelFile == null) {
            throw new IllegalArgumentException("model file cannot be null");
        }
        try {
            modelUrl = modelFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new EAdmException("Error opening model: " + modelFile + " " + ex.getMessage(), (Throwable)ex);
        }
        CgSourceCodeErrorAggregator externalAggregator = new CgSourceCodeErrorAggregator(modelUrl);
        this.fireCodeGenerateEvent(CodeGenerateEventType.START, null, null);
        AsmModel model = AsmXMLParser.parse(modelFile, modelsDir, namespace, parseContext);
        this.fireCodeGenerateEvent(CodeGenerateEventType.MODEL_PARSED, model, externalAggregator);
        if (externalAggregator.getNumErrors() > 0) {
            throw new EAsmException("External listener errors", externalAggregator);
        }
        model.dump();
        model.generateClasses(unmodResourcesDir, modResourcesDir, unmodOutDir, modOutDir, absolute);
        this.fireCodeGenerateEvent(CodeGenerateEventType.END, model, externalAggregator);
        if (externalAggregator.getNumErrors() > 0) {
            throw new EAdmException("External listener errors", externalAggregator);
        }
    }

    @Deprecated
    public static void generate(File modelfile, File modelsdir, File unmodresourcesdir, File modresourcesdir, File unmodoutdir, File modoutdir, String namespace, boolean absolute) throws Exception {
        AsmCodeGenerator generator = new AsmCodeGenerator();
        generator.setArgument(GenerateParameter.MODEL_FILE.toString(), modelfile).setArgument(GenerateParameter.MODELS_DIR.toString(), modelsdir).setArgument(GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString(), unmodresourcesdir).setArgument(GenerateParameter.MODIFABLE_RESOURCES_DIR.toString(), modresourcesdir).setArgument(GenerateParameter.UNMODIFIABLE_OUT_DIR.toString(), unmodoutdir).setArgument(GenerateParameter.MODIFIABLE_OUT_DIR.toString(), modoutdir).setArgument(GenerateParameter.NAMESPACE.toString(), namespace).setArgument(GenerateParameter.ABSOLUTE.toString(), absolute).setArgument(GenerateParameter.INCREMENTAL_BUILD.toString(), true);
        generator.generate();
    }

    public static void main(String[] args) {
        block7: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option modelfileOption = parser.addStringOption('f', "file");
                CmdLineParser.Option modelsdirOption = parser.addStringOption('m', "modelsdir");
                CmdLineParser.Option unmodresourcesdirOption = parser.addStringOption('e', "unmodresourcesdir");
                CmdLineParser.Option modresourcesdirOption = parser.addStringOption('r', "modresourcesdir");
                CmdLineParser.Option unmodoutdirOption = parser.addStringOption('o', "unmodoutdir");
                CmdLineParser.Option modoutdirOption = parser.addStringOption('p', "modoutdir");
                CmdLineParser.Option namespaceOption = parser.addStringOption('n', "namespace");
                CmdLineParser.Option absoluteOption = parser.addBooleanOption('a', "absolute");
                CmdLineParser.Option incrementalOption = parser.addBooleanOption('i', "incremental");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String modelfilename = (String)parser.getOptionValue(modelfileOption, null);
                        String modelsdirname = (String)parser.getOptionValue(modelsdirOption, null);
                        String unmodresourcesdirname = (String)parser.getOptionValue(unmodresourcesdirOption, (Object)"./");
                        String modresourcesdirname = (String)parser.getOptionValue(modresourcesdirOption, (Object)"./");
                        String unmodoutdirname = (String)parser.getOptionValue(unmodoutdirOption, null);
                        String modoutdirname = (String)parser.getOptionValue(modoutdirOption, null);
                        String namespace = (String)parser.getOptionValue(namespaceOption, null);
                        boolean absolute = (Boolean)parser.getOptionValue(absoluteOption, (Object)false);
                        boolean incremental = (Boolean)parser.getOptionValue(incrementalOption, (Object)false);
                        if (modelfilename != null && unmodoutdirname != null && modoutdirname != null) {
                            AsmCodeGenerator generator = new AsmCodeGenerator();
                            generator.setArgument(GenerateParameter.MODEL_FILE.toString(), modelfilename).setArgument(GenerateParameter.MODELS_DIR.toString(), modelsdirname).setArgument(GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString(), unmodresourcesdirname).setArgument(GenerateParameter.MODIFABLE_RESOURCES_DIR.toString(), modresourcesdirname).setArgument(GenerateParameter.UNMODIFIABLE_OUT_DIR.toString(), unmodoutdirname).setArgument(GenerateParameter.MODIFIABLE_OUT_DIR.toString(), modoutdirname).setArgument(GenerateParameter.NAMESPACE.toString(), namespace).setArgument(GenerateParameter.ABSOLUTE.toString(), absolute).setArgument(GenerateParameter.INCREMENTAL_BUILD.toString(), incremental);
                            generator.generate();
                        } else {
                            System.err.println("Input file and both output directories need to be specified");
                            AsmCodeGenerator.printUsage();
                        }
                        break block7;
                    }
                    AsmCodeGenerator.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    AsmCodeGenerator.printUsage();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("Parse error: [" + e.toString() + "]");
            }
        }
    }

    private final void fireCodeGenerateEvent(CodeGenerateEventType e, AsmModel model, CgSourceCodeErrorAggregator errorAggregator) {
        CodegenListener[] codegenListeners = (CodegenListener[])this.parameters.getValue(GenerateParameter.CODEGEN_EVENT_LISTENERS.toString());
        if (codegenListeners != null) {
            for (CodegenListener listener : codegenListeners) {
                listener.codeGenerateEvent(new CodeGenerateEvent(e, model, errorAggregator));
            }
        }
    }

    public static enum GenerateParameter {
        MODEL_FILE,
        MODELS_DIR,
        UNMODIFIABLE_RESOURCES_DIR,
        MODIFABLE_RESOURCES_DIR,
        UNMODIFIABLE_OUT_DIR,
        MODIFIABLE_OUT_DIR,
        ABSOLUTE,
        NAMESPACE,
        INCREMENTAL_BUILD,
        CODEGEN_EVENT_LISTENERS;

    }

    public static interface CodegenListener {
        public void codeGenerateEvent(CodeGenerateEvent var1);
    }

    public class CodeGenerateEvent {
        private CodeGenerateEventType eventType;
        private AsmModel model;
        private CgSourceCodeErrorAggregator errorAggregator;

        private CodeGenerateEvent(CodeGenerateEventType eventType, AsmModel model, CgSourceCodeErrorAggregator errorAggregator) {
            this.eventType = eventType;
            if (eventType == CodeGenerateEventType.MODEL_PARSED || eventType == CodeGenerateEventType.END) {
                if (model == null) {
                    throw new IllegalArgumentException("'model' cannot be null for event MODEL_PARSED");
                }
                this.model = model;
                if (errorAggregator == null) {
                    throw new IllegalArgumentException("'errorAggregator' cannot be null for event MODEL_PARSED");
                }
                this.errorAggregator = errorAggregator;
            }
        }

        public final CodeGenerateEventType getEventType() {
            return this.eventType;
        }

        public final AsmModel getModel() {
            return this.model;
        }

        public final CgSourceCodeErrorAggregator getErrorAggregator() {
            return this.errorAggregator;
        }
    }

    public static enum CodeGenerateEventType {
        START,
        MODEL_PARSED,
        END,
        SKIP;

    }
}

