/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.cdc;

import com.eaio.uuid.UUID;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.neeve.service.IdentityInformationProvider;
import com.neeve.service.cdc.IDbReaderCallback;
import com.neeve.service.cdc.IDbTracer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLRecoverableException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public abstract class DbPersister {
    private final IDbTracer _dbTracer;
    private final String _module;
    private PreparedStatement _sequenceExists;
    private String _tracePrefix;
    private Tracer _tracer;
    @Inject
    @Named(value="nv.service.db.rdbms.enabled")
    protected Boolean _rdbmsEnabled;
    @Inject
    @Named(value="nv.service.db.rdbms.driver")
    protected String _rdbmsDriver;
    @Inject
    @Named(value="nv.service.db.rdbms.url")
    protected String _rdbmsUrl;
    @Inject
    @Named(value="nv.service.db.rdbms.username")
    protected String _rdbmsUsername;
    @Inject
    @Named(value="nv.service.db.rdbms.password")
    protected String _rdbmsPassword;
    @Inject
    @Named(value="nv.service.db.rdbms.createtables")
    protected boolean _rdbmsCreateTables;
    @Inject
    @Named(value="nv.service.db.rdbms.createindexes")
    protected boolean _rdbmsCreateIndexes;
    @Inject
    @Named(value="nv.service.db.rdbms.numreaderthreads")
    protected int _rdbmsNumReaderThreads;
    @Inject
    @Named(value="nv.service.db.rdbms.reconnectfrequency")
    protected long _rdbmsReconnectFrequency;
    @Inject
    @Named(value="nv.service.db.rdbms.reconnectattemptduration")
    protected long _rdbmsReconnectAttemptDuration;
    @Inject
    @Named(value="nv.service.db.influx.enabled")
    protected Boolean _influxEnabled;
    @Inject
    @Named(value="nv.service.db.influx.url")
    protected String _influxUrl;
    @Inject
    @Named(value="nv.service.db.influx.username")
    protected String _influxUsername;
    @Inject
    @Named(value="nv.service.db.influx.password")
    protected String _influxPassword;
    @Inject
    @Named(value="nv.service.db.influx.dbname")
    protected String _influxDbName;
    @Inject
    protected IdentityInformationProvider _identityInfoProvider;
    @Inject
    @Named(value="nv.service.db.influx.mpstats.injectfrequency")
    protected long _influxMpstatsInjectFreq;
    protected Set<String> _tableNames;
    protected Connection _rdbmsConnection;
    private InfluxDB _influxDb;
    public static final String TECHSTATS_RP = "eagle_techstats_rp";
    public static final String TECHSTATS_RP_DURATION = "1w";
    public static final Date MIN_DATE;
    public static final Date MAX_DATE;

    protected DbPersister(IDbTracer dbTracer, String module) {
        this._dbTracer = dbTracer;
        this._module = module;
    }

    private final boolean reconnect() throws Exception {
        try {
            this._rdbmsConnection.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._rdbmsConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long ts = System.currentTimeMillis();
        this._rdbmsCreateTables = false;
        this._rdbmsCreateIndexes = false;
        int i = 1;
        while (true) {
            this.tracer().log(this.tracePrefix() + "Attempt #" + i + " to reconnect after sql recoverable exception... ", Tracer.Level.INFO);
            try {
                this.open();
                return true;
            }
            catch (Exception ex) {
                this.tracer().log(this.tracePrefix() + "Database open failed - " + ex, Tracer.Level.WARNING);
                if (System.currentTimeMillis() - ts >= this._rdbmsReconnectAttemptDuration) {
                    this.tracer().log(this.tracePrefix() + "*** Database reconnect attempts failed. Abandoning attempt...", Tracer.Level.SEVERE);
                    return false;
                }
                Thread.sleep(this._rdbmsReconnectFrequency);
                ++i;
                continue;
            }
            break;
        }
    }

    private final void createSequenceExistsPreparedStatement() throws Exception {
        this._sequenceExists = this._rdbmsConnection.prepareStatement("SELECT COUNT(*) AS N1 FROM user_sequences WHERE sequence_name = ?");
    }

    private final void openRDBMSConnection() throws Exception {
        if (this._rdbmsEnabled.booleanValue()) {
            Class.forName(this._rdbmsDriver).newInstance();
            this.tracer().log(this.tracePrefix() + "Opening RDBMS connection '" + this._rdbmsUsername + "@" + this._rdbmsUrl + "'...", Tracer.Level.INFO);
            Properties props = new Properties();
            props.put("user", this._rdbmsUsername);
            props.put("password", this._rdbmsPassword);
            this._rdbmsConnection = DriverManager.getConnection(this._rdbmsUrl, props);
            this._rdbmsConnection.setAutoCommit(false);
            this._rdbmsConnection.setHoldability(2);
            this.tracer().log(this.tracePrefix() + "...successfully opened", Tracer.Level.INFO);
        }
    }

    private final void closeRDBMSConnection() {
        if (this._rdbmsEnabled.booleanValue()) {
            this.tracer().log(this.tracePrefix() + "Closing RDBMS connection...", Tracer.Level.INFO);
            try {
                if (this._rdbmsConnection != null && this._rdbmsConnection.isValid(1)) {
                    if (this._rdbmsConnection != null) {
                        this._rdbmsConnection.close();
                    }
                    this._rdbmsConnection = null;
                }
                this.tracer().log(this.tracePrefix() + "Closed successfully.", Tracer.Level.INFO);
            }
            catch (Exception e) {
                this.tracer().log(this.tracePrefix() + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
            }
        }
    }

    private final boolean createInfluxRetentionPolicyIfAbsent(InfluxDB influxDb, String influxDbName, String retentionPolicy, String duration, boolean makeDefault) {
        QueryResult rpResult = influxDb.query(new Query("SHOW RETENTION POLICIES ON " + influxDbName, influxDbName));
        if (!rpResult.hasError()) {
            for (QueryResult.Result result : rpResult.getResults()) {
                for (List row : ((QueryResult.Series)result.getSeries().get(0)).getValues()) {
                    if (!retentionPolicy.equals(row.get(0))) continue;
                    this.tracer().log(this.tracePrefix() + "Retention policy " + retentionPolicy + " already exists", Tracer.Level.INFO);
                    return true;
                }
            }
            QueryResult createResult = influxDb.query(new Query("CREATE RETENTION POLICY " + retentionPolicy + " ON " + influxDbName + " DURATION " + duration + " REPLICATION 1 " + (makeDefault ? " DEFAULT" : ""), influxDbName, true));
            if (!createResult.hasError()) {
                this.tracer().log(this.tracePrefix() + "Retention policy " + retentionPolicy + " created", Tracer.Level.INFO);
                return true;
            }
            this.tracer().log(this.tracePrefix() + "Unable to create " + retentionPolicy + " retention policy: " + createResult.getError(), Tracer.Level.WARNING);
        } else {
            this.tracer().log(this.tracePrefix() + "Unable to fetch retention policies: " + rpResult.getError(), Tracer.Level.WARNING);
        }
        return false;
    }

    private final InfluxDB openInfluxConnectionCore() {
        this.tracer().log(this.tracePrefix() + "Opening Influx connection '" + this._influxUsername + "@" + this._influxUrl + "'...", Tracer.Level.INFO);
        InfluxDB influxDb = InfluxDBFactory.connect((String)this._influxUrl, (String)this._influxUsername, (String)this._influxPassword);
        Pong response = influxDb.ping();
        this.tracer().log(this.tracePrefix() + "......" + response, Tracer.Level.INFO);
        if (response.getVersion().equalsIgnoreCase("unknown")) {
            throw new RuntimeException("influx DB ping failed (ping response = )" + response);
        }
        this.tracer().log(this.tracePrefix() + "...successfully opened (Influx version is " + influxDb.version() + ")", Tracer.Level.INFO);
        boolean found = false;
        for (String database : influxDb.describeDatabases()) {
            if (!database.equals(this._influxDbName)) continue;
            found = true;
            break;
        }
        if (!found) {
            influxDb.createDatabase(this._influxDbName);
            this.tracer().log(this.tracePrefix() + "Created the Influx database (dbname='" + this._influxDbName + "').", Tracer.Level.INFO);
        } else {
            this.tracer().log(this.tracePrefix() + "The Influx database (dbname='" + this._influxDbName + "') is already created.", Tracer.Level.INFO);
        }
        if (!this.createInfluxRetentionPolicyIfAbsent(influxDb, this._influxDbName, TECHSTATS_RP, TECHSTATS_RP_DURATION, false)) {
            throw new RuntimeException("Failed to create the 'eagle_techstats_rp' retention policy");
        }
        RetentionPolicy[] additionalRetentionPolicies = this.doGetAdditionalRetentionPolicies();
        if (additionalRetentionPolicies != null) {
            for (RetentionPolicy additionalRetentionPolicy : additionalRetentionPolicies) {
                if (additionalRetentionPolicy == null || this.createInfluxRetentionPolicyIfAbsent(influxDb, this._influxDbName, additionalRetentionPolicy._name, additionalRetentionPolicy._duration, false)) continue;
                throw new RuntimeException("Failed to create the '" + additionalRetentionPolicy._name + "' retention policy");
            }
        }
        return influxDb;
    }

    private final void openInfluxConnection() {
        try {
            if (this._influxEnabled.booleanValue()) {
                this._influxDb = this.openInfluxConnectionCore();
            } else {
                this.tracer().log(this.tracePrefix() + "Configured to not connect to Influx DB.", Tracer.Level.INFO);
            }
        }
        catch (Throwable e) {
            this._influxDb = null;
            this.tracer().log(this.tracePrefix() + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
        }
    }

    private final void closeInfluxConnection() {
        if (this._influxEnabled.booleanValue()) {
            // empty if block
        }
    }

    private final void openConnections() throws Exception {
        this.openRDBMSConnection();
        this.openInfluxConnection();
    }

    private final void closeConnections() {
        this.closeInfluxConnection();
        this.closeRDBMSConnection();
    }

    final String getModule() {
        return this._module;
    }

    final String escape(String str, char escapee) {
        if (str != null && str.length() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == escapee) {
                    sb.append('\\');
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    final String escapeSpaces(String str) {
        return this.escape(str, ' ');
    }

    final void write(Point point, String rp) {
        this.tracer().log(this.tracePrefix() + point.lineProtocol(), Tracer.Level.INFO);
        if (this._influxEnabled.booleanValue()) {
            if (this._influxDb == null) {
                this.openInfluxConnection();
            }
            if (this._influxDb != null) {
                this._influxDb.write(BatchPoints.database((String)this._influxDbName).tag("async", "true").retentionPolicy(rp).consistency(InfluxDB.ConsistencyLevel.ALL).build().point(point));
            } else {
                this.tracer().log(this.tracePrefix() + "...** no influx connection **", Tracer.Level.WARNING);
            }
        } else {
            this.tracer().log(this.tracePrefix() + "...** configured to not post to influx **", Tracer.Level.INFO);
        }
    }

    final void write(Point point) {
        this.write(point, TECHSTATS_RP);
    }

    protected RetentionPolicy[] doGetAdditionalRetentionPolicies() {
        return null;
    }

    protected abstract void doOpen() throws Exception;

    protected abstract void doClose();

    protected abstract void doUpdate(Object var1) throws Exception;

    protected abstract void doDelete(UUID var1) throws Exception;

    protected final String tracePrefix() {
        return this._tracePrefix != null ? this._tracePrefix : (this._tracePrefix = "[DB Persister (" + (this._identityInfoProvider != null ? this._identityInfoProvider.getAgentName() : "null") + (this._module != null ? "-" + this._module : "") + ")] ");
    }

    protected final Tracer tracer() {
        return this._tracer != null ? this._tracer : (this._tracer = this._dbTracer.getTracer());
    }

    public abstract void read(UUID var1, IDbReaderCallback var2) throws Exception;

    public static final boolean isValidDate(Date date) {
        return date.compareTo(MIN_DATE) >= 0 && date.compareTo(MAX_DATE) <= 0;
    }

    public final String getAppName() {
        return this._identityInfoProvider.getName();
    }

    public final int getAppPartition() {
        return this._identityInfoProvider.getPartition();
    }

    public final String getAgentName() {
        return this._identityInfoProvider.getAgentName();
    }

    public final String getServerName() {
        return this._identityInfoProvider.getServerName();
    }

    public final long getInlfuxMpstatsInjectFrequency() {
        return this._influxMpstatsInjectFreq;
    }

    public final void open() throws Exception {
        this.tracer().log(this.tracePrefix() + "Opening...{", Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "...RDBMS {", Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......enabled=" + this._rdbmsEnabled, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......url=" + this._rdbmsUrl, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......username=" + this._rdbmsUsername, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......createtables=" + this._rdbmsCreateTables, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......createindexes=" + this._rdbmsCreateIndexes, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......numreaderthreads=" + this._rdbmsNumReaderThreads, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......reconnectfrequency=" + this._rdbmsReconnectFrequency, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......reconnectattemptduration=" + this._rdbmsReconnectAttemptDuration, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "...}", Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "...Influx {", Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......enabled=" + this._influxEnabled, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......url=" + this._influxUrl, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......username=" + this._influxUsername, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "......influxMpstatsInjectFreq=" + this._influxMpstatsInjectFreq, Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "...}", Tracer.Level.INFO);
        this.tracer().log(this.tracePrefix() + "}", Tracer.Level.INFO);
        this.openConnections();
        if (this._rdbmsEnabled.booleanValue()) {
            this.createSequenceExistsPreparedStatement();
        }
        this.doOpen();
        this.tracer().log(this.tracePrefix() + "Opened successfully.", Tracer.Level.INFO);
    }

    public final Connection getRDBMSConnection() {
        return this._rdbmsConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tableExists(String tableName) throws Exception {
        if (this._rdbmsEnabled.booleanValue()) {
            if (this._tableNames == null || this._tableNames.isEmpty()) {
                this._tableNames = new HashSet<String>();
                String[] types = new String[]{"TABLE"};
                try (ResultSet rs = this._rdbmsConnection.getMetaData().getTables(null, null, null, types);){
                    while (rs.next()) {
                        this._tableNames.add(rs.getString("TABLE_NAME").toUpperCase());
                    }
                }
            }
            return this._tableNames.contains(tableName.toUpperCase());
        }
        throw new IllegalStateException("RDBMS not enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean indexExists(String tableName, String indexName) throws Exception {
        if (this._rdbmsEnabled.booleanValue()) {
            try (ResultSet rs = this._rdbmsConnection.getMetaData().getIndexInfo(null, null, tableName, false, true);){
                while (rs.next()) {
                    String str = rs.getString("INDEX_NAME");
                    if (str == null || !str.equalsIgnoreCase(indexName)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
        throw new IllegalStateException("RDBMS not enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sequenceExists(String sequenceName) throws Exception {
        if (this._rdbmsEnabled.booleanValue()) {
            this._sequenceExists.setString(1, sequenceName);
            try (ResultSet rs = this._sequenceExists.executeQuery();){
                boolean bl = rs.next() && rs.getInt("N1") > 0;
                return bl;
            }
        }
        throw new IllegalStateException("RDBMS not enabled");
    }

    public final Set<String> getTableNames() {
        if (this._rdbmsEnabled.booleanValue()) {
            return this._tableNames;
        }
        throw new IllegalStateException("RDBMS not enabled");
    }

    public final void update(Object object) throws Exception {
        try {
            this.doUpdate(object);
            this.commit();
        }
        catch (SQLRecoverableException e) {
            this.tracer().log(this.tracePrefix() + "Database update failed. Retrying... " + e, Tracer.Level.WARNING);
            if (this.reconnect()) {
                try {
                    this.doUpdate(object);
                    this.commit();
                }
                catch (Exception e1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.tracePrefix()).append("Database update failed (after reconnect) for {" + object.toString() + "}").append("\n");
                    sb.append("Stack trace:").append("\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e1));
                    this.tracer().log(sb.toString(), Tracer.Level.SEVERE);
                    throw e1;
                }
            }
            throw e;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tracePrefix()).append("Database update failed for {" + object.toString() + "}").append("\n");
            sb.append("Stack trace:").append("\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer().log(sb.toString(), Tracer.Level.SEVERE);
            throw e;
        }
    }

    public final void delete(UUID id) throws Exception {
        try {
            this.doDelete(id);
            this.commit();
        }
        catch (SQLRecoverableException e) {
            this.tracer().log(this.tracePrefix() + "Database delete failed [id='" + id.toString() + "']. Retrying... " + e, Tracer.Level.WARNING);
            if (this.reconnect()) {
                try {
                    this.doDelete(id);
                    this.commit();
                }
                catch (Exception e1) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.tracePrefix()).append("Database delete failed (after reconnect) for {" + id.toString() + "}").append("\n");
                    sb.append("Stack trace:").append("\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e1));
                    this.tracer().log(sb.toString(), Tracer.Level.SEVERE);
                    throw e1;
                }
            }
            throw e;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tracePrefix()).append("Database delete failed for {" + id.toString() + "}").append("\n");
            sb.append("Stack trace:").append("\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer().log(sb.toString(), Tracer.Level.SEVERE);
            throw e;
        }
    }

    public final void commit() throws Exception {
        if (this._rdbmsEnabled.booleanValue()) {
            this._rdbmsConnection.commit();
        }
    }

    public final void close() {
        this.doClose();
        this.closeConnections();
    }

    static {
        GregorianCalendar cal = new GregorianCalendar(4712, 1, 1, 0, 0, 0);
        cal.set(0, 0);
        MIN_DATE = cal.getTime();
        cal = new GregorianCalendar(9999, 12, 31, 23, 59, 59);
        cal.set(0, 1);
        MAX_DATE = cal.getTime();
    }

    protected static final class RetentionPolicy {
        final String _name;
        final String _duration;

        public RetentionPolicy(String name, String duration) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            if (duration == null) {
                throw new IllegalArgumentException("duration cannot be null");
            }
            this._name = name;
            this._duration = duration;
        }
    }
}

