/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.neeve.service.EServiceException;
import com.neeve.service.Session;
import com.neeve.service.entities.ErrorCode;
import com.neeve.service.entities.ErrorType;
import com.neeve.service.messages.Credentials;
import com.neeve.service.messages.MessageHeader;
import com.neeve.trace.Tracer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public final class SessionManager {
    private final ConcurrentHashMap<String, Session> _sessions;
    private final Tracer _tracer;

    @Inject
    public SessionManager(Tracer tracer) {
        this._tracer = tracer;
        this._sessions = new ConcurrentHashMap();
    }

    private final boolean authenticate(Credentials credentials) {
        return true;
    }

    private final Session login(Credentials credentials, String sessionId) {
        if (this.authenticate(credentials)) {
            String id = sessionId == null ? UUID.randomUUID().toString() : sessionId;
            String source = credentials.getUsername();
            Session session = new Session(id, source);
            this._sessions.put(id, session);
            if (this._tracer.debug) {
                this._tracer.log(credentials.getUsername() + " logged in", Tracer.Level.DEBUG);
            }
            return session;
        }
        throw new EServiceException(ErrorType.Functional, ErrorCode.InvalidCredentials, "invalid user credentials", null);
    }

    public final Session validateSession(MessageHeader requestHeader) {
        Session session = null;
        String sessionId = requestHeader.getSessionId();
        if (requestHeader.getCredentials() != null) {
            session = this.login(requestHeader.getCredentials(), sessionId);
            requestHeader.setSessionId(session.getId());
        } else if ((sessionId != null ? (session = this._sessions.get(sessionId)) : null) == null) {
            throw new EServiceException(ErrorType.Functional, ErrorCode.InvalidSession, "invalid sessionId '" + sessionId + "'", null);
        }
        return session;
    }

    public final void logout(String sessionId) {
        this._sessions.remove(sessionId);
    }

    public final String user(String sessionId) {
        return sessionId != null && this._sessions.get(sessionId) != null ? this._sessions.get(sessionId).getUser() : null;
    }
}

