/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.service.cdc;

import com.neeve.service.cdc.DbPersister;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.StringTokenizer;
import org.influxdb.dto.Point;

public abstract class DbEntityPersister {
    protected final DbPersister _persister;
    protected Connection _rdbmsConnection;
    public static final Date MIN_DATE;
    public static final Date MAX_DATE;

    protected DbEntityPersister(DbPersister persister) {
        this._persister = persister;
    }

    protected static final String[] fromCommaDelimited(String str) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static final String toCommaDelimited(String[] strs) {
        if (strs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
            if (i >= strs.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected void createTables(boolean createIndexes) throws Exception {
    }

    protected void createPreparedStatements() throws Exception {
    }

    protected void closePreparedStatements() throws Exception {
    }

    protected final String quote(String str) {
        return str != null ? "\"" + str + "\"" : "\"null\"";
    }

    protected final String escapeSpaces(String str) {
        return this._persister.escapeSpaces(str);
    }

    protected final String tracePrefix() {
        return this._persister.tracePrefix();
    }

    protected final Tracer tracer() {
        return this._persister.tracer();
    }

    protected final boolean tableExists(String tableName) throws Exception {
        return this._persister.tableExists(tableName);
    }

    protected final void write(Point point) {
        this._persister.write(point);
    }

    protected final void write(Point point, String rp) {
        this._persister.write(point, rp);
    }

    protected void doOpen() throws Exception {
    }

    protected void doClose() {
    }

    public final boolean indexExists(String tableName, String indexName) throws Exception {
        return this._persister.indexExists(tableName, indexName);
    }

    public final boolean sequenceExists(String sequenceName) throws Exception {
        return this._persister.sequenceExists(sequenceName);
    }

    public final Set<String> getTableNames() {
        return this._persister.getTableNames();
    }

    public static final boolean isValidDate(Date date) {
        return date.compareTo(MIN_DATE) >= 0 && date.compareTo(MAX_DATE) <= 0;
    }

    public final void open(Connection rdbmsConnection, boolean createTables, boolean createIndexes) throws Exception {
        this._rdbmsConnection = rdbmsConnection;
        if (this._rdbmsConnection != null) {
            if (createTables) {
                this.createTables(createIndexes);
            }
            this.createPreparedStatements();
        }
        this.doOpen();
    }

    public final void close() {
        this.doClose();
        try {
            if (this._rdbmsConnection != null && this._rdbmsConnection.isValid(1)) {
                this.closePreparedStatements();
            }
        }
        catch (Throwable e) {
            this.tracer().log(this.tracePrefix() + "Failed to close prepared statements: " + e.toString(), Tracer.Level.WARNING);
            this.tracer().log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
        }
    }

    static {
        GregorianCalendar cal = new GregorianCalendar(4712, 1, 1, 0, 0, 0);
        cal.set(0, 0);
        MIN_DATE = cal.getTime();
        cal = new GregorianCalendar(9999, 12, 31, 23, 59, 59);
        cal.set(0, 1);
        MAX_DATE = cal.getTime();
    }
}

