/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.eagle.mojos.plugin;

import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgSourceCodeErrorAggregator;
import com.neeve.build.codegen.ECgException;
import com.neeve.tools.AsmCodeGenerator;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractEagleCodegenMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="modelFile")
    private File modelFile;
    @Parameter(property="namespace")
    private String namespace;

    private boolean isSourceRoot(File directory) {
        boolean isSourceRoot = false;
        for (String source : this.project.getCompileSourceRoots()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking source root: " + new File(source).getAbsolutePath() + " against " + directory.getAbsolutePath()));
            }
            if (!new File(source).getAbsolutePath().equals(directory.getAbsolutePath())) continue;
            isSourceRoot = true;
            break;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(directory + " is" + (isSourceRoot ? "" : " not") + " a source root"));
        }
        return isSourceRoot;
    }

    private boolean isResourceRoot(File directory) {
        boolean isResourceRoot = false;
        for (Resource resource : this.project.getResources()) {
            String resourceDirName = resource.getDirectory();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Checking source root: " + new File(resourceDirName).getAbsolutePath() + " against " + directory.getAbsolutePath()));
            }
            if (!new File(resourceDirName).getAbsolutePath().equals(directory.getAbsolutePath())) continue;
            isResourceRoot = true;
            break;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(directory + " is" + (isResourceRoot ? "" : " not") + " a resource root"));
        }
        return isResourceRoot;
    }

    public void execute() throws MojoExecutionException {
        Resource resource;
        boolean addToSourceRoot = true;
        for (String source : this.project.getCompileSourceRoots()) {
            if (!new File(source).getAbsolutePath().equals(this.getUnmodifiableFilesOutputDirectory().getAbsolutePath())) continue;
            addToSourceRoot = false;
            break;
        }
        if (!this.getUnmodifiableFilesOutputDirectory().exists()) {
            this.getUnmodifiableFilesOutputDirectory().mkdirs();
        }
        if (addToSourceRoot) {
            this.project.addCompileSourceRoot(this.getUnmodifiableFilesOutputDirectory().getAbsolutePath());
        }
        addToSourceRoot = true;
        for (String source : this.project.getCompileSourceRoots()) {
            if (!new File(source).getAbsolutePath().equals(this.getModifiableFilesOutputDirectory().getAbsolutePath())) continue;
            addToSourceRoot = false;
            break;
        }
        if (!this.getModifiableFilesOutputDirectory().exists()) {
            this.getModifiableFilesOutputDirectory().mkdirs();
        }
        if (addToSourceRoot) {
            this.project.addCompileSourceRoot(this.getModifiableFilesOutputDirectory().getAbsolutePath());
        }
        if (!this.getModifiableResourcesOutputDirectory().exists()) {
            this.getModifiableResourcesOutputDirectory().mkdirs();
        }
        if (!this.isSourceRoot(this.getModifiableResourcesOutputDirectory()) && !this.isResourceRoot(this.getModifiableResourcesOutputDirectory())) {
            resource = new Resource();
            resource.setDirectory(this.getModifiableResourcesOutputDirectory().getAbsolutePath());
            this.getLog().info((CharSequence)("Adding resource directory " + this.getModifiableResourcesOutputDirectory() + " to project resource path"));
            this.project.addResource(resource);
        }
        if (!this.getUnmodifiableResourcesOutputDirectory().exists()) {
            this.getUnmodifiableResourcesOutputDirectory().mkdirs();
        }
        if (!this.isSourceRoot(this.getUnmodifiableResourcesOutputDirectory()) && !this.isResourceRoot(this.getUnmodifiableResourcesOutputDirectory())) {
            resource = new Resource();
            resource.setDirectory(this.getUnmodifiableResourcesOutputDirectory().getAbsolutePath());
            this.getLog().info((CharSequence)("Adding resource directory " + this.getUnmodifiableResourcesOutputDirectory() + " to project resource path"));
            this.project.addResource(resource);
        }
        if (!this.buildContext.hasDelta(this.modelFile)) {
            this.buildContext.removeMessages(this.modelFile);
            return;
        }
        this.getLog().info((CharSequence)("Generating code from model file '" + this.modelFile + "'..."));
        this.getLog().info((CharSequence)("...unmodifiable files output directory = '" + this.getUnmodifiableFilesOutputDirectory() + "'"));
        this.getLog().info((CharSequence)("...modifiable files output directory = '" + this.getModifiableFilesOutputDirectory() + "'"));
        try {
            AsmCodeGenerator.CodegenListener codegenListener = new AsmCodeGenerator.CodegenListener(){

                public void codeGenerateEvent(AsmCodeGenerator.CodeGenerateEvent e) {
                    switch (e.getEventType()) {
                        case START: {
                            AbstractEagleCodegenMojo.this.getLog().debug((CharSequence)"Event fired code generate START");
                            AbstractEagleCodegenMojo.this.getLog().info((CharSequence)("Generating code from model file '" + AbstractEagleCodegenMojo.this.modelFile + " ..."));
                            AbstractEagleCodegenMojo.this.buildContext.removeMessages(AbstractEagleCodegenMojo.this.modelFile);
                            break;
                        }
                        case END: {
                            AbstractEagleCodegenMojo.this.getLog().debug((CharSequence)"Event fired code generate END");
                            AbstractEagleCodegenMojo.this.buildContext.refresh(AbstractEagleCodegenMojo.this.getUnmodifiableFilesOutputDirectory());
                            AbstractEagleCodegenMojo.this.buildContext.refresh(AbstractEagleCodegenMojo.this.getModifiableFilesOutputDirectory());
                            break;
                        }
                        case SKIP: {
                            break;
                        }
                    }
                }
            };
            AsmCodeGenerator.CodegenListener[] listeners = new AsmCodeGenerator.CodegenListener[]{codegenListener};
            AsmCodeGenerator generator = new AsmCodeGenerator();
            generator.setArgument(AsmCodeGenerator.GenerateParameter.MODEL_FILE.toString(), (Object)this.modelFile).setArgument(AsmCodeGenerator.GenerateParameter.MODELS_DIR.toString(), (Object)this.getModelsDirectory()).setArgument(AsmCodeGenerator.GenerateParameter.UNMODIFIABLE_RESOURCES_DIR.toString(), (Object)this.getUnmodifiableResourcesOutputDirectory()).setArgument(AsmCodeGenerator.GenerateParameter.MODIFABLE_RESOURCES_DIR.toString(), (Object)this.getModifiableResourcesOutputDirectory()).setArgument(AsmCodeGenerator.GenerateParameter.UNMODIFIABLE_OUT_DIR.toString(), (Object)this.getUnmodifiableFilesOutputDirectory()).setArgument(AsmCodeGenerator.GenerateParameter.MODIFIABLE_OUT_DIR.toString(), (Object)this.getModifiableFilesOutputDirectory()).setArgument(AsmCodeGenerator.GenerateParameter.NAMESPACE.toString(), (Object)this.namespace).setArgument(AsmCodeGenerator.GenerateParameter.ABSOLUTE.toString(), (Object)false).setArgument(AsmCodeGenerator.GenerateParameter.INCREMENTAL_BUILD.toString(), (Object)false).setArgument(AsmCodeGenerator.GenerateParameter.CODEGEN_EVENT_LISTENERS.toString(), (Object)listeners);
            generator.generate();
        }
        catch (ECgException e) {
            CgCodeSource codeSource = e.getCodeSource();
            CgSourceCodeErrorAggregator aggregatedErrors = e.getAggregatedErrors();
            if (codeSource != null) {
                try {
                    File srcFile = codeSource.getFile();
                    this.buildContext.addMessage(srcFile, codeSource.getLine(), codeSource.getColumnStart(), "Code generation failed: " + e.getMessage(), 2, (Throwable)e);
                }
                catch (Exception e1) {
                    this.getLog().error((CharSequence)("Code generation failed: " + e.getMessage() + " " + codeSource), (Throwable)e);
                }
                throw new MojoExecutionException("Code generation failed: " + e.getMessage() + " " + codeSource, (Exception)((Object)e));
            }
            if (aggregatedErrors != null) {
                try {
                    for (URL url : aggregatedErrors.getErrorMessages().keySet()) {
                        block15: for (CgSourceCodeErrorAggregator.Message message : (Set)aggregatedErrors.getErrorMessages().get(url)) {
                            CgCodeSource source = message.getSrcInfo();
                            URI uri = url.toURI();
                            File srcFile = new File(uri);
                            if (!srcFile.exists()) continue;
                            int lineNumber = 1;
                            int columnNumber = 1;
                            if (source != null) {
                                lineNumber = source.getLine();
                                columnNumber = source.getColumnStart();
                            }
                            int severity = 0;
                            switch (message.getSeverity()) {
                                case ERROR: {
                                    severity = 2;
                                    break;
                                }
                                case INFO: {
                                    continue block15;
                                }
                                case WARNING: {
                                    severity = 1;
                                }
                            }
                            if (severity <= 0) continue;
                            this.buildContext.addMessage(srcFile, lineNumber, columnNumber, message.getMessage(), severity, message.getCause());
                        }
                    }
                }
                catch (Exception e1) {
                    this.getLog().error((CharSequence)("Code generation failed: " + e.getMessage() + " " + codeSource), (Throwable)e);
                }
                throw new MojoExecutionException("Code generation failed: " + e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().error((CharSequence)("Code generation failed: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Code generation failed: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Code generation failed: " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Code generation failed: " + e.getMessage(), e);
        }
    }

    protected abstract File getModelsDirectory();

    protected abstract File getUnmodifiableFilesOutputDirectory();

    protected abstract File getUnmodifiableResourcesOutputDirectory();

    protected abstract File getModifiableResourcesOutputDirectory();

    protected abstract File getModifiableFilesOutputDirectory();
}

