/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.Hasher;

public enum FingerprintHashingStrategy {
    SORT{

        @Override
        public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> collection) {
            ImmutableList<FileSystemLocationFingerprint> immutableList = ImmutableList.sortedCopyOf(collection);
            this.appendCollectionToHasherKeepingOrder(hasher, immutableList);
        }
    }
    ,
    KEEP_ORDER{

        @Override
        public void appendToHasher(Hasher hasher, Collection<FileSystemLocationFingerprint> collection) {
            this.appendCollectionToHasherKeepingOrder(hasher, collection);
        }
    };


    public abstract void appendToHasher(Hasher var1, Collection<FileSystemLocationFingerprint> var2);

    protected void appendCollectionToHasherKeepingOrder(Hasher hasher, Collection<FileSystemLocationFingerprint> collection) {
        for (FileSystemLocationFingerprint fileSystemLocationFingerprint : collection) {
            fileSystemLocationFingerprint.appendToHasher(hasher);
        }
    }
}

