/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.gradle.cache.internal.filelock.FileLockOutcome;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateSerializer;

public class LockStateAccess {
    private final LockStateSerializer protocol;
    private final int stateRegionSize;

    public LockStateAccess(LockStateSerializer lockStateSerializer) {
        this.protocol = lockStateSerializer;
        this.stateRegionSize = 1 + lockStateSerializer.getSize();
    }

    public LockState ensureLockState(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() == 0L) {
            LockState lockState = this.protocol.createInitialState();
            this.writeState(randomAccessFile, lockState);
            return lockState;
        }
        return this.readState(randomAccessFile);
    }

    public void writeState(RandomAccessFile randomAccessFile, LockState lockState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(this.protocol.getVersion());
        this.protocol.write(dataOutputStream, lockState);
        dataOutputStream.flush();
        randomAccessFile.seek(0L);
        randomAccessFile.write(byteArrayOutputStream.toByteArray());
        assert (randomAccessFile.getFilePointer() == (long)this.stateRegionSize);
    }

    public LockState readState(RandomAccessFile randomAccessFile) throws IOException {
        try {
            int n2;
            int n3;
            byte[] byArray = new byte[this.stateRegionSize];
            randomAccessFile.seek(0L);
            for (n2 = 0; n2 < byArray.length && (n3 = randomAccessFile.read(byArray, n2, byArray.length - n2)) >= 0; n2 += n3) {
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte by2 = dataInputStream.readByte();
            if (by2 != this.protocol.getVersion()) {
                throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file. Expected %s, found %s.", this.protocol.getVersion(), by2));
            }
            return this.protocol.read(dataInputStream);
        }
        catch (EOFException eOFException) {
            return this.protocol.createInitialState();
        }
    }

    public FileLockOutcome tryLock(RandomAccessFile randomAccessFile, boolean bl2) throws IOException {
        try {
            FileLock fileLock = randomAccessFile.getChannel().tryLock(0L, this.stateRegionSize, bl2);
            if (fileLock == null) {
                return FileLockOutcome.LOCKED_BY_ANOTHER_PROCESS;
            }
            return FileLockOutcome.acquired(fileLock);
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return FileLockOutcome.LOCKED_BY_THIS_PROCESS;
        }
    }

    public int getRegionEnd() {
        return this.stateRegionSize;
    }
}

