/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix;

import com.gradle.maven.extension.internal.dep.oshi.jna.platform.unix.CLibrary;
import com.gradle.maven.extension.internal.dep.oshi.util.FileUtil;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.nio.ByteBuffer;

public interface SolarisLibc
extends CLibrary {
    public static final SolarisLibc INSTANCE = Native.load("c", SolarisLibc.class);

    public static class Timestruc {
        public NativeLong tv_sec;
        public NativeLong tv_nsec;

        public Timestruc(ByteBuffer byteBuffer) {
            this.tv_sec = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.tv_nsec = FileUtil.readNativeLongFromBuffer(byteBuffer);
        }
    }

    public static class SolarisPrUsage {
        public int pr_lwpid;
        public int pr_count;
        public Timestruc pr_tstamp;
        public Timestruc pr_create;
        public Timestruc pr_term;
        public Timestruc pr_rtime;
        public Timestruc pr_utime;
        public Timestruc pr_stime;
        public Timestruc pr_ttime;
        public Timestruc pr_tftime;
        public Timestruc pr_dftime;
        public Timestruc pr_kftime;
        public Timestruc pr_ltime;
        public Timestruc pr_slptime;
        public Timestruc pr_wtime;
        public Timestruc pr_stoptime;
        public Timestruc[] filltime = new Timestruc[6];
        public NativeLong pr_minf;
        public NativeLong pr_majf;
        public NativeLong pr_nswap;
        public NativeLong pr_inblk;
        public NativeLong pr_oublk;
        public NativeLong pr_msnd;
        public NativeLong pr_mrcv;
        public NativeLong pr_sigs;
        public NativeLong pr_vctx;
        public NativeLong pr_ictx;
        public NativeLong pr_sysc;
        public NativeLong pr_ioch;
        public NativeLong[] filler = new NativeLong[10];

        public SolarisPrUsage(ByteBuffer byteBuffer) {
            int n2;
            this.pr_lwpid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_count = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_tstamp = new Timestruc(byteBuffer);
            this.pr_create = new Timestruc(byteBuffer);
            this.pr_term = new Timestruc(byteBuffer);
            this.pr_rtime = new Timestruc(byteBuffer);
            this.pr_utime = new Timestruc(byteBuffer);
            this.pr_stime = new Timestruc(byteBuffer);
            this.pr_ttime = new Timestruc(byteBuffer);
            this.pr_tftime = new Timestruc(byteBuffer);
            this.pr_dftime = new Timestruc(byteBuffer);
            this.pr_kftime = new Timestruc(byteBuffer);
            this.pr_ltime = new Timestruc(byteBuffer);
            this.pr_slptime = new Timestruc(byteBuffer);
            this.pr_wtime = new Timestruc(byteBuffer);
            this.pr_stoptime = new Timestruc(byteBuffer);
            for (n2 = 0; n2 < this.filltime.length; ++n2) {
                this.filltime[n2] = new Timestruc(byteBuffer);
            }
            this.pr_minf = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_majf = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_nswap = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_inblk = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_oublk = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_msnd = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_mrcv = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_sigs = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_vctx = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_ictx = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_sysc = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_ioch = FileUtil.readNativeLongFromBuffer(byteBuffer);
            for (n2 = 0; n2 < this.filler.length; ++n2) {
                this.filler[n2] = FileUtil.readNativeLongFromBuffer(byteBuffer);
            }
        }
    }

    public static class SolarisLwpsInfo {
        public int pr_flag;
        public int pr_lwpid;
        public Pointer pr_addr;
        public Pointer pr_wchan;
        public byte pr_stype;
        public byte pr_state;
        public byte pr_sname;
        public byte pr_nice;
        public short pr_syscall;
        public byte pr_oldpri;
        public byte pr_cpu;
        public int pr_pri;
        public short pr_pctcpu;
        public short pr_pad;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public byte[] pr_clname = new byte[8];
        public byte[] pr_oldname = new byte[16];
        public int pr_onpro;
        public int pr_bindpro;
        public int pr_bindpset;
        public int pr_lgrp;
        public long pr_last_onproc;
        public byte[] pr_name = new byte[32];

        public SolarisLwpsInfo(ByteBuffer byteBuffer) {
            this.pr_flag = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_lwpid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_addr = FileUtil.readPointerFromBuffer(byteBuffer);
            this.pr_wchan = FileUtil.readPointerFromBuffer(byteBuffer);
            this.pr_stype = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_state = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_sname = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_nice = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_syscall = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr_oldpri = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_cpu = FileUtil.readByteFromBuffer(byteBuffer);
            this.pr_pri = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_pctcpu = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr_pad = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr_start = new Timestruc(byteBuffer);
            this.pr_time = new Timestruc(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_clname);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_oldname);
            this.pr_onpro = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_bindpro = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_bindpset = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_lgrp = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_last_onproc = FileUtil.readLongFromBuffer(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_name);
        }
    }

    public static class SolarisPsInfo {
        public int pr_flag;
        public int pr_nlwp;
        public int pr_pid;
        public int pr_ppid;
        public int pr_pgid;
        public int pr_sid;
        public int pr_uid;
        public int pr_euid;
        public int pr_gid;
        public int pr_egid;
        public Pointer pr_addr;
        public LibCAPI.size_t pr_size;
        public LibCAPI.size_t pr_rssize;
        public LibCAPI.size_t pr_rssizepriv;
        public NativeLong pr_ttydev;
        public short pr_pctcpu;
        public short pr_pctmem;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public Timestruc pr_ctime;
        public byte[] pr_fname = new byte[16];
        public byte[] pr_psargs = new byte[80];
        public int pr_wstat;
        public int pr_argc;
        public Pointer pr_argv;
        public Pointer pr_envp;
        public byte pr_dmodel;
        public byte[] pr_pad2 = new byte[3];
        public int pr_taskid;
        public int pr_projid;
        public int pr_nzomb;
        public int pr_poolid;
        public int pr_zoneid;
        public int pr_contract;
        public int pr_filler;
        public SolarisLwpsInfo pr_lwp;

        public SolarisPsInfo(ByteBuffer byteBuffer) {
            this.pr_flag = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_nlwp = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_pid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_ppid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_pgid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_sid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_uid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_euid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_gid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_egid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_addr = FileUtil.readPointerFromBuffer(byteBuffer);
            this.pr_size = FileUtil.readSizeTFromBuffer(byteBuffer);
            this.pr_rssize = FileUtil.readSizeTFromBuffer(byteBuffer);
            this.pr_rssizepriv = FileUtil.readSizeTFromBuffer(byteBuffer);
            this.pr_ttydev = FileUtil.readNativeLongFromBuffer(byteBuffer);
            this.pr_pctcpu = FileUtil.readShortFromBuffer(byteBuffer);
            this.pr_pctmem = FileUtil.readShortFromBuffer(byteBuffer);
            if (Native.LONG_SIZE > 4) {
                FileUtil.readIntFromBuffer(byteBuffer);
            }
            this.pr_start = new Timestruc(byteBuffer);
            this.pr_time = new Timestruc(byteBuffer);
            this.pr_ctime = new Timestruc(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_fname);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_psargs);
            this.pr_wstat = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_argc = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_argv = FileUtil.readPointerFromBuffer(byteBuffer);
            this.pr_envp = FileUtil.readPointerFromBuffer(byteBuffer);
            this.pr_dmodel = FileUtil.readByteFromBuffer(byteBuffer);
            FileUtil.readByteArrayFromBuffer(byteBuffer, this.pr_pad2);
            this.pr_taskid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_projid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_nzomb = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_poolid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_zoneid = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_contract = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_filler = FileUtil.readIntFromBuffer(byteBuffer);
            this.pr_lwp = new SolarisLwpsInfo(byteBuffer);
        }
    }
}

