/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.oshi.driver.windows.registry;

import com.gradle.maven.extension.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.maven.extension.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InstalledAppsData {
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();

    public static List<ApplicationInfo> queryInstalledApps() {
        ArrayList<ApplicationInfo> arrayList = new ArrayList<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY hKEY = entry.getKey();
            List<String> list = entry.getValue();
            for (String string : list) {
                String[] stringArray;
                for (String string2 : stringArray = Advapi32Util.registryGetKeys(hKEY, string)) {
                    String string3 = string + "\\" + string2;
                    try {
                        String string4 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "DisplayName");
                        String string5 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "DisplayVersion");
                        String string6 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "Publisher");
                        String string7 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallDate");
                        String string8 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallLocation");
                        String string9 = InstalledAppsData.getRegistryValueOrUnknown(hKEY, string3, "InstallSource");
                        long l2 = ParseUtil.parseDateToEpoch(string7, "yyyyMMdd");
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("installLocation", string8);
                        hashMap.put("installSource", string9);
                        ApplicationInfo applicationInfo = new ApplicationInfo(string4, string5, string6, l2, hashMap);
                        arrayList.add(applicationInfo);
                    }
                    catch (Win32Exception win32Exception) {
                        // empty catch block
                    }
                }
            }
        }
        return arrayList;
    }

    private static String getRegistryValueOrUnknown(WinReg.HKEY hKEY, String string, String string2) {
        String string3 = Advapi32Util.registryGetStringValue(hKEY, string, string2);
        return ParseUtil.getStringValueOrUnknown(string3);
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

