/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.file;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.Counters;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.PathFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.file.SimplePathVisitor;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.TrueFileFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.function.UnaryOperator;

public class CountingPathVisitor
extends SimplePathVisitor {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Counters.PathCounters pathCounters;
    private final PathFilter fileFilter;
    private final PathFilter directoryFilter;
    private final UnaryOperator<Path> directoryPostTransformer;

    static IOFileFilter defaultDirectoryFilter() {
        return TrueFileFilter.INSTANCE;
    }

    static UnaryOperator<Path> defaultDirectoryTransformer() {
        return UnaryOperator.identity();
    }

    static IOFileFilter defaultFileFilter() {
        return new SymbolicLinkFileFilter(FileVisitResult.TERMINATE, FileVisitResult.CONTINUE);
    }

    static Counters.PathCounters defaultPathCounters() {
        return Counters.longPathCounters();
    }

    CountingPathVisitor(AbstractBuilder<?, ?> abstractBuilder) {
        super(abstractBuilder);
        this.pathCounters = abstractBuilder.getPathCounters();
        this.fileFilter = abstractBuilder.getFileFilter();
        this.directoryFilter = abstractBuilder.getDirectoryFilter();
        this.directoryPostTransformer = abstractBuilder.getDirectoryPostTransformer();
    }

    public CountingPathVisitor(Counters.PathCounters pathCounters) {
        this((AbstractBuilder<?, ?>)new Builder().setPathCounters(pathCounters));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CountingPathVisitor)) {
            return false;
        }
        CountingPathVisitor countingPathVisitor = (CountingPathVisitor)object;
        return Objects.equals(this.pathCounters, countingPathVisitor.pathCounters);
    }

    public Counters.PathCounters getPathCounters() {
        return this.pathCounters;
    }

    public int hashCode() {
        return Objects.hash(this.pathCounters);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        this.updateDirCounter((Path)this.directoryPostTransformer.apply(path), iOException);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        FileVisitResult fileVisitResult = this.directoryFilter.accept(path, basicFileAttributes);
        return fileVisitResult != FileVisitResult.CONTINUE ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    public String toString() {
        return this.pathCounters.toString();
    }

    protected void updateDirCounter(Path path, IOException iOException) {
        this.pathCounters.getDirectoryCounter().increment();
    }

    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        this.pathCounters.getFileCounter().increment();
        this.pathCounters.getByteCounter().add(basicFileAttributes.size());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && this.fileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE) {
            this.updateFileCounters(path, basicFileAttributes);
        }
        return FileVisitResult.CONTINUE;
    }

    public static class Builder
    extends AbstractBuilder<CountingPathVisitor, Builder> {
    }

    public static abstract class AbstractBuilder<T, B extends AbstractBuilder<T, B>>
    extends SimplePathVisitor.AbstractBuilder<T, B> {
        private Counters.PathCounters pathCounters = CountingPathVisitor.defaultPathCounters();
        private PathFilter fileFilter = CountingPathVisitor.defaultFileFilter();
        private PathFilter directoryFilter = CountingPathVisitor.defaultDirectoryFilter();
        private UnaryOperator<Path> directoryPostTransformer = CountingPathVisitor.defaultDirectoryTransformer();

        PathFilter getDirectoryFilter() {
            return this.directoryFilter;
        }

        UnaryOperator<Path> getDirectoryPostTransformer() {
            return this.directoryPostTransformer;
        }

        PathFilter getFileFilter() {
            return this.fileFilter;
        }

        Counters.PathCounters getPathCounters() {
            return this.pathCounters;
        }

        public B setDirectoryFilter(PathFilter pathFilter) {
            this.directoryFilter = pathFilter != null ? pathFilter : CountingPathVisitor.defaultDirectoryFilter();
            return (B)((AbstractBuilder)this.asThis());
        }

        public B setFileFilter(PathFilter pathFilter) {
            this.fileFilter = pathFilter != null ? pathFilter : CountingPathVisitor.defaultFileFilter();
            return (B)((AbstractBuilder)this.asThis());
        }

        public B setPathCounters(Counters.PathCounters pathCounters) {
            this.pathCounters = pathCounters != null ? pathCounters : CountingPathVisitor.defaultPathCounters();
            return (B)((AbstractBuilder)this.asThis());
        }
    }
}

