/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Arrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.Hash;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;

public final class FloatArrays {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<float[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static void ensureOffsetLength(float[] fArray, int n2, int n3) {
        Arrays.ensureOffsetLength(fArray.length, n2, n3);
    }

    private static void insertionSort(float[] fArray, int n2, int n3, FloatComparator floatComparator) {
        int n4 = n2;
        while (++n4 < n3) {
            float f2 = fArray[n4];
            int n5 = n4;
            float f3 = fArray[n5 - 1];
            while (floatComparator.compare(f2, f3) < 0) {
                fArray[n5] = f3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                f3 = fArray[--n5 - 1];
            }
            fArray[n5] = f2;
        }
    }

    private static void insertionSort(float[] fArray, int n2, int n3) {
        int n4 = n2;
        while (++n4 < n3) {
            float f2 = fArray[n4];
            int n5 = n4;
            float f3 = fArray[n5 - 1];
            while (Float.compare(f2, f3) < 0) {
                fArray[n5] = f3;
                if (n2 == n5 - 1) {
                    --n5;
                    break;
                }
                f3 = fArray[--n5 - 1];
            }
            fArray[n5] = f2;
        }
    }

    public static void mergeSort(float[] fArray, int n2, int n3, float[] fArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            FloatArrays.insertionSort(fArray, n2, n3);
            return;
        }
        if (fArray2 == null) {
            fArray2 = java.util.Arrays.copyOf(fArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        FloatArrays.mergeSort(fArray2, n2, n5, fArray);
        FloatArrays.mergeSort(fArray2, n5, n3, fArray);
        if (Float.compare(fArray2[n5 - 1], fArray2[n5]) <= 0) {
            System.arraycopy(fArray2, n2, fArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            fArray[i2] = n7 >= n3 || n6 < n5 && Float.compare(fArray2[n6], fArray2[n7]) <= 0 ? fArray2[n6++] : fArray2[n7++];
        }
    }

    public static void mergeSort(float[] fArray, int n2, int n3) {
        FloatArrays.mergeSort(fArray, n2, n3, (float[])null);
    }

    public static void mergeSort(float[] fArray, int n2, int n3, FloatComparator floatComparator, float[] fArray2) {
        int n4 = n3 - n2;
        if (n4 < 16) {
            FloatArrays.insertionSort(fArray, n2, n3, floatComparator);
            return;
        }
        if (fArray2 == null) {
            fArray2 = java.util.Arrays.copyOf(fArray, n3);
        }
        int n5 = n2 + n3 >>> 1;
        FloatArrays.mergeSort(fArray2, n2, n5, floatComparator, fArray);
        FloatArrays.mergeSort(fArray2, n5, n3, floatComparator, fArray);
        if (floatComparator.compare(fArray2[n5 - 1], fArray2[n5]) <= 0) {
            System.arraycopy(fArray2, n2, fArray, n2, n4);
            return;
        }
        int n6 = n2;
        int n7 = n5;
        for (int i2 = n2; i2 < n3; ++i2) {
            fArray[i2] = n7 >= n3 || n6 < n5 && floatComparator.compare(fArray2[n6], fArray2[n7]) <= 0 ? fArray2[n6++] : fArray2[n7++];
        }
    }

    public static void mergeSort(float[] fArray, int n2, int n3, FloatComparator floatComparator) {
        FloatArrays.mergeSort(fArray, n2, n3, floatComparator, null);
    }

    public static void stableSort(float[] fArray, int n2, int n3) {
        FloatArrays.mergeSort(fArray, n2, n3);
    }

    public static void stableSort(float[] fArray) {
        FloatArrays.stableSort(fArray, 0, fArray.length);
    }

    public static void stableSort(float[] fArray, int n2, int n3, FloatComparator floatComparator) {
        FloatArrays.mergeSort(fArray, n2, n3, floatComparator);
    }

    public static void stableSort(float[] fArray, FloatComparator floatComparator) {
        FloatArrays.stableSort(fArray, 0, fArray.length, floatComparator);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int n2, int n3, int n4) {
            this.offset = n2;
            this.length = n3;
            this.level = n4;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

