/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.util;

import com.gradle.maven.extension.internal.dep.io.netty.util.Attribute;
import com.gradle.maven.extension.internal.dep.io.netty.util.AttributeKey;
import com.gradle.maven.extension.internal.dep.io.netty.util.AttributeMap;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    private static int searchAttributeByKey(DefaultAttribute[] defaultAttributeArray, AttributeKey<?> attributeKey) {
        int n2 = 0;
        int n3 = defaultAttributeArray.length - 1;
        while (n2 <= n3) {
            boolean bl2;
            int n4 = n2 + n3 >>> 1;
            DefaultAttribute defaultAttribute = defaultAttributeArray[n4];
            AttributeKey attributeKey2 = defaultAttribute.key;
            if (attributeKey2 == attributeKey) {
                return n4;
            }
            int n5 = attributeKey2.id();
            int n6 = attributeKey.id();
            assert (n5 != n6);
            boolean bl3 = bl2 = n5 < n6;
            if (bl2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return -(n2 + 1);
    }

    private static void orderedCopyOnInsert(DefaultAttribute[] defaultAttributeArray, int n2, DefaultAttribute[] defaultAttributeArray2, DefaultAttribute defaultAttribute) {
        int n3;
        int n4 = defaultAttribute.key.id();
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            DefaultAttribute defaultAttribute2 = defaultAttributeArray[n3];
            assert (defaultAttribute2.key.id() != n4);
            if (defaultAttribute2.key.id() < n4) break;
            defaultAttributeArray2[n3 + 1] = defaultAttributeArray[n3];
        }
        defaultAttributeArray2[n3 + 1] = defaultAttribute;
        int n5 = n3 + 1;
        if (n5 > 0) {
            System.arraycopy(defaultAttributeArray, 0, defaultAttributeArray2, 0, n5);
        }
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        DefaultAttribute[] defaultAttributeArray;
        DefaultAttribute[] defaultAttributeArray2;
        ObjectUtil.checkNotNull(attributeKey, "key");
        DefaultAttribute<T> defaultAttribute = null;
        do {
            int n2;
            if ((n2 = DefaultAttributeMap.searchAttributeByKey(defaultAttributeArray2 = this.attributes, attributeKey)) >= 0) {
                DefaultAttribute defaultAttribute2 = defaultAttributeArray2[n2];
                assert (defaultAttribute2.key() == attributeKey);
                if (!defaultAttribute2.isRemoved()) {
                    return defaultAttribute2;
                }
                if (defaultAttribute == null) {
                    defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
                }
                int n3 = defaultAttributeArray2.length;
                defaultAttributeArray = Arrays.copyOf(defaultAttributeArray2, n3);
                defaultAttributeArray[n2] = defaultAttribute;
                continue;
            }
            if (defaultAttribute == null) {
                defaultAttribute = new DefaultAttribute<T>(this, attributeKey);
            }
            int n4 = defaultAttributeArray2.length;
            defaultAttributeArray = new DefaultAttribute[n4 + 1];
            DefaultAttributeMap.orderedCopyOnInsert(defaultAttributeArray2, n4, defaultAttributeArray, defaultAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, defaultAttributeArray2, defaultAttributeArray));
        return defaultAttribute;
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final AtomicReferenceFieldUpdater<DefaultAttribute, DefaultAttributeMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttribute.class, DefaultAttributeMap.class, "attributeMap");
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        DefaultAttribute(DefaultAttributeMap defaultAttributeMap, AttributeKey<T> attributeKey) {
            this.attributeMap = defaultAttributeMap;
            this.key = attributeKey;
        }

        public AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }
    }
}

