/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel.socket.nio;

import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    static <T> boolean setOption(Channel channel, NioChannelOption<T> nioChannelOption, T t2) {
        NetworkChannel networkChannel = (NetworkChannel)channel;
        if (!networkChannel.supportedOptions().contains(nioChannelOption.option)) {
            return false;
        }
        if (networkChannel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            networkChannel.setOption(nioChannelOption.option, t2);
            return true;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    static <T> T getOption(Channel channel, NioChannelOption<T> nioChannelOption) {
        NetworkChannel networkChannel = (NetworkChannel)channel;
        if (!networkChannel.supportedOptions().contains(nioChannelOption.option)) {
            return null;
        }
        if (networkChannel instanceof ServerSocketChannel && nioChannelOption.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return networkChannel.getOption(nioChannelOption.option);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }
}

