/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.AdaptiveByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.NettyRuntime;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ReferenceCountUpdater;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ThreadExecutorMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;

final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator.AdaptiveAllocatorApi {
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int CENTRAL_QUEUE_CAPACITY = Math.max(2, SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors()));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt("com.gradle.maven.extension.internal.dep.io.netty.allocator.magazineBufferQueueCapacity", 1024);
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final ChunkAllocator chunkAllocator;
    private final Queue<Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<Magazine> liveCachedMagazines;
    private volatile boolean freed;

    AdaptivePoolingAllocator(ChunkAllocator chunkAllocator, MagazineCaching magazineCaching) {
        ObjectUtil.checkNotNull(chunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(magazineCaching, "magazineCaching");
        this.chunkAllocator = chunkAllocator;
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (magazineCaching != MagazineCaching.None) {
            assert (magazineCaching == MagazineCaching.EventLoopThreads || magazineCaching == MagazineCaching.FastThreadLocalThreads);
            final boolean bl2 = magazineCaching == MagazineCaching.FastThreadLocalThreads;
            final CopyOnWriteArraySet<Magazine> copyOnWriteArraySet = new CopyOnWriteArraySet<Magazine>();
            this.threadLocalMagazine = new FastThreadLocal<Object>(){

                @Override
                protected Object initialValue() {
                    if (bl2 || ThreadExecutorMap.currentExecutor() != null) {
                        if (!FastThreadLocalThread.willCleanupFastThreadLocals(Thread.currentThread())) {
                            return NO_MAGAZINE;
                        }
                        Magazine magazine = new Magazine(AdaptivePoolingAllocator.this, false);
                        copyOnWriteArraySet.add(magazine);
                        return magazine;
                    }
                    return NO_MAGAZINE;
                }

                @Override
                protected void onRemoval(Object object) throws Exception {
                    if (object != NO_MAGAZINE) {
                        copyOnWriteArraySet.remove(object);
                    }
                }
            };
            this.liveCachedMagazines = copyOnWriteArraySet;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        Magazine[] magazineArray = new Magazine[4];
        for (int i2 = 0; i2 < magazineArray.length; ++i2) {
            magazineArray[i2] = new Magazine(this);
        }
        this.magazines = magazineArray;
    }

    private static Queue<Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    @Override
    public ByteBuf allocate(int n2, int n3) {
        return this.allocate(n2, n3, Thread.currentThread(), null);
    }

    private AdaptiveByteBuf allocate(int n2, int n3, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        if (n2 <= 0xA00000) {
            Magazine[] magazineArray;
            Object object;
            int n4 = AllocationStatistics.sizeBucket(n2);
            FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
            if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
                Magazine magazine = (Magazine)object;
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = magazine.newBuffer();
                }
                boolean bl2 = magazine.tryAllocate(n2, n4, n3, adaptiveByteBuf);
                assert (bl2) : "Allocation of threadLocalMagazine must always succeed";
                return adaptiveByteBuf;
            }
            long l2 = thread.getId();
            int n5 = 0;
            do {
                magazineArray = this.magazines;
                int n6 = magazineArray.length - 1;
                int n7 = (int)(l2 & (long)n6);
                int n8 = Integer.numberOfTrailingZeros(~n6);
                for (int i2 = 0; i2 < n8; ++i2) {
                    Magazine magazine = magazineArray[n7 + i2 & n6];
                    if (adaptiveByteBuf == null) {
                        adaptiveByteBuf = magazine.newBuffer();
                    }
                    if (!magazine.tryAllocate(n2, n4, n3, adaptiveByteBuf)) continue;
                    return adaptiveByteBuf;
                }
            } while (++n5 <= 3 && this.tryExpandMagazines(magazineArray.length));
        }
        return this.allocateFallback(n2, n3, thread, adaptiveByteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptiveByteBuf allocateFallback(int n2, int n3, Thread thread, AdaptiveByteBuf adaptiveByteBuf) {
        Magazine magazine;
        ReferenceCounted referenceCounted;
        if (adaptiveByteBuf != null) {
            referenceCounted = adaptiveByteBuf.chunk;
            if (referenceCounted == null || referenceCounted == Magazine.MAGAZINE_FREED || (magazine = referenceCounted.currentMagazine()) == null) {
                magazine = this.getFallbackMagazine(thread);
            }
        } else {
            magazine = this.getFallbackMagazine(thread);
            adaptiveByteBuf = magazine.newBuffer();
        }
        referenceCounted = this.chunkAllocator.allocate(n2, n3);
        Chunk chunk = new Chunk((AbstractByteBuf)referenceCounted, magazine, false);
        try {
            chunk.readInitInto(adaptiveByteBuf, n2, n3);
        }
        finally {
            chunk.release();
        }
        return adaptiveByteBuf;
    }

    private Magazine getFallbackMagazine(Thread thread) {
        Object object;
        FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
        if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
            return (Magazine)object;
        }
        Magazine[] magazineArray = this.magazines;
        return magazineArray[(int)thread.getId() & magazineArray.length - 1];
    }

    void allocate(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
        AdaptiveByteBuf adaptiveByteBuf2 = this.allocate(n2, n3, Thread.currentThread(), adaptiveByteBuf);
        assert (adaptiveByteBuf2 == adaptiveByteBuf) : "Re-allocation created separate buffer instance";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int n2) {
        if (n2 >= MAX_STRIPES) {
            return true;
        }
        long l2 = this.magazineExpandLock.tryWriteLock();
        if (l2 != 0L) {
            Magazine[] magazineArray;
            try {
                magazineArray = this.magazines;
                if (magazineArray.length >= MAX_STRIPES || magazineArray.length > n2 || this.freed) {
                    boolean bl2 = true;
                    return bl2;
                }
                int n3 = magazineArray[0].sharedPrefChunkSize;
                Magazine[] magazineArray2 = new Magazine[magazineArray.length * 2];
                int n4 = magazineArray2.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    Magazine magazine = new Magazine(this);
                    magazine.localPrefChunkSize = n3;
                    magazine.sharedPrefChunkSize = n3;
                    magazineArray2[i2] = magazine;
                }
                this.magazines = magazineArray2;
            }
            finally {
                this.magazineExpandLock.unlockWrite(l2);
            }
            for (Magazine magazine : magazineArray) {
                magazine.free();
            }
        }
        return true;
    }

    private boolean offerToQueue(Chunk chunk) {
        if (this.freed) {
            return false;
        }
        assert (chunk.allocatedBytes == 0);
        assert (chunk.magazine == null);
        boolean bl2 = this.centralQueue.offer(chunk);
        if (this.freed && bl2) {
            this.freeCentralQueue();
        }
        return bl2;
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        this.freed = true;
        long l2 = this.magazineExpandLock.writeLock();
        try {
            Magazine[] magazineArray;
            for (Magazine magazine : magazineArray = this.magazines) {
                magazine.free();
            }
        }
        finally {
            this.magazineExpandLock.unlockWrite(l2);
        }
        this.freeCentralQueue();
    }

    private void freeCentralQueue() {
        Chunk chunk;
        while ((chunk = this.centralQueue.poll()) != null) {
            chunk.release();
        }
    }

    static {
        if (CENTRAL_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("CENTRAL_QUEUE_CAPACITY: " + CENTRAL_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
    }

    static interface ChunkAllocator {
        public AbstractByteBuf allocate(int var1, int var2);
    }

    static final class AdaptiveByteBuf
    extends AbstractReferenceCountedByteBuf {
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;
        private int adjustment;
        private AbstractByteBuf rootParent;
        Chunk chunk;
        private int length;
        private ByteBuffer tmpNioBuf;
        private boolean hasArray;
        private boolean hasMemoryAddress;

        AdaptiveByteBuf(ObjectPool.Handle<AdaptiveByteBuf> handle) {
            super(0);
            this.handle = ObjectUtil.checkNotNull(handle, "recyclerHandle");
        }

        void init(AbstractByteBuf abstractByteBuf, Chunk chunk, int n2, int n3, int n4, int n5, int n6) {
            this.adjustment = n4;
            this.chunk = chunk;
            this.length = n5;
            this.maxCapacity(n6);
            this.setIndex0(n2, n3);
            this.hasArray = abstractByteBuf.hasArray();
            this.hasMemoryAddress = abstractByteBuf.hasMemoryAddress();
            this.rootParent = abstractByteBuf;
            this.tmpNioBuf = abstractByteBuf.internalNioBuffer(n4, n5).slice();
        }

        private AbstractByteBuf rootParent() {
            AbstractByteBuf abstractByteBuf = this.rootParent;
            if (abstractByteBuf != null) {
                return abstractByteBuf;
            }
            throw new IllegalReferenceCountException();
        }

        @Override
        public int capacity() {
            return this.length;
        }

        @Override
        public ByteBuf capacity(int n2) {
            if (n2 == this.capacity()) {
                this.ensureAccessible();
                return this;
            }
            this.checkNewCapacity(n2);
            if (n2 < this.capacity()) {
                this.length = n2;
                this.setIndex0(Math.min(this.readerIndex(), n2), Math.min(this.writerIndex(), n2));
                return this;
            }
            ByteBuffer byteBuffer = this.tmpNioBuf;
            byteBuffer.clear();
            this.tmpNioBuf = null;
            Chunk chunk = this.chunk;
            AdaptivePoolingAllocator adaptivePoolingAllocator = chunk.allocator;
            int n3 = this.readerIndex;
            int n4 = this.writerIndex;
            adaptivePoolingAllocator.allocate(n2, this.maxCapacity(), this);
            this.tmpNioBuf.put(byteBuffer);
            this.tmpNioBuf.clear();
            chunk.release();
            this.readerIndex = n3;
            this.writerIndex = n4;
            return this;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.rootParent().alloc();
        }

        @Override
        public ByteOrder order() {
            return this.rootParent().order();
        }

        @Override
        public ByteBuf unwrap() {
            return null;
        }

        @Override
        public boolean isDirect() {
            return this.rootParent().isDirect();
        }

        @Override
        public int arrayOffset() {
            return this.idx(this.rootParent().arrayOffset());
        }

        @Override
        public boolean hasMemoryAddress() {
            return this.hasMemoryAddress;
        }

        @Override
        public long memoryAddress() {
            this.ensureAccessible();
            return this.rootParent().memoryAddress() + (long)this.adjustment;
        }

        @Override
        public ByteBuffer nioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffer(this.idx(n2), n3);
        }

        @Override
        public ByteBuffer internalNioBuffer(int n2, int n3) {
            this.checkIndex(n2, n3);
            return (ByteBuffer)this.internalNioBuffer().position(n2).limit(n2 + n3);
        }

        private ByteBuffer internalNioBuffer() {
            return (ByteBuffer)this.tmpNioBuf.clear();
        }

        @Override
        public ByteBuffer[] nioBuffers(int n2, int n3) {
            this.checkIndex(n2, n3);
            return this.rootParent().nioBuffers(this.idx(n2), n3);
        }

        @Override
        public boolean hasArray() {
            return this.hasArray;
        }

        @Override
        public byte[] array() {
            this.ensureAccessible();
            return this.rootParent().array();
        }

        @Override
        public int nioBufferCount() {
            return this.rootParent().nioBufferCount();
        }

        @Override
        protected byte _getByte(int n2) {
            return this.rootParent()._getByte(this.idx(n2));
        }

        @Override
        protected short _getShort(int n2) {
            return this.rootParent()._getShort(this.idx(n2));
        }

        @Override
        protected short _getShortLE(int n2) {
            return this.rootParent()._getShortLE(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMedium(int n2) {
            return this.rootParent()._getUnsignedMedium(this.idx(n2));
        }

        @Override
        protected int _getUnsignedMediumLE(int n2) {
            return this.rootParent()._getUnsignedMediumLE(this.idx(n2));
        }

        @Override
        protected int _getInt(int n2) {
            return this.rootParent()._getInt(this.idx(n2));
        }

        @Override
        protected int _getIntLE(int n2) {
            return this.rootParent()._getIntLE(this.idx(n2));
        }

        @Override
        protected long _getLong(int n2) {
            return this.rootParent()._getLong(this.idx(n2));
        }

        @Override
        protected long _getLongLE(int n2) {
            return this.rootParent()._getLongLE(this.idx(n2));
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byteBuf, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().getBytes(this.idx(n2), byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            this.rootParent().getBytes(this.idx(n2), byteBuffer);
            return this;
        }

        @Override
        protected void _setByte(int n2, int n3) {
            this.rootParent()._setByte(this.idx(n2), n3);
        }

        @Override
        protected void _setShort(int n2, int n3) {
            this.rootParent()._setShort(this.idx(n2), n3);
        }

        @Override
        protected void _setMedium(int n2, int n3) {
            this.rootParent()._setMedium(this.idx(n2), n3);
        }

        @Override
        protected void _setInt(int n2, int n3) {
            this.rootParent()._setInt(this.idx(n2), n3);
        }

        @Override
        protected void _setLong(int n2, long l2) {
            this.rootParent()._setLong(this.idx(n2), l2);
        }

        @Override
        public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().setBytes(this.idx(n2), byArray, n3, n4);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
            this.checkIndex(n2, n4);
            this.rootParent().setBytes(this.idx(n2), byteBuf, n3, n4);
            return this;
        }

        @Override
        public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
            this.checkIndex(n2, byteBuffer.remaining());
            this.rootParent().setBytes(this.idx(n2), byteBuffer);
            return this;
        }

        @Override
        public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
            return gatheringByteChannel.write(this.internalNioBuffer(n2, n3).duplicate());
        }

        @Override
        public int setBytes(int n2, InputStream inputStream, int n3) throws IOException {
            this.checkIndex(n2, n3);
            AbstractByteBuf abstractByteBuf = this.rootParent();
            if (abstractByteBuf.hasArray()) {
                return abstractByteBuf.setBytes(this.idx(n2), inputStream, n3);
            }
            byte[] byArray = ByteBufUtil.threadLocalTempArray(n3);
            int n4 = inputStream.read(byArray, 0, n3);
            if (n4 <= 0) {
                return n4;
            }
            this.setBytes(n2, byArray, 0, n4);
            return n4;
        }

        @Override
        public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
            try {
                return scatteringByteChannel.read(this.internalNioBuffer(n2, n3).duplicate());
            }
            catch (ClosedChannelException closedChannelException) {
                return -1;
            }
        }

        @Override
        public int forEachByte(int n2, int n3, ByteProcessor byteProcessor) {
            this.checkIndex(n2, n3);
            int n4 = this.rootParent().forEachByte(this.idx(n2), n3, byteProcessor);
            return this.forEachResult(n4);
        }

        private int forEachResult(int n2) {
            if (n2 < this.adjustment) {
                return -1;
            }
            return n2 - this.adjustment;
        }

        @Override
        public boolean isContiguous() {
            return this.rootParent().isContiguous();
        }

        private int idx(int n2) {
            return n2 + this.adjustment;
        }

        @Override
        protected void deallocate() {
            if (this.chunk != null) {
                this.chunk.release();
            }
            this.tmpNioBuf = null;
            this.chunk = null;
            this.rootParent = null;
            if (this.handle instanceof Recycler.EnhancedHandle) {
                Recycler.EnhancedHandle enhancedHandle = (Recycler.EnhancedHandle)this.handle;
                enhancedHandle.unguardedRecycle(this);
            } else {
                this.handle.recycle(this);
            }
        }
    }

    private static final class Chunk
    implements ReferenceCounted {
        private final AbstractByteBuf delegate;
        private Magazine magazine;
        private final AdaptivePoolingAllocator allocator;
        private final int capacity;
        private final boolean pooled;
        private int allocatedBytes;
        private static final long REFCNT_FIELD_OFFSET = ReferenceCountUpdater.getUnsafeOffset(Chunk.class, "refCnt");
        private static final AtomicIntegerFieldUpdater<Chunk> AIF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Chunk.class, "refCnt");
        private static final ReferenceCountUpdater<Chunk> updater = new ReferenceCountUpdater<Chunk>(){

            @Override
            protected AtomicIntegerFieldUpdater<Chunk> updater() {
                return AIF_UPDATER;
            }

            @Override
            protected long unsafeOffset() {
                return REFCNT_FIELD_OFFSET;
            }
        };
        private volatile int refCnt;

        Chunk() {
            this.delegate = null;
            this.magazine = null;
            this.allocator = null;
            this.capacity = 0;
            this.pooled = false;
        }

        Chunk(AbstractByteBuf abstractByteBuf, Magazine magazine, boolean bl2) {
            this.delegate = abstractByteBuf;
            this.pooled = bl2;
            this.capacity = abstractByteBuf.capacity();
            updater.setInitialValue(this);
            this.allocator = magazine.parent;
            this.attachToMagazine(magazine);
        }

        Magazine currentMagazine() {
            return this.magazine;
        }

        void detachFromMagazine() {
            if (this.magazine != null) {
                this.magazine.usedMemory.getAndAdd(-this.capacity);
                this.magazine = null;
            }
        }

        void attachToMagazine(Magazine magazine) {
            assert (this.magazine == null);
            this.magazine = magazine;
            magazine.usedMemory.getAndAdd(this.capacity);
        }

        @Override
        public Chunk touch(Object object) {
            return this;
        }

        @Override
        public int refCnt() {
            return updater.refCnt(this);
        }

        @Override
        public Chunk retain() {
            return updater.retain(this);
        }

        @Override
        public Chunk touch() {
            return this;
        }

        @Override
        public boolean release() {
            if (updater.release(this)) {
                this.deallocate();
                return true;
            }
            return false;
        }

        private void deallocate() {
            Magazine magazine = this.magazine;
            AdaptivePoolingAllocator adaptivePoolingAllocator = magazine.parent;
            int n2 = magazine.preferredChunkSize();
            int n3 = this.delegate.capacity();
            if (!this.pooled || Chunk.shouldReleaseSuboptimalChunkSuze(n3, n2)) {
                this.detachFromMagazine();
                this.delegate.release();
            } else {
                updater.resetRefCnt(this);
                this.delegate.setIndex(0, 0);
                this.allocatedBytes = 0;
                if (!magazine.trySetNextInLine(this)) {
                    this.detachFromMagazine();
                    if (!adaptivePoolingAllocator.offerToQueue(this)) {
                        boolean bl2 = updater.release(this);
                        this.delegate.release();
                        assert (bl2);
                    }
                }
            }
        }

        private static boolean shouldReleaseSuboptimalChunkSuze(int n2, int n3) {
            int n4 = n2 / 131072;
            int n5 = n3 / 131072;
            int n6 = Math.abs(n4 - n5);
            return n6 != 0 && PlatformDependent.threadLocalRandom().nextDouble() * 200.0 > (double)n6;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readInitInto(AdaptiveByteBuf adaptiveByteBuf, int n2, int n3) {
            int n4 = this.allocatedBytes;
            this.allocatedBytes = n4 + n2;
            Chunk chunk = this;
            chunk.retain();
            try {
                adaptiveByteBuf.init(this.delegate, chunk, 0, 0, n4, n2, n3);
                chunk = null;
            }
            finally {
                if (chunk != null) {
                    this.allocatedBytes = n4;
                    chunk.release();
                }
            }
        }

        public int remainingCapacity() {
            return this.capacity - this.allocatedBytes;
        }
    }

    private static final class Magazine
    extends AllocationStatistics {
        private static final AtomicReferenceFieldUpdater<Magazine, Chunk> NEXT_IN_LINE = AtomicReferenceFieldUpdater.newUpdater(Magazine.class, Chunk.class, "nextInLine");
        private static final Chunk MAGAZINE_FREED = new Chunk();
        private static final ObjectPool<AdaptiveByteBuf> EVENT_LOOP_LOCAL_BUFFER_POOL = ObjectPool.newPool(new ObjectPool.ObjectCreator<AdaptiveByteBuf>(){

            @Override
            public AdaptiveByteBuf newObject(ObjectPool.Handle<AdaptiveByteBuf> handle) {
                return new AdaptiveByteBuf(handle);
            }
        });
        private Chunk current;
        private volatile Chunk nextInLine;
        private final AtomicLong usedMemory;
        private final StampedLock allocationLock;
        private final Queue<AdaptiveByteBuf> bufferQueue;
        private final ObjectPool.Handle<AdaptiveByteBuf> handle;

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator) {
            this(adaptivePoolingAllocator, true);
        }

        Magazine(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl2) {
            super(adaptivePoolingAllocator, bl2);
            if (bl2) {
                this.allocationLock = new StampedLock();
                this.bufferQueue = PlatformDependent.newFixedMpmcQueue(MAGAZINE_BUFFER_QUEUE_CAPACITY);
                this.handle = new ObjectPool.Handle<AdaptiveByteBuf>(){

                    @Override
                    public void recycle(AdaptiveByteBuf adaptiveByteBuf) {
                        Magazine.this.bufferQueue.offer(adaptiveByteBuf);
                    }
                };
            } else {
                this.allocationLock = null;
                this.bufferQueue = null;
                this.handle = null;
            }
            this.usedMemory = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAllocate(int n2, int n3, int n4, AdaptiveByteBuf adaptiveByteBuf) {
            if (this.allocationLock == null) {
                return this.allocate(n2, n3, n4, adaptiveByteBuf);
            }
            long l2 = this.allocationLock.tryWriteLock();
            if (l2 != 0L) {
                try {
                    boolean bl2 = this.allocate(n2, n3, n4, adaptiveByteBuf);
                    return bl2;
                }
                finally {
                    this.allocationLock.unlockWrite(l2);
                }
            }
            return this.allocateWithoutLock(n2, n4, adaptiveByteBuf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocateWithoutLock(int n2, int n3, AdaptiveByteBuf adaptiveByteBuf) {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk == MAGAZINE_FREED) {
                this.restoreMagazineFreed();
                return false;
            }
            if (chunk == null) {
                chunk = (Chunk)this.parent.centralQueue.poll();
                if (chunk == null) {
                    return false;
                }
                chunk.attachToMagazine(this);
            }
            if (chunk.remainingCapacity() >= n2) {
                chunk.readInitInto(adaptiveByteBuf, n2, n3);
            }
            try {
                if (chunk.remainingCapacity() >= 4096) {
                    this.transferToNextInLineOrRelease(chunk);
                    chunk = null;
                }
            }
            finally {
                if (chunk != null) {
                    chunk.release();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean allocate(int n2, int n3, int n4, AdaptiveByteBuf adaptiveByteBuf) {
            this.recordAllocationSize(n3);
            Chunk chunk = this.current;
            if (chunk != null) {
                if (chunk.remainingCapacity() > n2) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n4);
                    return true;
                }
                this.current = null;
                if (chunk.remainingCapacity() == n2) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n2, n4);
                        boolean bl2 = true;
                        return bl2;
                    }
                    finally {
                        chunk.release();
                    }
                }
                if (chunk.remainingCapacity() < 4096) {
                    chunk.release();
                } else {
                    this.transferToNextInLineOrRelease(chunk);
                }
            }
            assert (this.current == null);
            chunk = NEXT_IN_LINE.getAndSet(this, null);
            if (chunk != null) {
                if (chunk == MAGAZINE_FREED) {
                    this.restoreMagazineFreed();
                    return false;
                }
                if (chunk.remainingCapacity() > n2) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n4);
                    this.current = chunk;
                    return true;
                }
                if (chunk.remainingCapacity() == n2) {
                    try {
                        chunk.readInitInto(adaptiveByteBuf, n2, n4);
                        boolean bl3 = true;
                        return bl3;
                    }
                    finally {
                        chunk.release();
                    }
                }
                chunk.release();
            }
            if ((chunk = (Chunk)this.parent.centralQueue.poll()) == null) {
                chunk = this.newChunkAllocation(n2);
            } else {
                chunk.attachToMagazine(this);
                if (chunk.remainingCapacity() < n2) {
                    if (chunk.remainingCapacity() < 4096) {
                        chunk.release();
                    } else {
                        this.transferToNextInLineOrRelease(chunk);
                    }
                    chunk = this.newChunkAllocation(n2);
                }
            }
            this.current = chunk;
            try {
                assert (this.current.remainingCapacity() >= n2);
                if (chunk.remainingCapacity() > n2) {
                    chunk.readInitInto(adaptiveByteBuf, n2, n4);
                    chunk = null;
                } else {
                    chunk.readInitInto(adaptiveByteBuf, n2, n4);
                }
            }
            finally {
                if (chunk != null) {
                    chunk.release();
                    this.current = null;
                }
            }
            return true;
        }

        private void restoreMagazineFreed() {
            Chunk chunk = NEXT_IN_LINE.getAndSet(this, MAGAZINE_FREED);
            if (chunk != null && chunk != MAGAZINE_FREED) {
                chunk.release();
            }
        }

        private void transferToNextInLineOrRelease(Chunk chunk) {
            if (NEXT_IN_LINE.compareAndSet(this, null, chunk)) {
                return;
            }
            Chunk chunk2 = NEXT_IN_LINE.get(this);
            if (chunk2 != null && chunk2 != MAGAZINE_FREED && chunk.remainingCapacity() > chunk2.remainingCapacity() && NEXT_IN_LINE.compareAndSet(this, chunk2, chunk)) {
                chunk2.release();
                return;
            }
            chunk.release();
        }

        private Chunk newChunkAllocation(int n2) {
            int n3 = Math.max(n2 * 10, this.preferredChunkSize());
            int n4 = n3 / 131072;
            if (131072 * n4 < n3) {
                n3 = 131072 * (1 + n4);
            }
            ChunkAllocator chunkAllocator = this.parent.chunkAllocator;
            return new Chunk(chunkAllocator.allocate(n3, n3), this, true);
        }

        boolean trySetNextInLine(Chunk chunk) {
            return NEXT_IN_LINE.compareAndSet(this, null, chunk);
        }

        void free() {
            this.restoreMagazineFreed();
            long l2 = this.allocationLock.writeLock();
            try {
                if (this.current != null) {
                    this.current.release();
                    this.current = null;
                }
            }
            finally {
                this.allocationLock.unlockWrite(l2);
            }
        }

        public AdaptiveByteBuf newBuffer() {
            AdaptiveByteBuf adaptiveByteBuf;
            if (this.handle == null) {
                adaptiveByteBuf = EVENT_LOOP_LOCAL_BUFFER_POOL.get();
            } else {
                adaptiveByteBuf = this.bufferQueue.poll();
                if (adaptiveByteBuf == null) {
                    adaptiveByteBuf = new AdaptiveByteBuf(this.handle);
                }
            }
            adaptiveByteBuf.resetRefCnt();
            adaptiveByteBuf.discardMarks();
            return adaptiveByteBuf;
        }
    }

    private static class AllocationStatistics {
        protected final AdaptivePoolingAllocator parent;
        private final boolean shareable;
        private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
        private short[] histo = this.histos[0];
        private final int[] sums = new int[8];
        private int histoIndex;
        private int datumCount;
        private int datumTarget = 9;
        protected volatile int sharedPrefChunkSize = 131072;
        protected volatile int localPrefChunkSize = 131072;

        private AllocationStatistics(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl2) {
            this.parent = adaptivePoolingAllocator;
            this.shareable = bl2;
        }

        protected void recordAllocationSize(int n2) {
            int n3 = n2;
            this.histo[n3] = (short)(this.histo[n3] + 1);
            if (this.datumCount++ == this.datumTarget) {
                this.rotateHistograms();
            }
        }

        static int sizeBucket(int n2) {
            if (n2 == 0) {
                return 0;
            }
            int n3 = n2 - 1 >> 13 & 0x9FFFFF;
            return Math.min(32 - Integer.numberOfLeadingZeros(n3), 7);
        }

        private void rotateHistograms() {
            int n2;
            int n3;
            int n4;
            short[][] sArray = this.histos;
            for (n4 = 0; n4 < 8; ++n4) {
                this.sums[n4] = (sArray[0][n4] & 0xFFFF) + (sArray[1][n4] & 0xFFFF) + (sArray[2][n4] & 0xFFFF) + (sArray[3][n4] & 0xFFFF);
            }
            n4 = 0;
            int[] nArray = this.sums;
            int n5 = nArray.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = nArray[n3];
                n4 += n2;
            }
            int n6 = (int)((double)n4 * 0.99);
            for (n5 = 0; n5 < this.sums.length && this.sums[n5] <= n6; n6 -= this.sums[n5], ++n5) {
            }
            n3 = 1 << n5 + 13;
            this.localPrefChunkSize = n2 = Math.max(n3 * 10, 131072);
            if (this.shareable) {
                for (Magazine magazine : this.parent.magazines) {
                    n2 = Math.max(n2, magazine.localPrefChunkSize);
                }
            }
            if (this.sharedPrefChunkSize != n2) {
                this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
                this.sharedPrefChunkSize = n2;
            } else {
                this.datumTarget = Math.min(this.datumTarget << 1, 65534);
            }
            this.histoIndex = this.histoIndex + 1 & 3;
            this.histo = this.histos[this.histoIndex];
            this.datumCount = 0;
            Arrays.fill(this.histo, (short)0);
        }

        protected int preferredChunkSize() {
            return this.sharedPrefChunkSize;
        }
    }

    static enum MagazineCaching {
        EventLoopThreads,
        FastThreadLocalThreads,
        None;

    }
}

