/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent;

import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.AbstractFuture;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.LazyLogger;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.ListenableFuture;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.OverflowAvoidingLockSupport;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import sun.misc.Unsafe;

abstract class AbstractFutureState<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    static final Object NULL;
    static final LazyLogger log;
    static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final AtomicHelper ATOMIC_HELPER;
    volatile Object valueField;
    volatile AbstractFuture.Listener listenersField;
    volatile Waiter waitersField;

    final boolean casListeners(AbstractFuture.Listener listener, AbstractFuture.Listener listener2) {
        return ATOMIC_HELPER.casListeners(this, listener, listener2);
    }

    final AbstractFuture.Listener gasListeners(AbstractFuture.Listener listener) {
        return ATOMIC_HELPER.gasListeners(this, listener);
    }

    static boolean casValue(AbstractFutureState<?> abstractFutureState, Object object, Object object2) {
        return ATOMIC_HELPER.casValue(abstractFutureState, object, object2);
    }

    final Object value() {
        return this.valueField;
    }

    final AbstractFuture.Listener listeners() {
        return this.listenersField;
    }

    final void releaseWaiters() {
        Waiter waiter;
        Waiter waiter2 = waiter = this.gasWaiters(Waiter.TOMBSTONE);
        while (waiter2 != null) {
            waiter2.unpark();
            waiter2 = waiter2.next;
        }
    }

    final V blockingGet(long l2, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l3;
        Object object3;
        long l4;
        block15: {
            long l5;
            l4 = l5 = timeUnit.toNanos(l2);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.valueField;
            if (object3 != null & AbstractFuture.notInstanceOfDelegatingToFuture(object3)) {
                return AbstractFuture.getDoneValue(object3);
            }
            long l6 = l3 = l4 > 0L ? System.nanoTime() + l4 : 0L;
            if (l4 >= 1000L) {
                object2 = this.waitersField;
                if (object2 != Waiter.TOMBSTONE) {
                    object = new Waiter();
                    do {
                        ((Waiter)object).setNext((Waiter)object2);
                        if (!this.casWaiters((Waiter)object2, (Waiter)object)) continue;
                        do {
                            OverflowAvoidingLockSupport.parkNanos(this, l4);
                            if (Thread.interrupted()) {
                                this.removeWaiter((Waiter)object);
                                throw new InterruptedException();
                            }
                            object3 = this.valueField;
                            if (!(object3 != null & AbstractFuture.notInstanceOfDelegatingToFuture(object3))) continue;
                            return AbstractFuture.getDoneValue(object3);
                        } while ((l4 = l3 - System.nanoTime()) >= 1000L);
                        this.removeWaiter((Waiter)object);
                        break block15;
                    } while ((object2 = this.waitersField) != Waiter.TOMBSTONE);
                }
                return AbstractFuture.getDoneValue(Objects.requireNonNull(this.valueField));
            }
        }
        while (l4 > 0L) {
            object3 = this.valueField;
            if (object3 != null & AbstractFuture.notInstanceOfDelegatingToFuture(object3)) {
                return AbstractFuture.getDoneValue(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l4 = l3 - System.nanoTime();
        }
        object2 = this.toString();
        object = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string = "Waited " + l2 + " " + timeUnit.toString().toLowerCase(Locale.ROOT);
        if (l4 + 1000L < 0L) {
            boolean bl2;
            string = string + " (plus ";
            long l7 = -l4;
            long l8 = timeUnit.convert(l7, TimeUnit.NANOSECONDS);
            long l9 = l7 - timeUnit.toNanos(l8);
            boolean bl3 = bl2 = l8 == 0L || l9 > 1000L;
            if (l8 > 0L) {
                string = string + l8 + " " + (String)object;
                if (bl2) {
                    string = string + ",";
                }
                string = string + " ";
            }
            if (bl2) {
                string = string + l9 + " nanoseconds ";
            }
            string = string + "delay)";
        }
        if (this.isDone()) {
            throw new TimeoutException(string + " but future completed as timeout expired");
        }
        throw new TimeoutException(string + " for " + (String)object2);
    }

    final V blockingGet() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.valueField;
        if (object != null & AbstractFuture.notInstanceOfDelegatingToFuture(object)) {
            return AbstractFuture.getDoneValue(object);
        }
        Waiter waiter = this.waitersField;
        if (waiter != Waiter.TOMBSTONE) {
            Waiter waiter2 = new Waiter();
            do {
                waiter2.setNext(waiter);
                if (!this.casWaiters(waiter, waiter2)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(waiter2);
                    throw new InterruptedException();
                } while (!((object = this.valueField) != null & AbstractFuture.notInstanceOfDelegatingToFuture(object)));
                return AbstractFuture.getDoneValue(object);
            } while ((waiter = this.waitersField) != Waiter.TOMBSTONE);
        }
        return AbstractFuture.getDoneValue(Objects.requireNonNull(this.valueField));
    }

    AbstractFutureState() {
    }

    private static void putThread(Waiter waiter, Thread thread) {
        ATOMIC_HELPER.putThread(waiter, thread);
    }

    private static void putNext(Waiter waiter, Waiter waiter2) {
        ATOMIC_HELPER.putNext(waiter, waiter2);
    }

    private boolean casWaiters(Waiter waiter, Waiter waiter2) {
        return ATOMIC_HELPER.casWaiters(this, waiter, waiter2);
    }

    private final Waiter gasWaiters(Waiter waiter) {
        return ATOMIC_HELPER.gasWaiters(this, waiter);
    }

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waitersField;
            if (var3_3 == Waiter.TOMBSTONE) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (this.casWaiters(var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    static {
        boolean bl2;
        NULL = new Object();
        log = new LazyLogger(AbstractFuture.class);
        try {
            bl2 = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl2 = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl2;
        Throwable throwable = null;
        Throwable throwable2 = null;
        AtomicHelper atomicHelper = VarHandleAtomicHelperMaker.INSTANCE.tryMakeVarHandleAtomicHelper();
        if (atomicHelper == null) {
            try {
                atomicHelper = new UnsafeAtomicHelper();
            }
            catch (Error | Exception throwable3) {
                throwable = throwable3;
                try {
                    atomicHelper = new AtomicReferenceFieldUpdaterAtomicHelper();
                }
                catch (Error | Exception throwable4) {
                    throwable2 = throwable4;
                    atomicHelper = new SynchronizedHelper();
                }
            }
        }
        ATOMIC_HELPER = atomicHelper;
        Class<LockSupport> clazz = LockSupport.class;
        if (throwable2 != null) {
            log.get().log(Level.SEVERE, "UnsafeAtomicHelper is broken!", throwable);
            log.get().log(Level.SEVERE, "AtomicReferenceFieldUpdaterAtomicHelper is broken!", throwable2);
        }
    }

    static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        volatile Thread thread;
        volatile Waiter next;

        Waiter(boolean bl2) {
        }

        Waiter() {
            AbstractFutureState.putThread(this, Thread.currentThread());
        }

        void setNext(Waiter waiter) {
            AbstractFutureState.putNext(this, waiter);
        }

        void unpark() {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void putThread(Waiter var1, Thread var2);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract boolean casWaiters(AbstractFutureState<?> var1, Waiter var2, Waiter var3);

        abstract boolean casListeners(AbstractFutureState<?> var1, AbstractFuture.Listener var2, AbstractFuture.Listener var3);

        abstract Waiter gasWaiters(AbstractFutureState<?> var1, Waiter var2);

        abstract AbstractFuture.Listener gasListeners(AbstractFutureState<?> var1, AbstractFuture.Listener var2);

        abstract boolean casValue(AbstractFutureState<?> var1, Object var2, Object var3);
    }

    private static enum VarHandleAtomicHelperMaker {
        INSTANCE{

            @Override
            AtomicHelper tryMakeVarHandleAtomicHelper() {
                try {
                    Class.forName("java.lang.invoke.VarHandle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                return new VarHandleAtomicHelper();
            }
        };


        AtomicHelper tryMakeVarHandleAtomicHelper() {
            return null;
        }
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        private UnsafeAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            UNSAFE.putObject(waiter, WAITER_THREAD_OFFSET, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            UNSAFE.putObject(waiter, WAITER_NEXT_OFFSET, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter, Waiter waiter2) {
            return UNSAFE.compareAndSwapObject(abstractFutureState, WAITERS_OFFSET, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener, AbstractFuture.Listener listener2) {
            return UNSAFE.compareAndSwapObject(abstractFutureState, LISTENERS_OFFSET, listener, listener2);
        }

        @Override
        AbstractFuture.Listener gasListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener) {
            return (AbstractFuture.Listener)UNSAFE.getAndSetObject(abstractFutureState, LISTENERS_OFFSET, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter) {
            return (Waiter)UNSAFE.getAndSetObject(abstractFutureState, WAITERS_OFFSET, waiter);
        }

        @Override
        boolean casValue(AbstractFutureState<?> abstractFutureState, Object object, Object object2) {
            return UNSAFE.compareAndSwapObject(abstractFutureState, VALUE_OFFSET, object, object2);
        }

        static {
            Unsafe unsafe = null;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(() -> {
                        Class<Unsafe> clazz = Unsafe.class;
                        for (Field field : clazz.getDeclaredFields()) {
                            field.setAccessible(true);
                            Object object = field.get(null);
                            if (!clazz.isInstance(object)) continue;
                            return (Unsafe)clazz.cast(object);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<AbstractFutureState> clazz = AbstractFutureState.class;
                WAITERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("waitersField"));
                LISTENERS_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("listenersField"));
                VALUE_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("valueField"));
                WAITER_THREAD_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = unsafe.objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = unsafe;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
        }
    }

    private static final class AtomicReferenceFieldUpdaterAtomicHelper
    extends AtomicHelper {
        private static final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater = AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread");
        private static final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater = AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next");
        private static final AtomicReferenceFieldUpdater<? super AbstractFutureState<?>, Waiter> waitersUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractFutureState.class, Waiter.class, "waitersField");
        private static final AtomicReferenceFieldUpdater<? super AbstractFutureState<?>, AbstractFuture.Listener> listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractFutureState.class, AbstractFuture.Listener.class, "listenersField");
        private static final AtomicReferenceFieldUpdater<? super AbstractFutureState<?>, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractFutureState.class, Object.class, "valueField");

        private AtomicReferenceFieldUpdaterAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiterThreadUpdater.lazySet(waiter, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiterNextUpdater.lazySet(waiter, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter, Waiter waiter2) {
            return waitersUpdater.compareAndSet(abstractFutureState, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener, AbstractFuture.Listener listener2) {
            return listenersUpdater.compareAndSet(abstractFutureState, listener, listener2);
        }

        @Override
        AbstractFuture.Listener gasListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener) {
            return listenersUpdater.getAndSet(abstractFutureState, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter) {
            return waitersUpdater.getAndSet(abstractFutureState, waiter);
        }

        @Override
        boolean casValue(AbstractFutureState<?> abstractFutureState, Object object, Object object2) {
            return valueUpdater.compareAndSet(abstractFutureState, object, object2);
        }
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiter.thread = thread;
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiter.next = waiter2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter, Waiter waiter2) {
            AbstractFutureState<?> abstractFutureState2 = abstractFutureState;
            synchronized (abstractFutureState2) {
                if (abstractFutureState.waitersField == waiter) {
                    abstractFutureState.waitersField = waiter2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener, AbstractFuture.Listener listener2) {
            AbstractFutureState<?> abstractFutureState2 = abstractFutureState;
            synchronized (abstractFutureState2) {
                if (abstractFutureState.listenersField == listener) {
                    abstractFutureState.listenersField = listener2;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        AbstractFuture.Listener gasListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener) {
            AbstractFutureState<?> abstractFutureState2 = abstractFutureState;
            synchronized (abstractFutureState2) {
                AbstractFuture.Listener listener2 = abstractFutureState.listenersField;
                if (listener2 != listener) {
                    abstractFutureState.listenersField = listener;
                }
                return listener2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Waiter gasWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter) {
            AbstractFutureState<?> abstractFutureState2 = abstractFutureState;
            synchronized (abstractFutureState2) {
                Waiter waiter2 = abstractFutureState.waitersField;
                if (waiter2 != waiter) {
                    abstractFutureState.waitersField = waiter;
                }
                return waiter2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean casValue(AbstractFutureState<?> abstractFutureState, Object object, Object object2) {
            AbstractFutureState<?> abstractFutureState2 = abstractFutureState;
            synchronized (abstractFutureState2) {
                if (abstractFutureState.valueField == object) {
                    abstractFutureState.valueField = object2;
                    return true;
                }
                return false;
            }
        }
    }

    private static final class VarHandleAtomicHelper
    extends AtomicHelper {
        static final VarHandle waiterThreadUpdater;
        static final VarHandle waiterNextUpdater;
        static final VarHandle waitersUpdater;
        static final VarHandle listenersUpdater;
        static final VarHandle valueUpdater;

        private VarHandleAtomicHelper() {
        }

        @Override
        void putThread(Waiter waiter, Thread thread) {
            waiterThreadUpdater.setRelease(waiter, thread);
        }

        @Override
        void putNext(Waiter waiter, Waiter waiter2) {
            waiterNextUpdater.setRelease(waiter, waiter2);
        }

        @Override
        boolean casWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter, Waiter waiter2) {
            return waitersUpdater.compareAndSet(abstractFutureState, waiter, waiter2);
        }

        @Override
        boolean casListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener, AbstractFuture.Listener listener2) {
            return listenersUpdater.compareAndSet(abstractFutureState, listener, listener2);
        }

        @Override
        AbstractFuture.Listener gasListeners(AbstractFutureState<?> abstractFutureState, AbstractFuture.Listener listener) {
            return listenersUpdater.getAndSet(abstractFutureState, listener);
        }

        @Override
        Waiter gasWaiters(AbstractFutureState<?> abstractFutureState, Waiter waiter) {
            return waitersUpdater.getAndSet(abstractFutureState, waiter);
        }

        @Override
        boolean casValue(AbstractFutureState<?> abstractFutureState, Object object, Object object2) {
            return valueUpdater.compareAndSet(abstractFutureState, object, object2);
        }

        private static LinkageError newLinkageError(Throwable throwable) {
            return new LinkageError(throwable.toString(), throwable);
        }

        static {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                waiterThreadUpdater = lookup.findVarHandle(Waiter.class, "thread", Thread.class);
                waiterNextUpdater = lookup.findVarHandle(Waiter.class, "next", Waiter.class);
                waitersUpdater = lookup.findVarHandle(AbstractFutureState.class, "waitersField", Waiter.class);
                listenersUpdater = lookup.findVarHandle(AbstractFutureState.class, "listenersField", AbstractFuture.Listener.class);
                valueUpdater = lookup.findVarHandle(AbstractFutureState.class, "valueField", Object.class);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw VarHandleAtomicHelper.newLinkageError(reflectiveOperationException);
            }
        }
    }
}

