/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.lang.annotation.Annotation;
import java.util.List;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    private static final Class<? extends Annotation>[] ANNOTATIONS_TO_INFER_XML_PROP = new Class[]{JacksonXmlText.class, JacksonXmlElementWrapper.class};
    protected boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean bl2) {
        this._cfgDefaultUseWrapper = bl2;
    }

    @Override
    public PropertyName findWrapperName(Annotated annotated) {
        JacksonXmlElementWrapper jacksonXmlElementWrapper = this._findAnnotation(annotated, JacksonXmlElementWrapper.class);
        if (jacksonXmlElementWrapper != null) {
            if (!jacksonXmlElementWrapper.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String string = jacksonXmlElementWrapper.localName();
            if (string == null || string.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct(jacksonXmlElementWrapper.localName(), jacksonXmlElementWrapper.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        JacksonXmlRootElement jacksonXmlRootElement = this._findAnnotation(annotatedClass, JacksonXmlRootElement.class);
        if (jacksonXmlRootElement != null) {
            String string = jacksonXmlRootElement.localName();
            String string2 = jacksonXmlRootElement.namespace();
            if (string.length() == 0 && string2.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(string, string2);
        }
        return super.findRootName(annotatedClass);
    }

    @Override
    public String findNamespace(MapperConfig<?> mapperConfig, Annotated annotated) {
        String string = null;
        JacksonXmlProperty jacksonXmlProperty = this._findAnnotation(annotated, JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            string = jacksonXmlProperty.namespace();
        }
        JsonProperty jsonProperty = this._findAnnotation(annotated, JsonProperty.class);
        String string2 = null;
        if (jsonProperty != null) {
            string2 = jsonProperty.namespace();
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        if (string.isEmpty()) {
            return string2;
        }
        return string;
    }

    @Override
    public void findAndAddVirtualProperties(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, List<BeanPropertyWriter> list) {
    }

    @Override
    public Boolean isOutputAsAttribute(MapperConfig<?> mapperConfig, Annotated annotated) {
        JacksonXmlProperty jacksonXmlProperty = this._findAnnotation(annotated, JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            return jacksonXmlProperty.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsText(MapperConfig<?> mapperConfig, Annotated annotated) {
        JacksonXmlText jacksonXmlText = this._findAnnotation(annotated, JacksonXmlText.class);
        if (jacksonXmlText != null) {
            return jacksonXmlText.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Boolean isOutputAsCData(MapperConfig<?> mapperConfig, Annotated annotated) {
        JacksonXmlCData jacksonXmlCData = annotated.getAnnotation(JacksonXmlCData.class);
        if (jacksonXmlCData != null) {
            return jacksonXmlCData.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        PropertyName propertyName = PropertyName.merge(this._findXmlName(annotated), super.findNameForSerialization(annotated));
        if (propertyName == null && this._hasOneOf(annotated, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return propertyName;
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        PropertyName propertyName = PropertyName.merge(this._findXmlName(annotated), super.findNameForDeserialization(annotated));
        if (propertyName == null && this._hasOneOf(annotated, ANNOTATIONS_TO_INFER_XML_PROP)) {
            return PropertyName.USE_DEFAULT;
        }
        return propertyName;
    }

    @Override
    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> mapperConfig, JsonTypeInfo.Value value, JavaType javaType) {
        return new XmlTypeResolverBuilder(value);
    }

    protected PropertyName _findXmlName(Annotated annotated) {
        JacksonXmlProperty jacksonXmlProperty = this._findAnnotation(annotated, JacksonXmlProperty.class);
        if (jacksonXmlProperty != null) {
            return PropertyName.construct(jacksonXmlProperty.localName(), jacksonXmlProperty.namespace());
        }
        return null;
    }
}

