/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util;

import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMap<K, V> {
    static Random random = new Random();
    public int size;
    K[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;

    public ObjectMap() {
        this(32, 0.8f);
    }

    public ObjectMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n2);
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(K k2, V v2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return this.put_internal(k2, v2);
    }

    private V put_internal(K k2, V v2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = k2.hashCode();
        int n4 = n3 & this.mask;
        K k3 = KArray[n4];
        if (k2.equals(k3)) {
            V v3 = this.valueTable[n4];
            this.valueTable[n4] = v2;
            return v3;
        }
        int n5 = this.hash2(n3);
        K k4 = KArray[n5];
        if (k2.equals(k4)) {
            V v4 = this.valueTable[n5];
            this.valueTable[n5] = v2;
            return v4;
        }
        int n6 = this.hash3(n3);
        K k5 = KArray[n6];
        if (k2.equals(k5)) {
            V v5 = this.valueTable[n6];
            this.valueTable[n6] = v2;
            return v5;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            V v6 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v6;
        }
        if (k3 == null) {
            KArray[n4] = k2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k4 == null) {
            KArray[n5] = k2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (k5 == null) {
            KArray[n6] = k2;
            this.valueTable[n6] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(k2, v2, n4, k3, n5, k4, n6, k5);
        return null;
    }

    private void putResize(K k2, V v2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        K k3 = this.keyTable[n3];
        if (k3 == null) {
            this.keyTable[n3] = k2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        K k4 = this.keyTable[n4];
        if (k4 == null) {
            this.keyTable[n4] = k2;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        K k5 = this.keyTable[n5];
        if (k5 == null) {
            this.keyTable[n5] = k2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k2, v2, n3, k3, n4, k4, n5, k5);
    }

    private void push(K k2, V v2, int n2, K k3, int n3, K k4, int n4, K k5) {
        V v3;
        K k6;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n5 = this.mask;
        int n6 = 0;
        int n7 = this.pushIterations;
        while (true) {
            switch (random.nextInt(3)) {
                case 0: {
                    k6 = k3;
                    v3 = VArray[n2];
                    KArray[n2] = k2;
                    VArray[n2] = v2;
                    break;
                }
                case 1: {
                    k6 = k4;
                    v3 = VArray[n3];
                    KArray[n3] = k2;
                    VArray[n3] = v2;
                    break;
                }
                default: {
                    k6 = k5;
                    v3 = VArray[n4];
                    KArray[n4] = k2;
                    VArray[n4] = v2;
                }
            }
            int n8 = k6.hashCode();
            n2 = n8 & n5;
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k6;
                VArray[n2] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n8);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k6;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n8);
            k5 = KArray[n4];
            if (k5 == null) {
                KArray[n4] = k6;
                VArray[n4] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n6 == n7) break;
            k2 = k6;
            v2 = v3;
        }
        this.putStash(k6, v3);
    }

    private void putStash(K k2, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put_internal(k2, v2);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = k2;
        this.valueTable[n2] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.getStash(k2);
        }
        return this.valueTable[n3];
    }

    private V getStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return this.valueTable[n2];
        }
        return null;
    }

    public void clear() {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            KArray[n2] = null;
            VArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean containsKey(K k2) {
        int n2 = k2.hashCode();
        int n3 = n2 & this.mask;
        if (!(k2.equals(this.keyTable[n3]) || k2.equals(this.keyTable[n3 = this.hash2(n2)]) || k2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.containsKeyStash(k2);
        }
        return true;
    }

    private boolean containsKeyStash(K k2) {
        int n2;
        K[] KArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!k2.equals(KArray[n2])) continue;
            return true;
        }
        return false;
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        this.valueTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, VArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        K k2;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static int nextPowerOfTwo(int n2) {
        if (n2 == 0) {
            return 1;
        }
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }
}

