/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.OutputConfigFlags;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxValidationException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputLocation;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputElementStack;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.StreamReaderImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.DTDInfo;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamLocation2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamReader2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2WriterImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationProblemHandler;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidatorPair;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationSchema;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;

public abstract class BaseStreamWriter
extends Stax2WriterImpl
implements OutputConfigFlags,
ValidationContext {
    protected static final int STATE_PROLOG = 1;
    protected static final int STATE_TREE = 2;
    protected static final int STATE_EPILOG = 3;
    protected static final char CHAR_SPACE = ' ';
    protected static final int MIN_ARRAYCOPY = 12;
    protected static final int ATTR_MIN_ARRAYCOPY = 12;
    protected static final int DEFAULT_COPYBUFFER_LEN = 512;
    protected final XmlWriter mWriter;
    protected char[] mCopyBuffer = null;
    protected final WriterConfig mConfig;
    protected final boolean mCfgCDataAsText;
    protected final boolean mCfgCopyDefaultAttrs;
    protected final boolean mCfgAutomaticEmptyElems;
    protected boolean mCheckStructure;
    protected boolean mCheckAttrs;
    protected String mEncoding;
    protected XMLValidator mValidator = null;
    protected boolean mXml11 = false;
    protected ValidationProblemHandler mVldProbHandler = null;
    protected int mState = 1;
    protected boolean mAnyOutput = false;
    protected boolean mStartElementOpen = false;
    protected boolean mEmptyElement = false;
    protected int mVldContent = 4;
    protected String mDtdRootElem = null;
    protected boolean mReturnNullForDefaultNamespace;

    protected BaseStreamWriter(XmlWriter xmlWriter, String string, WriterConfig writerConfig) {
        this.mWriter = xmlWriter;
        this.mEncoding = string;
        this.mConfig = writerConfig;
        int n2 = writerConfig.getConfigFlags();
        this.mCheckStructure = (n2 & 0x100) != 0;
        this.mCheckAttrs = (n2 & 0x800) != 0;
        this.mCfgAutomaticEmptyElems = (n2 & 4) != 0;
        this.mCfgCDataAsText = (n2 & 8) != 0;
        this.mCfgCopyDefaultAttrs = (n2 & 0x10) != 0;
        this.mReturnNullForDefaultNamespace = this.mConfig.returnNullForDefaultNamespace();
    }

    @Override
    public void close() throws XMLStreamException {
        this._finishDocument(false);
    }

    @Override
    public void flush() throws XMLStreamException {
        try {
            this.mWriter.flush();
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public abstract NamespaceContext getNamespaceContext();

    @Override
    public abstract String getPrefix(String var1);

    @Override
    public Object getProperty(String string) {
        if (string.equals("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputUnderlyingStream")) {
            return this.mWriter.getOutputStream();
        }
        if (string.equals("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputUnderlyingWriter")) {
            return this.mWriter.getWriter();
        }
        return this.mConfig.getProperty(string);
    }

    @Override
    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public abstract void setNamespaceContext(NamespaceContext var1) throws XMLStreamException;

    @Override
    public abstract void setPrefix(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    @Override
    public void writeCData(String string) throws XMLStreamException {
        int n2;
        if (this.mCfgCDataAsText) {
            this.writeCharacters(string);
            return;
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        this.verifyWriteCData();
        if (this.mVldContent == 3 && this.mValidator != null) {
            this.mValidator.validateText(string, false);
        }
        try {
            n2 = this.mWriter.writeCData(string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (n2 >= 0) {
            BaseStreamWriter.reportNwfContent(ErrorConsts.WERR_CDATA_CONTENT, DataUtil.Integer(n2));
        }
    }

    @Override
    public void writeCharacters(char[] cArray, int n2, int n3) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog() && !StringUtil.isAllWhitespace(cArray, n2, n3)) {
            BaseStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(4);
            } else if (!StringUtil.isAllWhitespace(cArray, n2, n3)) {
                this.reportInvalidContent(4);
            }
        } else if (this.mVldContent == 3 && this.mValidator != null) {
            this.mValidator.validateText(cArray, n2, n2 + n3, false);
        }
        if (n3 > 0) {
            try {
                if (this.inPrologOrEpilog()) {
                    this.mWriter.writeRaw(cArray, n2, n3);
                } else {
                    this.mWriter.writeCharacters(cArray, n2, n3);
                }
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
    }

    @Override
    public void writeCharacters(String string) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog() && !StringUtil.isAllWhitespace(string)) {
            BaseStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(4);
            } else if (!StringUtil.isAllWhitespace(string)) {
                this.reportInvalidContent(4);
            }
        } else if (this.mVldContent == 3 && this.mValidator != null) {
            this.mValidator.validateText(string, false);
        }
        if (this.inPrologOrEpilog()) {
            try {
                this.mWriter.writeRaw(string);
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
            return;
        }
        int n2 = string.length();
        if (n2 >= 12) {
            char[] cArray = this.getCopyBuffer();
            int n3 = 0;
            while (n2 > 0) {
                int n4 = n2 > cArray.length ? cArray.length : n2;
                string.getChars(n3, n3 + n4, cArray, 0);
                try {
                    this.mWriter.writeCharacters(cArray, 0, n4);
                }
                catch (IOException iOException) {
                    throw new WstxIOException(iOException);
                }
                n3 += n4;
                n2 -= n4;
            }
        } else {
            try {
                this.mWriter.writeCharacters(string);
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
        }
    }

    @Override
    public void writeComment(String string) throws XMLStreamException {
        int n2;
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(5);
        }
        try {
            n2 = this.mWriter.writeComment(string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (n2 >= 0) {
            BaseStreamWriter.reportNwfContent(ErrorConsts.WERR_COMMENT_CONTENT, DataUtil.Integer(n2));
        }
    }

    @Override
    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    @Override
    public void writeDTD(String string) throws XMLStreamException {
        this.verifyWriteDTD();
        this.mDtdRootElem = "";
        try {
            this.mWriter.writeDTD(string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public abstract void writeEmptyElement(String var1) throws XMLStreamException;

    @Override
    public abstract void writeEmptyElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeEmptyElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this._finishDocument(false);
    }

    @Override
    public abstract void writeEndElement() throws XMLStreamException;

    @Override
    public void writeEntityRef(String string) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            BaseStreamWriter.reportNwfStructure("Trying to output an entity reference outside main element tree (in prolog or epilog)");
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(9);
        }
        try {
            this.mWriter.writeEntityReference(string);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    @Override
    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.writeProcessingInstruction(string, null);
    }

    @Override
    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        int n2;
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mVldContent == 0) {
            this.reportInvalidContent(3);
        }
        try {
            n2 = this.mWriter.writePI(string, string2);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (n2 >= 0) {
            throw new XMLStreamException("Illegal input: processing instruction content has embedded '?>' in it (index " + n2 + ")");
        }
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        if (this.mEncoding == null) {
            this.mEncoding = "UTF-8";
        }
        this.writeStartDocument(this.mEncoding, "1.0");
    }

    @Override
    public void writeStartDocument(String string) throws XMLStreamException {
        this.writeStartDocument(this.mEncoding, string);
    }

    @Override
    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.doWriteStartDocument(string2, string, null);
    }

    protected void doWriteStartDocument(String string, String string2, String string3) throws XMLStreamException {
        if (this.mCheckStructure && this.mAnyOutput) {
            BaseStreamWriter.reportNwfStructure("Can not output XML declaration, after other output has already been done.");
        }
        this.mAnyOutput = true;
        if (this.mConfig.willValidateContent() && string != null && string.length() > 0 && !string.equals("1.0") && !string.equals("1.1")) {
            BaseStreamWriter.reportNwfContent("Illegal version argument ('" + string + "'); should only use '" + "1.0" + "' or '" + "1.1" + "'");
        }
        if (string == null || string.length() == 0) {
            string = "1.0";
        }
        this.mXml11 = "1.1".equals(string);
        if (this.mXml11) {
            this.mWriter.enableXml11();
        }
        if (string2 != null && string2.length() > 0 && (this.mEncoding == null || this.mEncoding.length() == 0)) {
            this.mEncoding = string2;
        }
        try {
            this.mWriter.writeXmlDeclaration(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public abstract void writeStartElement(String var1) throws XMLStreamException;

    @Override
    public abstract void writeStartElement(String var1, String var2) throws XMLStreamException;

    @Override
    public abstract void writeStartElement(String var1, String var2, String var3) throws XMLStreamException;

    @Override
    public void copyEventFromReader(XMLStreamReader2 xMLStreamReader2, boolean bl2) throws XMLStreamException {
        try {
            switch (xMLStreamReader2.getEventType()) {
                case 7: {
                    String string = xMLStreamReader2.getVersion();
                    if (string != null && string.length() != 0) {
                        if (xMLStreamReader2.standaloneSet()) {
                            this.writeStartDocument(xMLStreamReader2.getVersion(), xMLStreamReader2.getCharacterEncodingScheme(), xMLStreamReader2.isStandalone());
                        } else {
                            this.writeStartDocument(xMLStreamReader2.getCharacterEncodingScheme(), xMLStreamReader2.getVersion());
                        }
                    }
                    return;
                }
                case 8: {
                    this.writeEndDocument();
                    return;
                }
                case 1: {
                    if (xMLStreamReader2 instanceof StreamReaderImpl) {
                        StreamReaderImpl streamReaderImpl = (StreamReaderImpl)xMLStreamReader2;
                        this.copyStartElement(streamReaderImpl.getInputElementStack(), streamReaderImpl.getAttributeCollector());
                    } else {
                        super.copyStartElement(xMLStreamReader2);
                    }
                    return;
                }
                case 2: {
                    this.writeEndElement();
                    return;
                }
                case 6: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    if (this.mValidator != null) {
                        this.writeSpace(xMLStreamReader2.getText());
                    } else {
                        xMLStreamReader2.getText(this.wrapAsRawWriter(), bl2);
                    }
                    return;
                }
                case 12: {
                    if (this.mValidator != null) {
                        this.writeCData(xMLStreamReader2.getText());
                        return;
                    }
                    if (!this.mCfgCDataAsText) {
                        this.mAnyOutput = true;
                        if (this.mStartElementOpen) {
                            this.closeStartElement(this.mEmptyElement);
                        }
                        if (this.mCheckStructure && this.inPrologOrEpilog()) {
                            BaseStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
                        }
                        this.mWriter.writeCDataStart();
                        xMLStreamReader2.getText(this.wrapAsRawWriter(), bl2);
                        this.mWriter.writeCDataEnd();
                        return;
                    }
                }
                case 4: {
                    if (this.mValidator != null) {
                        this.writeCharacters(xMLStreamReader2.getText());
                    } else {
                        this.mAnyOutput = true;
                        if (this.mStartElementOpen) {
                            this.closeStartElement(this.mEmptyElement);
                        }
                        xMLStreamReader2.getText(this.wrapAsTextWriter(), bl2);
                    }
                    return;
                }
                case 5: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    this.mWriter.writeCommentStart();
                    xMLStreamReader2.getText(this.wrapAsRawWriter(), bl2);
                    this.mWriter.writeCommentEnd();
                    return;
                }
                case 3: {
                    this.mAnyOutput = true;
                    if (this.mStartElementOpen) {
                        this.closeStartElement(this.mEmptyElement);
                    }
                    this.mWriter.writePIStart(xMLStreamReader2.getPITarget(), true);
                    xMLStreamReader2.getText(this.wrapAsRawWriter(), bl2);
                    this.mWriter.writePIEnd();
                    return;
                }
                case 11: {
                    DTDInfo dTDInfo = xMLStreamReader2.getDTDInfo();
                    if (dTDInfo == null) {
                        BaseStreamWriter.throwOutputError("Current state DOCTYPE, but not DTDInfo Object returned -- reader doesn't support DTDs?");
                    }
                    this.writeDTD(dTDInfo);
                    return;
                }
                case 9: {
                    this.writeEntityRef(xMLStreamReader2.getLocalName());
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        throw new XMLStreamException("Unrecognized event type (" + xMLStreamReader2.getEventType() + "); not sure how to copy");
    }

    @Override
    public void closeCompletely() throws XMLStreamException {
        this._finishDocument(true);
    }

    @Override
    public boolean isPropertySupported(String string) {
        return this.mConfig.isPropertySupported(string);
    }

    @Override
    public boolean setProperty(String string, Object object) {
        return this.mConfig.setProperty(string, object);
    }

    @Override
    public XMLValidator validateAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        XMLValidator xMLValidator = xMLValidationSchema.createValidator(this);
        if (this.mValidator == null) {
            this.mCheckStructure = true;
            this.mCheckAttrs = true;
            this.mValidator = xMLValidator;
        } else {
            this.mValidator = new ValidatorPair(this.mValidator, xMLValidator);
        }
        return xMLValidator;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        XMLValidator xMLValidator = null;
        if (ValidatorPair.removeValidator(this.mValidator, xMLValidationSchema, xMLValidatorArray)) {
            xMLValidator = xMLValidatorArray[0];
            this.mValidator = xMLValidatorArray[1];
            xMLValidator.validationCompleted(false);
            if (this.mValidator == null) {
                this.resetValidationFlags();
            }
        }
        return xMLValidator;
    }

    @Override
    public XMLValidator stopValidatingAgainst(XMLValidator xMLValidator) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        XMLValidator xMLValidator2 = null;
        if (ValidatorPair.removeValidator(this.mValidator, xMLValidator, xMLValidatorArray)) {
            xMLValidator2 = xMLValidatorArray[0];
            this.mValidator = xMLValidatorArray[1];
            xMLValidator2.validationCompleted(false);
            if (this.mValidator == null) {
                this.resetValidationFlags();
            }
        }
        return xMLValidator2;
    }

    @Override
    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler validationProblemHandler) {
        ValidationProblemHandler validationProblemHandler2 = this.mVldProbHandler;
        this.mVldProbHandler = validationProblemHandler;
        return validationProblemHandler2;
    }

    private void resetValidationFlags() {
        int n2 = this.mConfig.getConfigFlags();
        this.mCheckStructure = (n2 & 0x100) != 0;
        this.mCheckAttrs = (n2 & 0x800) != 0;
    }

    @Override
    public XMLStreamLocation2 getLocation() {
        return new WstxInputLocation(null, null, (String)null, (long)this.mWriter.getAbsOffset(), this.mWriter.getRow(), this.mWriter.getColumn());
    }

    @Override
    public String getEncoding() {
        return this.mEncoding;
    }

    @Override
    public void writeCData(char[] cArray, int n2, int n3) throws XMLStreamException {
        int n4;
        if (this.mCfgCDataAsText) {
            this.writeCharacters(cArray, n2, n3);
            return;
        }
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        this.verifyWriteCData();
        if (this.mVldContent == 3 && this.mValidator != null) {
            this.mValidator.validateText(cArray, n2, n2 + n3, false);
        }
        try {
            n4 = this.mWriter.writeCData(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
        if (n4 >= 0) {
            BaseStreamWriter.throwOutputError(ErrorConsts.WERR_CDATA_CONTENT, DataUtil.Integer(n4));
        }
    }

    public void writeDTD(DTDInfo dTDInfo) throws XMLStreamException {
        this.writeDTD(dTDInfo.getDTDRootName(), dTDInfo.getDTDSystemId(), dTDInfo.getDTDPublicId(), dTDInfo.getDTDInternalSubset());
    }

    @Override
    public void writeDTD(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.verifyWriteDTD();
        this.mDtdRootElem = string;
        try {
            this.mWriter.writeDTD(string, string2, string3, string4);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public abstract void writeFullEndElement() throws XMLStreamException;

    @Override
    public void writeStartDocument(String string, String string2, boolean bl2) throws XMLStreamException {
        this.doWriteStartDocument(string, string2, bl2 ? "yes" : "no");
    }

    @Override
    public void writeRaw(String string) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            this.mWriter.writeRaw(string, 0, string.length());
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            this.mWriter.writeRaw(string, n2, n3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        try {
            this.mWriter.writeRaw(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    @Override
    public void writeSpace(String string) throws XMLStreamException {
        this.writeRaw(string);
    }

    @Override
    public void writeSpace(char[] cArray, int n2, int n3) throws XMLStreamException {
        this.writeRaw(cArray, n2, n3);
    }

    @Override
    public String getXmlVersion() {
        return this.mXml11 ? "1.1" : "1.0";
    }

    @Override
    public abstract QName getCurrentElementName();

    @Override
    public abstract String getNamespaceURI(String var1);

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public Location getValidationLocation() {
        return this.getLocation();
    }

    @Override
    public void reportProblem(XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        if (this.mVldProbHandler != null) {
            this.mVldProbHandler.reportProblem(xMLValidationProblem);
            return;
        }
        if (xMLValidationProblem.getSeverity() > 2) {
            throw WstxValidationException.create(xMLValidationProblem);
        }
        XMLReporter xMLReporter = this.mConfig.getProblemReporter();
        if (xMLReporter != null) {
            this.doReportProblem(xMLReporter, xMLValidationProblem);
        } else if (xMLValidationProblem.getSeverity() >= 2) {
            throw WstxValidationException.create(xMLValidationProblem);
        }
    }

    @Override
    public int addDefaultAttribute(String string, String string2, String string3, String string4) {
        return -1;
    }

    @Override
    public boolean isNotationDeclared(String string) {
        return false;
    }

    @Override
    public boolean isUnparsedEntityDeclared(String string) {
        return false;
    }

    @Override
    public int getAttributeCount() {
        return 0;
    }

    @Override
    public String getAttributeLocalName(int n2) {
        return null;
    }

    @Override
    public String getAttributeNamespace(int n2) {
        return null;
    }

    @Override
    public String getAttributePrefix(int n2) {
        return null;
    }

    @Override
    public String getAttributeValue(int n2) {
        return null;
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return null;
    }

    @Override
    public String getAttributeType(int n2) {
        return "";
    }

    @Override
    public int findAttributeIndex(String string, String string2) {
        return -1;
    }

    public final Writer wrapAsRawWriter() {
        return this.mWriter.wrapAsRawWriter();
    }

    public final Writer wrapAsTextWriter() {
        return this.mWriter.wrapAsTextWriter();
    }

    protected boolean isValidating() {
        return this.mValidator != null;
    }

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    public abstract void writeEndElement(QName var1) throws XMLStreamException;

    public void writeCharacters(Characters characters) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckStructure && this.inPrologOrEpilog() && !characters.isIgnorableWhiteSpace() && !characters.isWhiteSpace()) {
            BaseStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_NONWS_TEXT);
        }
        if (this.mVldContent <= 1) {
            if (this.mVldContent == 0) {
                this.reportInvalidContent(4);
            } else if (!characters.isIgnorableWhiteSpace() && !characters.isWhiteSpace()) {
                this.reportInvalidContent(4);
            }
        } else if (this.mVldContent == 3 && this.mValidator != null) {
            this.mValidator.validateText(characters.getData(), false);
        }
        try {
            this.mWriter.writeCharacters(characters.getData());
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    protected abstract void closeStartElement(boolean var1) throws XMLStreamException;

    protected final boolean inPrologOrEpilog() {
        return this.mState != 2;
    }

    private final void _finishDocument(boolean bl2) throws XMLStreamException {
        char[] cArray;
        if (this.mState != 3) {
            if (this.mCheckStructure && this.mState == 1) {
                BaseStreamWriter.reportNwfStructure("Trying to write END_DOCUMENT when document has no root (ie. trying to output empty document).");
            }
            if (this.mStartElementOpen) {
                this.closeStartElement(this.mEmptyElement);
            }
            if (this.mState != 3 && this.mConfig.automaticEndElementsEnabled()) {
                do {
                    this.writeEndElement();
                } while (this.mState != 3);
            }
        }
        if ((cArray = this.mCopyBuffer) != null) {
            this.mCopyBuffer = null;
            this.mConfig.freeMediumCBuffer(cArray);
        }
        try {
            this.mWriter.close(bl2);
        }
        catch (IOException iOException) {
            throw new WstxIOException(iOException);
        }
    }

    public abstract void copyStartElement(InputElementStack var1, AttributeCollector var2) throws IOException, XMLStreamException;

    public abstract String validateQNamePrefix(QName var1) throws XMLStreamException;

    protected final void verifyWriteCData() throws XMLStreamException {
        if (this.mCheckStructure && this.inPrologOrEpilog()) {
            BaseStreamWriter.reportNwfStructure(ErrorConsts.WERR_PROLOG_CDATA);
        }
        if (this.mVldContent <= 1) {
            this.reportInvalidContent(12);
        }
    }

    protected final void verifyWriteDTD() throws XMLStreamException {
        if (this.mCheckStructure) {
            if (this.mState != 1) {
                throw new XMLStreamException("Can not write DOCTYPE declaration (DTD) when not in prolog any more (state " + this.mState + "; start element(s) written)");
            }
            if (this.mDtdRootElem != null) {
                throw new XMLStreamException("Trying to write multiple DOCTYPE declarations");
            }
        }
    }

    protected void verifyRootElement(String string, String string2) throws XMLStreamException {
        if (this.isValidating() && this.mDtdRootElem != null && this.mDtdRootElem.length() > 0) {
            String string3 = null;
            if (!string.equals(this.mDtdRootElem)) {
                int n2 = string.length();
                int n3 = this.mDtdRootElem.length();
                if (n3 <= n2 || !this.mDtdRootElem.endsWith(string) || this.mDtdRootElem.charAt(n3 - n2 - 1) != ':') {
                    string3 = string2 == null ? string : (string2.length() == 0 ? "[unknown]:" + string : string2 + ":" + string);
                }
            }
            if (string3 != null) {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_WRONG_ROOT, string3, this.mDtdRootElem);
            }
        }
        this.mState = 2;
    }

    protected static void throwOutputError(String string) throws XMLStreamException {
        throw new XMLStreamException(string);
    }

    protected static void throwOutputError(String string, Object object) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object);
        BaseStreamWriter.throwOutputError(string2);
    }

    protected static void reportIllegalMethod(String string) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string);
    }

    protected static void reportNwfStructure(String string) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string);
    }

    protected static void reportNwfStructure(String string, Object object) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string, object);
    }

    protected static void reportNwfContent(String string) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string);
    }

    protected static void reportNwfContent(String string, Object object) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string, object);
    }

    protected static void reportNwfAttr(String string) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string);
    }

    protected static void reportNwfAttr(String string, Object object) throws XMLStreamException {
        BaseStreamWriter.throwOutputError(string, object);
    }

    protected static void throwFromIOE(IOException iOException) throws XMLStreamException {
        throw new WstxIOException(iOException);
    }

    protected static void reportIllegalArg(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    protected void reportInvalidContent(int n2) throws XMLStreamException {
        switch (this.mVldContent) {
            case 0: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_EMPTY, this.getTopElementDesc(), ErrorConsts.tokenTypeDesc(n2));
                break;
            }
            case 1: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_NON_MIXED, (Object)this.getTopElementDesc());
                break;
            }
            case 3: 
            case 4: {
                this.reportValidationProblem(ErrorConsts.ERR_VLD_ANY, this.getTopElementDesc(), ErrorConsts.tokenTypeDesc(n2));
                break;
            }
            default: {
                this.reportValidationProblem("Internal error: trying to report invalid content for " + n2);
            }
        }
    }

    public void reportValidationProblem(String string, Location location, int n2) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(location, string, n2));
    }

    public void reportValidationProblem(String string, int n2) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), string, n2));
    }

    public void reportValidationProblem(String string) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), string, 2));
    }

    public void reportValidationProblem(Location location, String string) throws XMLStreamException {
        this.reportProblem(new XMLValidationProblem(location, string));
    }

    public void reportValidationProblem(String string, Object object) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object);
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), string2));
    }

    public void reportValidationProblem(String string, Object object, Object object2) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object, object2);
        this.reportProblem(new XMLValidationProblem(this.getValidationLocation(), string2));
    }

    protected void doReportProblem(XMLReporter xMLReporter, String string, String string2, Location location) throws XMLStreamException {
        if (location == null) {
            location = this.getLocation();
        }
        this.doReportProblem(xMLReporter, new XMLValidationProblem(location, string2, 2, string));
    }

    protected void doReportProblem(XMLReporter xMLReporter, XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        if (xMLReporter != null) {
            Location location = xMLValidationProblem.getLocation();
            if (location == null) {
                location = this.getLocation();
                xMLValidationProblem.setLocation(location);
            }
            if (xMLValidationProblem.getType() == null) {
                xMLValidationProblem.setType(ErrorConsts.WT_VALIDATION);
            }
            xMLReporter.report(xMLValidationProblem.getMessage(), xMLValidationProblem.getType(), xMLValidationProblem, location);
        }
    }

    protected abstract String getTopElementDesc();

    protected final char[] getCopyBuffer() {
        char[] cArray = this.mCopyBuffer;
        if (cArray == null) {
            this.mCopyBuffer = cArray = this.mConfig.allocMediumCBuffer(512);
        }
        return cArray;
    }

    protected final char[] getCopyBuffer(int n2) {
        char[] cArray = this.mCopyBuffer;
        if (cArray == null || n2 > cArray.length) {
            this.mCopyBuffer = cArray = this.mConfig.allocMediumCBuffer(Math.max(512, n2));
        }
        return cArray;
    }

    public String toString() {
        return "[StreamWriter: " + this.getClass() + ", underlying outputter: " + (this.mWriter == null ? "NULL" : this.mWriter.toString() + "]");
    }
}

