/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ConcreteType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Discrete;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ListValueType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import java.util.StringTokenizer;

public final class ListType
extends ConcreteType
implements Discrete {
    public final XSDatatypeImpl itemType;
    private static final long serialVersionUID = 1L;

    public ListType(String string, String string2, XSDatatypeImpl xSDatatypeImpl) throws DatatypeException {
        super(string, string2);
        if (xSDatatypeImpl.isFinal(2)) {
            throw new DatatypeException(ListType.localize("BadTypeException.InvalidItemType"));
        }
        this.itemType = xSDatatypeImpl;
    }

    @Override
    public final String displayName() {
        String string = this.getName();
        if (string != null) {
            return string;
        }
        return this.itemType.displayName() + "-list";
    }

    @Override
    public final int getVariety() {
        return 2;
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    public boolean isContextDependent() {
        return this.itemType.isContextDependent();
    }

    @Override
    public int getIdType() {
        switch (this.itemType.getIdType()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
        }
        throw new Error();
    }

    @Override
    public final boolean isFinal(int n2) {
        if (n2 == 2) {
            return true;
        }
        return this.itemType.isFinal(n2);
    }

    @Override
    public final int isFacetApplicable(String string) {
        if (string.equals("length") || string.equals("minLength") || string.equals("maxLength") || string.equals("enumeration") || string.equals("pattern")) {
            return 0;
        }
        return -2;
    }

    @Override
    protected final boolean checkFormat(String string, ValidationContext validationContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            if (this.itemType.isValid(stringTokenizer.nextToken(), validationContext)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Object[] objectArray = new Object[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray[n2++] = this.itemType._createValue(stringTokenizer.nextToken(), validationContext);
            if (objectArray[n2++] != null) continue;
            return null;
        }
        return new ListValueType(objectArray);
    }

    @Override
    public Class getJavaObjectType() {
        return Object[].class;
    }

    @Override
    public final int countLength(Object object) {
        return ((ListValueType)object).values.length;
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (!(object instanceof ListValueType)) {
            throw new IllegalArgumentException();
        }
        ListValueType listValueType = (ListValueType)object;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < listValueType.values.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.itemType.convertToLexicalValue(listValueType.values[i2], serializationContext));
        }
        return stringBuffer.toString();
    }

    @Override
    protected void _checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.itemType.checkValid(string2, validationContext);
        }
    }
}

