/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.tools;

import com.neeve.cli.CliException;
import com.neeve.cli.CommandExecutor;
import com.neeve.cli.annotations.Command;
import com.neeve.cli.annotations.Option;
import com.neeve.root.RootConfig;
import com.neeve.toa.service.ToaService;
import com.neeve.toa.spi.AbstractServiceDefinitionLocator;
import com.neeve.toa.tools.ChannelKeyResolverGenerator;
import com.neeve.toa.tools.ToaCodeGenException;
import com.neeve.trace.Tracer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;

public class ToaCodeGenerator {
    private static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private static final FileFilter SERVICE_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            try {
                return AbstractServiceDefinitionLocator.isServiceDefinitionFile(pathname.toURI().toURL());
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
    };

    @Command(name="generate", description="Generates code associated with TOA services")
    public static final void generate(@Option(shortForm=115, longForm="srcdir", required=true, description="source directory containing model files") File srcdir, @Option(shortForm=111, longForm="outdir", required=true, description="base out directory for the generated source files") File outdir) throws IllegalArgumentException, ToaCodeGenException {
        if (srcdir == null) {
            throw new IllegalArgumentException("srcdir cannot be null");
        }
        if (outdir == null) {
            throw new IllegalArgumentException("outdir cannot be null");
        }
        if (!srcdir.exists()) {
            tracer.log("Source directory not found: " + srcdir, Tracer.Level.WARNING);
            return;
        }
        ArrayList<ToaService> services = new ArrayList<ToaService>();
        for (File f : srcdir.listFiles(SERVICE_FILE_FILTER)) {
            try {
                services.add(ToaService.unmarshal(f.toURI().toURL()));
            }
            catch (MalformedURLException e) {
            }
            catch (Exception e) {
                tracer.log("Error parsing service model '" + f.getName() + "': " + e.getMessage(), Tracer.Level.WARNING);
            }
        }
        if (services.isEmpty()) {
            tracer.log("No services found in " + srcdir, Tracer.Level.INFO);
            return;
        }
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        for (ToaService service : services) {
            try {
                ChannelKeyResolverGenerator.generateKeyResolvers(service, outdir);
            }
            catch (IOException e) {
                throw new ToaCodeGenException("Failed to generate TopicResolvers for service " + service.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    public static final void main(String[] args) throws CliException {
        CommandExecutor.invokeAndExit((Object)new ToaCodeGenerator(), (String)"generate", (String[])args);
    }
}

