/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.tools;

import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmField;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmPrimitive;
import com.neeve.lang.XString;
import com.neeve.root.RootConfig;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.toa.service.ToaService;
import com.neeve.toa.service.ToaServiceChannel;
import com.neeve.toa.service.ToaServiceToRole;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

class ChannelKeyResolverGenerator {
    private static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    ChannelKeyResolverGenerator() {
    }

    public static final void generateKeyResolvers(ToaService service, File outdir) throws IOException {
        for (ToaServiceToRole role : service.getToRoles()) {
            for (AdmMessage messageModel : role.getMessages()) {
                ChannelKeyResolverGenerator.genereateTopicResolverClass(messageModel, service, role, outdir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void genereateTopicResolverClass(AdmMessage messageModel, ToaService service, ToaServiceToRole role, File outdir) throws IOException {
        tracer.log("Generating TopicResolver for '" + messageModel.getFullName() + "'", Tracer.Level.INFO);
        ToaServiceChannel channel = role.getChannel(messageModel.getFullName());
        String key = channel.getKey();
        File outputFile = new File(outdir, service.getNameSpace().replaceAll("\\.", "" + File.separator + UtlText.toFirstLetterUppercase((String)(service.getSimpleName() + ".java"))));
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        } else if (outputFile.lastModified() >= service.getLastModified().getTime()) {
            tracer.log("Skipping generation for '" + outputFile + " ... not stale compared to service xml source.", Tracer.Level.DEBUG);
            return;
        }
        XString[] keyParts = MessageChannelBase.parseKey((String)key);
        String[][] keyVariables = MessageChannelBase.parseChannelKeyVariables((XString[])keyParts);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        try {
            pw.println("/**");
            pw.println(" *******************************************************************");
            pw.println(" **** THIS FILE IS GENERATED BY X PLATFORM CODE GENERATION TOOLS ***");
            pw.println(" **** ON " + String.format("%-56s", dateFormat.format(new Date())) + " ***");
            pw.println(" ********************************************************************");
            pw.println(" */");
            pw.println("package " + service.getNameSpace() + ";");
            pw.println("");
            pw.println("import java.util.Properties;");
            pw.println("");
            pw.println("import com.neeve.lang.XString;");
            pw.println("import com.neeve.sma.SmaException;");
            pw.println("import com.neeve.sma.MessageChannel.RawKeyResolutionTable;");
            pw.println("import com.neeve.sma.impl.MessageChannelBase;");
            pw.println("import com.neeve.toa.ToaException;");
            pw.println("import com.neeve.toa.service.ToaServiceChannel;");
            pw.println("import com.neeve.toa.spi.AbstractTopicResolver;");
            pw.println("import " + messageModel.getFullName() + ";");
            pw.println("");
            pw.println("/**");
            pw.println(" * Generated Topic Resolver for " + messageModel.getJavaTypeName() + " that can resolve a key of the form:");
            pw.println(" * '" + channel.getKey() + "'");
            pw.println(" */");
            pw.println("public final class " + ChannelKeyResolverGenerator.getTopicResolverName(messageModel, channel) + " {");
            pw.println("    private final String modeledKey = \"" + channel.getKey() + "\";");
            pw.println("");
            pw.println("    private final XString keyBuilder = XString.create(32, true, true);");
            pw.println("");
            pw.println("    private final boolean[] preResolved = new boolean[" + keyVariables.length + "];");
            pw.println("    private final XString[] defaults = new XString[" + keyVariables.length + "];");
            pw.println("    ");
            pw.println("    private boolean matchesServiceKey = true;");
            pw.println("    private XString[] channelKeyParts;");
            pw.println("    private String[][] variableKeyComponents;");
            pw.println("    private RawKeyResolutionTable variableKeyDefaults;");
            pw.println("    @Override");
            pw.println("    public final void initialize(final ToaServiceChannel serviceChannel) {");
            pw.println("        super.initialize(serviceChannel);");
            pw.println("        channelKeyParts = MessageChannelBase.parseKey(channelKey.getValue());");
            pw.println("        variableKeyComponents = MessageChannelBase.parseChannelKeyVariables(channelKeyParts);");
            pw.println("        variableKeyDefaults = MessageChannelBase.parseChannelKeyVariableDefaults(channelKey.getValue());");
            pw.println("        ");
            pw.println("        if (!modeledKey.equals(serviceChannel.getKey())) {");
            pw.println("            matchesServiceKey = false;");
            pw.println("            ");
            pw.println("        }");
            pw.println("        else");
            pw.println("        {");
            if (keyVariables.length > 0) {
                int i;
                pw.println("            if (variableKeyDefaults != null) {");
                for (i = 0; i < keyVariables.length; ++i) {
                    pw.println("                defaults[" + i + "] = variableKeyDefaults.get(\"" + keyVariables[i] + "\");");
                }
                pw.println("            }");
                pw.println("            ");
                pw.println("            Properties initialKRT = serviceChannel.getInitialKRT();");
                pw.println("            if (initialKRT != null) {");
                for (i = 0; i < keyVariables.length; ++i) {
                    pw.println("                preResolved[" + i + "] = initialKRT.containsKey(\"" + keyVariables[i] + "\");");
                }
            } else {
                return;
            }
            pw.println("            }");
            pw.println("        }");
            pw.println("    }");
            ChannelKeyResolverGenerator.writeKeyResolverMethod(pw, messageModel, keyParts, keyVariables, true);
            ChannelKeyResolverGenerator.writeKeyResolverMethod(pw, messageModel, keyParts, keyVariables, false);
            pw.println("}");
        }
        finally {
            pw.close();
        }
    }

    private static void writeKeyResolverMethod(PrintWriter pw, AdmMessage messageModel, XString[] keyParts, String[][] keyVariables, boolean rawKrt) {
        pw.println("    @Override");
        if (rawKrt) {
            pw.println("    public final XString resolveTopic(final " + messageModel.getJavaTypeName() + " message, final RawKeyResolutionTable krt) throws Exception {");
        } else {
            pw.println("    public final XString resolveTopic(final " + messageModel.getJavaTypeName() + " message, final Properties krt) throws Exception {");
        }
        pw.println("        keyBuilder.clear();");
        pw.println("");
        pw.println("        if (matchesServiceKey) {");
        if (keyParts[0] != null) {
            pw.println("            //'" + keyParts[0] + "'");
            pw.println("            int pos = 0;");
            pw.println("            if (channelKeyParts[0] != null) {");
            pw.println("                keyBuilder.append(channelKeyParts[0]);");
            pw.println("            }");
            pw.println("            pos++;");
        } else {
            pw.println("            int pos = 1;");
        }
        for (int i = 0; i < keyVariables.length; ++i) {
            String varName = keyParts[i + 1].getValue();
            pw.println("            //'" + varName + "'");
            pw.println("            if (!preResolved[" + i + "]) {");
            if (keyVariables[i].length == 1) {
                AdmField field = messageModel.getField(varName);
                if (field == null) {
                    field = messageModel.getField(UtlText.toFirstLetterUppercase((String)varName));
                }
                if (field.isReflectable()) {
                    pw.println("                if (message.has" + UtlText.toFirstLetterUppercase((String)varName) + "()) {");
                    if (field.getType() instanceof AdmEnumeration) {
                        pw.println("                    keyBuilder.append(message.get" + UtlText.toFirstLetterUppercase((String)varName) + "().name());");
                    } else if (field.getType() instanceof AdmPrimitive) {
                        switch (((AdmPrimitive)field.getType()).getType()) {
                            case Integer: 
                            case Long: 
                            case Short: 
                            case Byte: 
                            case Char: 
                            case Boolean: {
                                pw.println("            keyBuilder.append(message.get" + UtlText.toFirstLetterUppercase((String)varName) + "());");
                                break;
                            }
                            case String: {
                                pw.println("            keyBuilder.append(message.get" + UtlText.toFirstLetterUppercase((String)varName) + "Raw());");
                                break;
                            }
                            case UUID: 
                            case Date: 
                            case Double: 
                            case Float: 
                            case Currency: {
                                pw.println("            keyBuilder.append(String.valueOf(message.get" + UtlText.toFirstLetterUppercase((String)varName) + "()));");
                            }
                        }
                    } else {
                        pw.println("                if (!message.appendFieldValueTo(message, variableKeyComponents[" + i + "], keyBuilder && defaults[" + i + "] != null) {");
                        pw.println("                    keyBuilder.append(defaults[" + i + "]);");
                        pw.println("                }");
                    }
                    pw.println("                }");
                    pw.println("                else if (defaults[" + i + "] != null) {");
                    pw.println("                    keyBuilder.append(defaults[" + i + "]);");
                    pw.println("                }");
                } else {
                    pw.println("                if (defaults[" + i + "] != null) {");
                    pw.println("                    keyBuilder.append(defaults[" + i + "]);");
                    pw.println("                }");
                }
            } else {
                pw.println("                if (!message.appendFieldValueTo(message, variableKeyComponents[" + i + "], keyBuilder && defaults[" + i + "] != null) {");
                pw.println("                    keyBuilder.append(defaults[" + i + "]);");
                pw.println("                }");
            }
            pw.println("                else {");
            pw.println("                    final XString krtValue = krt == null ? null : krt.get(\"" + varName + "\");");
            pw.println("                    if (krtValue == null) {");
            pw.println("                        throw new ToaException(\"Value for ${" + varName + "} not in message or KRT and no default value specified!\");");
            pw.println("                    }");
            pw.println("                    else {");
            pw.println("                        keyBuilder.append(krtValue);");
            pw.println("                    }");
            pw.println("                }");
            pw.println("                pos++;");
            pw.println("                ");
            pw.println("                //'" + keyParts[i].getValue() + "'");
            pw.println("                if (channelKeyParts[pos] != null) {");
            pw.println("                    keyBuilder.append(channelKeyParts[pos]);");
            pw.println("                }");
            pw.println("                pos++;");
            pw.println("            }");
        }
        pw.println("        }");
        pw.println("    ");
        pw.println("        else {");
        pw.println("            MessageChannelBase.resolveMessageKey(keyBuilder, channelKeyParts, variableKeyComponents, message, null, krt, variableKeyDefaults);");
        pw.println("        }");
        pw.println("        return keyBuilder;");
        pw.println("    }");
    }

    private static final String getTopicResolverName(AdmMessage message, ToaServiceChannel channel) {
        return UtlText.toFirstLetterUppercase((String)message.getName()) + UtlText.toFirstLetterUppercase((String)(channel.getSimpleName() + ChannelKeyResolverGenerator.uniqueMessageId(message.getFactory().getId(), message.getId())));
    }

    private static final long uniqueMessageId(int factoryId, int messageId) {
        return (long)factoryId << 32 | (long)messageId;
    }
}

