/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.spi;

import com.neeve.root.RootConfig;
import com.neeve.toa.ToaException;
import com.neeve.toa.spi.ServiceDefinitionLocator;
import com.neeve.trace.Tracer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public abstract class AbstractServiceDefinitionLocator
implements ServiceDefinitionLocator {
    protected static final Tracer tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private static final Schema SERVICE_SCHEMA;

    public static final void validateServiceDefinitionFile(URL url) throws ToaException {
        if (AbstractServiceDefinitionLocator.tracer.debug) {
            tracer.log("validateServiceDefinitionFile checking url: " + url.toString(), Tracer.Level.DEBUG);
        }
        Validator validator = SERVICE_SCHEMA.newValidator();
        try {
            InputStream is = url.openStream();
            try {
                validator.validate(new StreamSource(url.openStream()));
                return;
            }
            catch (SAXException e) {
                throw new ToaException("Couldn't parse " + url + " as a service definition: " + e.getMessage(), e);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            throw new ToaException("Unable to read service definition at " + url.toString(), ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isServiceDefinitionFile(URL url) {
        if (AbstractServiceDefinitionLocator.tracer.debug) {
            tracer.log("isServiceDefinitionFile checking url: " + url.toString(), Tracer.Level.DEBUG);
        }
        if (!url.getPath().endsWith(".xml")) {
            if (!AbstractServiceDefinitionLocator.tracer.debug) return false;
            tracer.log("isServiceDefinitionFile returning false, no xml suffix", Tracer.Level.DEBUG);
            return false;
        }
        Validator validator = SERVICE_SCHEMA.newValidator();
        try {
            InputStream is = url.openStream();
            try {
                validator.validate(new StreamSource(url.openStream()));
                boolean bl = true;
                return bl;
            }
            catch (SAXException e) {
                tracer.log("isServiceDefinitionFile couldn't parse " + url + " as a service definition: " + e.getMessage(), Tracer.Level.WARNING);
                return false;
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            tracer.log("isValidServiceDefinitionFile encountered an error reading: " + url.toString(), Tracer.Level.WARNING);
        }
        return false;
    }

    static {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL url = AbstractServiceDefinitionLocator.class.getResource("/x-tsml.xsd");
        try {
            SERVICE_SCHEMA = factory.newSchema(url);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to set up X-TSML Schema validator. Check that x-tsml.xsd is on your classpath");
        }
    }
}

