/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa;

import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.runtime.AdmCompatibility;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.IAepPostdispatchMessageHandler;
import com.neeve.aep.IAepPredispatchMessageHandler;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepBusBindingOpenFailedEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.aep.event.AepEngineStartedEvent;
import com.neeve.aep.event.AepMessagingPrestartEvent;
import com.neeve.ci.ManifestProductInfo;
import com.neeve.ci.ProductInfo;
import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.alert.IAlertEvent;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.managed.ManagedObjectLocator;
import com.neeve.nvx.talon.Version;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingRoleChangedEvent;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.rog.IRogMessage;
import com.neeve.root.RootConfig;
import com.neeve.server.Configurer;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppCommandHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppConfiguredAccessor;
import com.neeve.server.app.annotations.AppEventHandlerAccessor;
import com.neeve.server.app.annotations.AppEventHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppFinalizer;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInitializer;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.app.annotations.AppStatContainersAccessor;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.event.MessageEvent;
import com.neeve.toa.DefaultManagedObjectLocator;
import com.neeve.toa.DefaultServiceDefinitionLocator;
import com.neeve.toa.EngineClock;
import com.neeve.toa.GeneratedTopicResolverProvider;
import com.neeve.toa.MessageInjector;
import com.neeve.toa.MessageSender;
import com.neeve.toa.ToaException;
import com.neeve.toa.service.ToaService;
import com.neeve.toa.service.ToaServiceChannel;
import com.neeve.toa.service.ToaServiceToRole;
import com.neeve.toa.spi.ChannelFilterProvider;
import com.neeve.toa.spi.ChannelInitialKeyResolutionTableProvider;
import com.neeve.toa.spi.ChannelJoinProvider;
import com.neeve.toa.spi.ChannelQosProvider;
import com.neeve.toa.spi.ServiceDefinitionLocator;
import com.neeve.toa.spi.TopicResolver;
import com.neeve.toa.spi.TopicResolverProvider;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlThrowable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class TopicOrientedApplication
implements MessageSender,
MessageInjector {
    private static final String MINIMUM_TALON_VERSION = "3.2.86";
    protected static final Tracer _tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private final Map<String, Map<String, List<Long>>> _channelMessageMapByBus;
    private final XLongLinkedHashMap<MessageSendContext> _messageChannelMap;
    private final XLongLinkedHashMap<Class<?>> _factoryRegisteredTypesById;
    private final Set<ToaService> services = new HashSet<ToaService>();
    private final EngineTimeImpl _engineClock = new EngineTimeImpl();
    private final PredispatchMessageHandlerDispatcher predispatchMessageHandlerDispatcher = new PredispatchMessageHandlerDispatcher();
    private final PostdispatchMessageHandlerDispatcher postdispatchMessageHandlerDispatcher = new PostdispatchMessageHandlerDispatcher();
    private AepEngine.HAPolicy _haPolicy;
    private IStoreBinding.Role _role;
    private AepEngineDescriptor _engineDescriptor;
    private AepEngine _engine;
    private String _engineName;
    private Configurer configurer;
    private volatile boolean messagingConfigured = false;
    private LinkedHashSet<Object> managedObjects = new LinkedHashSet();
    private ManagedObjectLocator managedObjectLocator;
    private Tracer.Level alertTraceLevel = Tracer.getLevel((String)XRuntime.getValue((String)"nv.toa.alerttracelevel", (String)Tracer.Level.WARNING.name()));

    protected TopicOrientedApplication() {
        this._channelMessageMapByBus = new HashMap<String, Map<String, List<Long>>>();
        this._messageChannelMap = XLongLinkedHashMap.newInstance();
        this._factoryRegisteredTypesById = XLongLinkedHashMap.newInstance();
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (method.isAnnotationPresent(AppInjectionPoint.class) && method.getDeclaringClass() != TopicOrientedApplication.class) {
                throw new UnsupportedOperationException("Usage of " + AppInjectionPoint.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
            }
            if (method.isAnnotationPresent(AppCommandHandlerContainersAccessor.class) && method.getDeclaringClass() != TopicOrientedApplication.class) {
                throw new UnsupportedOperationException("Usage of " + AppCommandHandlerContainersAccessor.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
            }
            if (method.isAnnotationPresent(AppConfiguredAccessor.class) && method.getDeclaringClass() != TopicOrientedApplication.class) {
                throw new UnsupportedOperationException("Usage of " + AppConfiguredAccessor.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
            }
            if (method.isAnnotationPresent(AppEventHandlerAccessor.class) && method.getDeclaringClass() != TopicOrientedApplication.class) {
                throw new UnsupportedOperationException("Usage of " + AppEventHandlerAccessor.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
            }
            if (method.isAnnotationPresent(AppInitializer.class) && method.getDeclaringClass() != TopicOrientedApplication.class) {
                throw new UnsupportedOperationException("Usage of " + AppInitializer.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
            }
            if (!method.isAnnotationPresent(AppFinalizer.class) || method.getDeclaringClass() == TopicOrientedApplication.class) continue;
            throw new UnsupportedOperationException("Usage of " + AppFinalizer.class.getSimpleName() + " annotation is unsupported for " + TopicOrientedApplication.class.getSimpleName() + " subclasses. '" + method + "' is therefore not valid!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runtimeCompatibilityCheck() {
        if (XRuntime.getValue((String)"nv.toa.disablecompatcheck", (boolean)false)) return;
        Version talonVersion = new Version();
        String[] requiredMinVersionComponents = MINIMUM_TALON_VERSION.split("\\.");
        String[] componentVersions = talonVersion.getFullVersion().split("\\.");
        try {
            for (int i = 0; i < requiredMinVersionComponents.length; ++i) {
                try {
                    int available;
                    int required = Integer.parseInt(requiredMinVersionComponents[i]);
                    int n = available = componentVersions.length > i ? Integer.parseInt(componentVersions[i]) : 0;
                    if (available > required) return;
                    if (available >= required) continue;
                    throw new ToaException("This version of TopicOrientedApplication requires at least nvx-talon version '3.2.86', but '" + talonVersion.getFullVersion() + "' was found.");
                }
                catch (NumberFormatException nfe) {
                    String required = requiredMinVersionComponents[i];
                    String available = componentVersions.length > i ? componentVersions[i] : "0";
                    int comparison = available.compareTo(required);
                    if (comparison < 0) {
                        throw new ToaException("This version of TopicOrientedApplication requires at least nvx-talon version '3.2.86', but '" + talonVersion.getFullVersion() + "' was found.");
                    }
                    if (comparison > 0) return;
                }
            }
            return;
        }
        catch (Throwable thrown) {
            throw new ToaException("Core X runtime compatibility check failed.", thrown);
        }
    }

    private final long uniqueMessageId(int factoryId, int messageId) {
        return (long)factoryId << 32 | (long)messageId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendMessage(IRogMessage message, String topic, Properties keyResolutionTable, XString rawTopic, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable) {
        MessageSendContext sendContext;
        long uniqueMessageId = this.uniqueMessageId(message.getVfid(), message.getType());
        if (TopicOrientedApplication._tracer.debug) {
            _tracer.log(this.tracePrefix() + "Sending message '" + message.getClass().getSimpleName() + "' <id=" + uniqueMessageId + "'(vfid=" + message.getVfid() + ", id=" + message.getType() + ")>...", Tracer.Level.DEBUG);
        }
        if ((sendContext = (MessageSendContext)this._messageChannelMap.get(uniqueMessageId)) != null) {
            if (sendContext.channel != null || this._haPolicy == AepEngine.HAPolicy.EventSourcing && this._role != IStoreBinding.Role.Primary) {
                message.setMessageBusAsRaw(sendContext.busName);
                message.setMessageChannelAsRaw(sendContext.channelName);
                if (topic == null && rawTopic == null && sendContext.topicResolver != null) {
                    if (rawKeyResolutionTable != null) {
                        XString resolvedTopic;
                        try {
                            resolvedTopic = sendContext.topicResolver.resolveTopic(message, rawKeyResolutionTable);
                        }
                        catch (Exception e) {
                            throw new ToaException("Error resolving topic for '" + sendContext.messageType + "' being sent on channel '" + sendContext.channel.getName() + "' using topic resolver: " + e.getMessage(), e);
                        }
                        message.setMessageKeyAsRaw(resolvedTopic);
                        this._engine.sendMessage(sendContext.channel, message);
                    } else {
                        XString resolvedTopic;
                        try {
                            resolvedTopic = sendContext.topicResolver.resolveTopic(message, keyResolutionTable);
                        }
                        catch (Exception e) {
                            throw new ToaException("Error resolving topic for '" + sendContext.messageType + "' being sent on channel '" + sendContext.channel.getName() + "' using topic resolver: " + e.getMessage(), e);
                        }
                        message.setMessageKeyAsRaw(resolvedTopic);
                        this._engine.sendMessage(sendContext.channel, message);
                    }
                } else if (topic != null) {
                    message.setMessageKey(topic);
                    this._engine.sendMessage(sendContext.channel, message);
                } else if (rawTopic != null) {
                    message.setMessageKeyAsRaw(rawTopic);
                    this._engine.sendMessage(sendContext.channel, message);
                } else if (rawKeyResolutionTable == null) {
                    this._engine.sendMessage(sendContext.channel, message, topic, keyResolutionTable);
                } else {
                    this._engine.sendMessage(sendContext.channel, message, rawTopic, rawKeyResolutionTable);
                }
                if (!TopicOrientedApplication._tracer.debug) return;
                _tracer.log(this.tracePrefix() + "...message sent on '" + sendContext.channelName + "' channel with topic '" + message.getMessageKey() + "'.", Tracer.Level.DEBUG);
                return;
            }
            if (!TopicOrientedApplication._tracer.debug) throw new ToaException("channel '" + sendContext.channelName + "' is not ready for messaging, can't send '" + message.getClass().getName() + "'");
            _tracer.log(this.tracePrefix() + "...channel '" + sendContext.channelName + "' is not ready for messaging.", Tracer.Level.DEBUG);
            throw new ToaException("channel '" + sendContext.channelName + "' is not ready for messaging, can't send '" + message.getClass().getName() + "'");
        }
        if (!TopicOrientedApplication._tracer.debug) throw new ToaException("no channel associated with message '" + message.getClass().getName() + "'");
        _tracer.log(this.tracePrefix() + "...no channel associated for message.", Tracer.Level.DEBUG);
        throw new ToaException("no channel associated with message '" + message.getClass().getName() + "'");
    }

    /*
     * WARNING - void declaration
     */
    private final void configureMessaging(Set<URL> serviceUrls, Set<Object> handlerContainers) {
        _tracer.log(this.tracePrefix() + "Configuring messaging...", Tracer.Level.CONFIG);
        _tracer.log(this.tracePrefix() + "...parsing services (count=" + serviceUrls.size() + ").", Tracer.Level.CONFIG);
        HashMap<ToaService, ToaServiceChannel> defaultChannels = new HashMap<ToaService, ToaServiceChannel>();
        for (URL url : serviceUrls) {
            if (url == null) {
                throw new ToaException("null service url return by the service locator for app '" + this._engineDescriptor.getName() + "'!");
            }
            try {
                _tracer.log(this.tracePrefix() + "......'" + url + "'.", Tracer.Level.CONFIG);
                ToaService service = ToaService.unmarshal(url);
                if (!this.services.add(service)) {
                    _tracer.log(this.tracePrefix() + "...ignore duplicate service '" + service.getName() + "' from " + url, Tracer.Level.CONFIG);
                }
                defaultChannels.put(service, service.getDefaultChannel());
            }
            catch (Exception e) {
                throw new ToaException(e);
            }
        }
        _tracer.log(this.tracePrefix() + "...parsing handled messages and events...", Tracer.Level.CONFIG);
        AepEventDispatcher eventDispatcherPrototype = AepEventDispatcher.create(handlerContainers, null);
        HashMap<String, EventHandlerContext> eventHandlersByClass = new HashMap<String, EventHandlerContext>();
        for (Class clazz : eventDispatcherPrototype.getHandledEventClasses()) {
            EventHandlerContext eventHandlerContext = new EventHandlerContext(clazz, eventDispatcherPrototype);
            eventHandlersByClass.put(clazz.getName(), eventHandlerContext);
            _tracer.log(this.tracePrefix() + "......'" + clazz.getName() + "'.", Tracer.Level.CONFIG);
        }
        _tracer.log(this.tracePrefix() + "...preparing default channel list...", Tracer.Level.CONFIG);
        HashSet<TopicResolverProvider> topicResolverProviders = new HashSet<TopicResolverProvider>();
        for (Object e : this.managedObjects) {
            if (!(e instanceof TopicResolverProvider)) continue;
            topicResolverProviders.add((TopicResolverProvider)e);
        }
        _tracer.log(this.tracePrefix() + "...preparing join channel list and message channel map...", Tracer.Level.CONFIG);
        boolean genericHandlerJoinsAll = XRuntime.getValue((String)"nv.toa.generichandlerjoinsall", (boolean)true);
        EventHandlerContext eventHandlerContext = (EventHandlerContext)eventHandlersByClass.get(MessageView.class);
        EventHandlerContext genericMessageEventHandler = (EventHandlerContext)eventHandlersByClass.get(MessageEvent.class);
        HashMap<ToaService, HashSet<ToaServiceChannel>> channelsWithHandlers = new HashMap<ToaService, HashSet<ToaServiceChannel>>();
        HashMap<String, ServiceMessageContext> serviceDeclaredMessages = new HashMap<String, ServiceMessageContext>();
        for (ToaService service : this.services) {
            for (ToaServiceToRole toaServiceToRole : service.getToRoles()) {
                for (AdmMessage admMessage : toaServiceToRole.getMessages()) {
                    List<Long> ids;
                    Map<String, List<Long>> channelMap;
                    _tracer.log(this.tracePrefix() + "......message '" + admMessage.getName() + "'...", Tracer.Level.CONFIG);
                    ServiceMessageContext messageContext = (ServiceMessageContext)serviceDeclaredMessages.get(admMessage.getFullName());
                    if (messageContext == null) {
                        messageContext = new ServiceMessageContext(admMessage);
                        serviceDeclaredMessages.put(admMessage.getFullName(), messageContext);
                    }
                    long uniqueMessageId = this.uniqueMessageId(admMessage.getFactory().calcFactoryId(), admMessage.getId());
                    messageContext.addDeclaringService(service);
                    ToaServiceChannel toaChannel = toaServiceToRole.getChannel(admMessage.getFullName());
                    _tracer.log(this.tracePrefix() + ".........<channel='" + toaChannel.getName() + "', id=" + uniqueMessageId + "(vfid=" + admMessage.getFactory().calcFactoryId() + ", id=" + admMessage.getId() + ")>.", Tracer.Level.CONFIG);
                    String interfaceName = admMessage.getNamespace() + ".I" + admMessage.getJavaTypeName();
                    boolean interfaceHandler = eventHandlersByClass.containsKey(interfaceName);
                    if (toaChannel.getBusName() == null) {
                        toaChannel.setBusName(this._engineName);
                    }
                    if (interfaceHandler) {
                        ArrayList invalidHandlers = new ArrayList();
                        try {
                            eventDispatcherPrototype.getHandlerMethodsFor(Class.forName(interfaceName), invalidHandlers);
                        }
                        catch (Exception e) {
                            _tracer.log("Failed to look up invalid event handler methods: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.DEBUG);
                        }
                        StringBuilder error = new StringBuilder();
                        error.append("Interface based message EventHandler(s) detected for '").append(interfaceName);
                        error.append("', but interface based EventHandlers are not supported. Channel '").append(toaChannel.getName()).append("' can't be joined!");
                        if (!invalidHandlers.isEmpty()) {
                            error.append(" EventHandler Declarations:\n{\n");
                            for (int i = 0; i < invalidHandlers.size(); ++i) {
                                error.append(" ").append(i + 1).append(".) ").append(((Method)invalidHandlers.get(i)).toString());
                            }
                            error.append("\n}");
                        }
                        _tracer.log(this.tracePrefix() + "ERROR: " + error.toString(), Tracer.Level.SEVERE);
                        throw new ToaException(error.toString());
                    }
                    EventHandlerContext eventHandler = (EventHandlerContext)eventHandlersByClass.get(admMessage.getFullName());
                    if (eventHandler != null) {
                        eventHandler.setFactoryFromModel(admMessage);
                    }
                    if (eventHandler != null && !eventHandler.localOnly || genericHandlerJoinsAll && (genericMessageEventHandler != null && !genericMessageEventHandler.localOnly || eventHandlerContext != null && !eventHandlerContext.localOnly)) {
                        HashSet<ToaServiceChannel> serviceJoinChannels = (HashSet<ToaServiceChannel>)channelsWithHandlers.get(service);
                        if (serviceJoinChannels == null) {
                            serviceJoinChannels = new HashSet<ToaServiceChannel>();
                            channelsWithHandlers.put(service, serviceJoinChannels);
                        }
                        serviceJoinChannels.add(toaChannel);
                    }
                    if ((channelMap = this._channelMessageMapByBus.get(toaChannel.getBusName())) == null) {
                        channelMap = new HashMap<String, List<Long>>();
                        this._channelMessageMapByBus.put(toaChannel.getBusName(), channelMap);
                    }
                    if ((ids = channelMap.get(toaChannel.getName())) == null) {
                        ids = new ArrayList<Long>();
                        channelMap.put(toaChannel.getName(), ids);
                    }
                    ids.add(uniqueMessageId);
                    String messageType = admMessage.getFullName();
                    TopicResolver<?> topicResolver = null;
                    Class<?> messageClass = null;
                    try {
                        messageClass = Class.forName(admMessage.getFullName());
                        if (!MessageView.class.isAssignableFrom(messageClass)) {
                            messageClass = null;
                            _tracer.log("Message class found for '" + messageType + "', but does not implement MessageView. TopicResolver lookup will be unavailable!", Tracer.Level.SEVERE);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        _tracer.log("Message class not found for '" + messageType + "', TopicResolver lookup will be unavailable", Tracer.Level.SEVERE);
                    }
                    if (messageClass != null) {
                        TopicResolverProvider topicResolverProvider = null;
                        for (TopicResolverProvider topicResolverProvider2 : topicResolverProviders) {
                            TopicResolver<?> resolver = topicResolverProvider2.getTopicResolver(service, toaChannel, messageClass);
                            if (resolver == null) continue;
                            if (topicResolver != null) {
                                _tracer.log("Found multiple topic resolvers for message '" + messageType + "': '" + resolver.getClass() + "' provided by '" + topicResolverProvider2.getClass() + "' will be used instead of '" + topicResolver + "' provided by '" + topicResolverProvider.getClass() + "'", Tracer.Level.WARNING);
                            }
                            topicResolver = resolver;
                            topicResolverProvider = topicResolverProvider2;
                        }
                    }
                    this._messageChannelMap.put(uniqueMessageId, (Object)new MessageSendContext(XString.create((String)toaChannel.getBusName(), (boolean)true, (boolean)true), XString.create((String)toaChannel.getName(), (boolean)true, (boolean)true), admMessage.getFullName(), toaChannel, topicResolver));
                }
            }
        }
        if (TopicOrientedApplication._tracer.getLevel().val <= Tracer.Level.CONFIG.val) {
            _tracer.log(this.tracePrefix() + "......channels with handlers...", Tracer.Level.CONFIG);
            for (ToaService service : channelsWithHandlers.keySet()) {
                _tracer.log(this.tracePrefix() + ".........service '" + service.getName() + "'...", Tracer.Level.CONFIG);
                Set set = (Set)channelsWithHandlers.get(service);
                if (set.size() > 0) {
                    for (ToaServiceChannel toaServiceChannel : set) {
                        _tracer.log(this.tracePrefix() + "............'" + toaServiceChannel.getName() + "'.", Tracer.Level.CONFIG);
                    }
                    continue;
                }
                _tracer.log(this.tracePrefix() + "............<no channels with handlers>.", Tracer.Level.CONFIG);
            }
        }
        HashSet<ChannelFilterProvider> channelFilterProviders = new HashSet<ChannelFilterProvider>();
        for (Object e : this.managedObjects) {
            if (!(e instanceof ChannelFilterProvider)) continue;
            channelFilterProviders.add((ChannelFilterProvider)e);
        }
        HashSet<ChannelQosProvider> channelQosProviders = new HashSet<ChannelQosProvider>();
        for (Object e : this.managedObjects) {
            if (!(e instanceof ChannelQosProvider)) continue;
            channelQosProviders.add((ChannelQosProvider)e);
        }
        HashSet<ChannelInitialKeyResolutionTableProvider> hashSet = new HashSet<ChannelInitialKeyResolutionTableProvider>();
        for (Object e : this.managedObjects) {
            if (!(e instanceof ChannelInitialKeyResolutionTableProvider)) continue;
            hashSet.add((ChannelInitialKeyResolutionTableProvider)e);
        }
        HashSet<ChannelJoinProvider> hashSet2 = new HashSet<ChannelJoinProvider>();
        for (Object o : this.managedObjects) {
            if (!(o instanceof ChannelJoinProvider)) continue;
            hashSet2.add((ChannelJoinProvider)o);
        }
        try {
            for (String busName : this._channelMessageMapByBus.keySet()) {
                _tracer.log(this.tracePrefix() + "...adding channels to bus descriptor '" + busName + "'...", Tracer.Level.CONFIG);
                MessageBusDescriptor busDescriptor = MessageBusDescriptor.load((String)busName);
                for (ToaService service : this.services) {
                    for (ToaServiceChannel channel : service.getChannels()) {
                        boolean join;
                        MessageChannel.Qos channelQos;
                        if (!busName.equals(channel.getBusName())) continue;
                        MessageChannelDescriptor channelDescriptor = busDescriptor.getChannel(channel.getName());
                        if (channelDescriptor == null) {
                            channelDescriptor = MessageChannelDescriptor.create((String)channel.getName(), (MessageBusDescriptor)busDescriptor);
                            busDescriptor.addChannel(channelDescriptor);
                        }
                        if ((channelQos = channelDescriptor.getChannelQos()) == null) {
                            channelQos = MessageChannel.Qos.Guaranteed;
                        }
                        ChannelQosProvider qosProvider = null;
                        for (ChannelQosProvider provider : channelQosProviders) {
                            MessageChannel.Qos qos = provider.getChannelQos(service, channel);
                            if (qos == null) continue;
                            _tracer.log(this.tracePrefix() + "......channel Qos for '" + channelDescriptor.getName() + "' '" + qos + "' (provided by: '" + provider.getClass().getName() + "').", Tracer.Level.CONFIG);
                            if (qosProvider == null) {
                                channelQos = qos;
                                qosProvider = provider;
                                continue;
                            }
                            if (channelQos != MessageChannel.Qos.BestEffort || qos != MessageChannel.Qos.Guaranteed) continue;
                            channelQos = qos;
                            qosProvider = provider;
                        }
                        channelDescriptor.setChannelQos(channelQos);
                        String key = null;
                        if (channel.getKey() != null) {
                            key = channel.getKey();
                            if (channelDescriptor.getChannelKey() != null && key == null) {
                                key = channelDescriptor.getChannelKey();
                                _tracer.log(this.tracePrefix() + "......Using pre defined channel key '" + channel.getName() + "', key=" + key, Tracer.Level.CONFIG);
                            }
                        }
                        Properties initialKRT = null;
                        ChannelInitialKeyResolutionTableProvider krtProvider = null;
                        for (ChannelInitialKeyResolutionTableProvider provider : hashSet) {
                            Properties krt = provider.getInitialChannelKeyResolutionTable(service, channel);
                            if (krt == null) continue;
                            if (initialKRT != null) {
                                throw new ToaException("Duplicate Initial KRT providers for channel '" + channel.getSimpleName() + "' in service'" + service.getName() + "'!" + " '" + krtProvider.getClass().getName() + "' provided '" + initialKRT + "'" + ", and '" + provider.getClass().getName() + "' provided '" + krt + "'");
                            }
                            krtProvider = provider;
                            initialKRT = krt;
                            _tracer.log(this.tracePrefix() + "......channel initial KRT for '" + channelDescriptor.getName() + "' is '" + krt + "' (provided by: '" + krtProvider.getClass().getName() + "').", Tracer.Level.CONFIG);
                        }
                        channel.setKey(key);
                        if (initialKRT != null && key != null) {
                            channel.setInitialKRT(initialKRT);
                            _tracer.log(this.tracePrefix() + "......performing initial channel key resolution for channel '" + channel.getName() + "', key=" + key, Tracer.Level.CONFIG);
                            key = UtlTailoring.springScanAndReplace((String)key, (Properties)initialKRT, (boolean)true);
                        }
                        channel.setInitiallyResolvedKey(key);
                        channelDescriptor.setChannelKey(key);
                        String channelFilter = null;
                        ChannelFilterProvider filterProvider = null;
                        for (ChannelFilterProvider channelFilterProvider : channelFilterProviders) {
                            String filter = channelFilterProvider.getChannelFilter(service, channel);
                            if (filter == null) continue;
                            if (channelFilter != null && !channelFilter.equals(filter)) {
                                throw new ToaException("Conflicting channel filters provided for channel '" + channel.getSimpleName() + "' in service '" + service.getName() + "'!" + " '" + filterProvider.getClass().getName() + "' provided '" + channelFilter + "'" + ", but '" + channelFilterProvider.getClass().getName() + "' provided '" + filter + "'");
                            }
                            filterProvider = channelFilterProvider;
                            channelFilter = filter;
                            _tracer.log(this.tracePrefix() + "......channel filter for '" + channelDescriptor.getName() + "' '" + channelFilter + "' (provided by: '" + filterProvider.getClass().getName() + "').", Tracer.Level.CONFIG);
                        }
                        if (channelFilter != null) {
                            channelDescriptor.setChannelFilter(channelFilter);
                        } else {
                            channelFilter = channelDescriptor.getChannelFilter();
                            _tracer.log(this.tracePrefix() + "......channel filter for '" + channelDescriptor.getName() + "' '" + channelFilter + "' already defined in channel descriptor.", Tracer.Level.CONFIG);
                        }
                        ChannelJoin channelJoin = ChannelJoin.Default;
                        Object var32_68 = null;
                        for (ChannelJoinProvider provider : hashSet2) {
                            ChannelJoin join2 = provider.getChannelJoin(service, channel);
                            if (join2 == null || join2 == ChannelJoin.Default) continue;
                            if (channelJoin != ChannelJoin.Default && !channelJoin.equals((Object)join2)) {
                                void var32_69;
                                throw new ToaException("Conflicting channel join provided for channel '" + channel.getSimpleName() + "' in service '" + service.getName() + "'!" + " '" + var32_69.getClass().getName() + "' provided '" + (Object)((Object)channelJoin) + "'" + ", but '" + provider.getClass().getName() + "' provided '" + (Object)((Object)join2) + "'");
                            }
                            ChannelJoinProvider channelJoinProvider = provider;
                            channelJoin = join2;
                            _tracer.log(this.tracePrefix() + "......channel join for '" + channelDescriptor.getName() + "' '" + (Object)((Object)channelJoin) + "' (provided by: '" + channelJoinProvider.getClass().getName() + "').", Tracer.Level.CONFIG);
                        }
                        boolean hasHandler = channelsWithHandlers.get(service) != null && ((Set)channelsWithHandlers.get(service)).contains(channel);
                        switch (channelJoin) {
                            case Join: {
                                join = true;
                                break;
                            }
                            case NoJoin: {
                                join = false;
                                break;
                            }
                            default: {
                                join = hasHandler;
                            }
                        }
                        this._engineDescriptor.addChannel(busDescriptor.getName(), channel.getName(), AepEngineDescriptor.ChannelConfig.from((String)("join=" + join)));
                        _tracer.log(this.tracePrefix() + "......channel '" + channelDescriptor.getName() + "' configured (qos=" + channelDescriptor.getChannelQos() + ", key=" + channelDescriptor.getChannelKey() + ", filter=" + channelDescriptor.getChannelFilter() + ", join=" + join + ")...", Tracer.Level.CONFIG);
                    }
                }
                busDescriptor.save(busName);
            }
        }
        catch (SmaException smaException) {
            throw new ToaException(smaException);
        }
        for (Object context : this._messageChannelMap.values()) {
            if (((MessageSendContext)context).topicResolver == null) continue;
            ((MessageSendContext)context).topicResolver.initialize(((MessageSendContext)context).serviceChannel);
        }
        if (TopicOrientedApplication._tracer.debug) {
            _tracer.log(this.tracePrefix() + "...registering service declared message view factories...", Tracer.Level.DEBUG);
        }
        for (Object context : serviceDeclaredMessages.values()) {
            ((ServiceMessageContext)context).registerTypeWithRuntime();
        }
        if (TopicOrientedApplication._tracer.debug) {
            _tracer.log(this.tracePrefix() + "...registering event handler declared message view factories...", Tracer.Level.DEBUG);
        }
        for (Object context : eventHandlersByClass.values()) {
            ((EventHandlerContext)context).registerTypeWithRuntime();
        }
        StringBuilder stringBuilder = new StringBuilder();
        MessageViewFactoryRegistry.getInstance().dumpFactoryVersionInfo(stringBuilder);
        _tracer.log(this.tracePrefix() + "...registered message view factories:\n" + stringBuilder, Tracer.Level.CONFIG);
        this.messagingConfigured = true;
    }

    protected void addHandlerContainers(Set<Object> containers) {
    }

    protected void addAppCommandHandlerContainers(Set<Object> containers) {
    }

    protected void addAppStatContainers(Set<Object> containers) {
    }

    protected void addConfiguredContainers(Set<Object> containers) {
    }

    protected void addChannelFilterProviders(Set<Object> containers) {
        containers.add(new ChannelFilterProvider(){

            @Override
            public String getChannelFilter(ToaService service, ToaServiceChannel channel) {
                return TopicOrientedApplication.this.getChannelFilter(service, channel);
            }
        });
    }

    protected void addTopicResolverProviders(Set<Object> containers) {
        containers.add(new GeneratedTopicResolverProvider());
        containers.add(new TopicResolverProvider(){

            @Override
            public TopicResolver<?> getTopicResolver(ToaService service, ToaServiceChannel channel, Class<?> messageType) {
                return TopicOrientedApplication.this.getTopicResolver(service, channel, messageType);
            }
        });
    }

    protected TopicResolver<?> getTopicResolver(ToaService serviceName, ToaServiceChannel channelName, Class<?> messageType) {
        return null;
    }

    protected String getChannelFilter(ToaService serviceName, ToaServiceChannel channelName) {
        return null;
    }

    protected void addChannelQosProviders(Set<Object> containers) {
        containers.add(new ChannelQosProvider(){

            @Override
            public MessageChannel.Qos getChannelQos(ToaService service, ToaServiceChannel channel) {
                return TopicOrientedApplication.this.getChannelQos(service, channel);
            }
        });
    }

    protected MessageChannel.Qos getChannelQos(ToaService service, ToaServiceChannel channel) {
        return null;
    }

    protected void addChannelJoinProviders(Set<Object> containers) {
        containers.add(new ChannelJoinProvider(){

            @Override
            public ChannelJoin getChannelJoin(ToaService service, ToaServiceChannel channel) {
                return TopicOrientedApplication.this.getChannelJoin(service, channel);
            }
        });
    }

    protected ChannelJoin getChannelJoin(ToaService service, ToaServiceChannel channel) {
        return ChannelJoin.Default;
    }

    protected void addChannelInitialKeyResolutionTableProviders(Set<Object> containers) {
        containers.add(new ChannelInitialKeyResolutionTableProvider(){

            @Override
            public Properties getInitialChannelKeyResolutionTable(ToaService service, ToaServiceChannel channel) {
                return TopicOrientedApplication.this.getInitialChannelKeyResolutionTable(service, channel);
            }
        });
    }

    protected Properties getInitialChannelKeyResolutionTable(ToaService service, ToaServiceChannel channel) {
        return null;
    }

    protected ServiceDefinitionLocator getServiceDefinitionLocator() {
        return new DefaultServiceDefinitionLocator();
    }

    protected ManagedObjectLocator getManagedObjectLocator() {
        return new DefaultManagedObjectLocator(this);
    }

    public final AepEngine getEngine() {
        return this._engine;
    }

    public final EngineClock getEngineClock() {
        return this._engineClock;
    }

    public final Configurer getConfigurer() {
        return this.configurer;
    }

    protected final Collection<ToaService> getServiceModels() {
        if (!this.messagingConfigured) {
            throw new IllegalStateException("Services have not yet been parsed");
        }
        return this.services;
    }

    protected final ToaService getServiceModel(String fullServiceName) {
        if (!this.messagingConfigured) {
            throw new IllegalStateException("Services have not yet been parsed");
        }
        for (ToaService service : this.services) {
            if (!service.getName().equals(fullServiceName)) continue;
            return service;
        }
        return null;
    }

    public final MessageSender getMessageSender() {
        return this;
    }

    @Override
    public final void sendMessage(IRogMessage message) {
        this.sendMessage(message, null, null, null, null);
    }

    @Override
    public final void sendMessage(IRogMessage message, String topic) {
        this.sendMessage(message, topic, null, null, null);
    }

    @Override
    public final void sendMessage(IRogMessage message, Properties keyResolutionTable) {
        this.sendMessage(message, null, keyResolutionTable, null, null);
    }

    @Override
    public final void sendMessage(IRogMessage message, XString topic) {
        this.sendMessage(message, null, null, topic, null);
    }

    @Override
    public final void sendMessage(IRogMessage message, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable) {
        this.sendMessage(message, null, null, null, rawKeyResolutionTable);
    }

    public final MessageInjector getMessageInjector() {
        return this;
    }

    @Override
    public final void injectMessage(IRogMessage message) {
        this.injectMessage(message, false, 0);
    }

    @Override
    public final void injectMessage(IRogMessage message, boolean nonBlocking) {
        this.injectMessage(message, nonBlocking, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void injectMessage(IRogMessage message, boolean nonBlocking, int delay) {
        if (this._engine.getState() == AepEngine.State.Started && this._engine.isPrimary()) {
            if (!this._engine.isDispatchThread()) {
                if (message == null) {
                    throw new IllegalArgumentException("cannot inject a null message");
                }
                if (!this._factoryRegisteredTypesById.containsKey(this.uniqueMessageId(message.getVfid(), message.getType()))) {
                    throw new ToaException("Can't inject '" + message.getClass().getName() + "' it was not registered with the application during initialization. This probably means that you don't have an @EventHandler for it in your application.");
                }
                if (delay == 0) {
                    try {
                        this._engine.multiplexMessage(message, nonBlocking);
                    }
                    catch (IllegalStateException ise) {
                        _tracer.log("Injection of message canceled: " + ise.getMessage(), Tracer.Level.WARNING);
                    }
                } else {
                    MessageEvent messageEvent = MessageEvent.create(null, null, (MessageView)message, null);
                    messageEvent.setDelay(delay);
                    try {
                        message.setTag(0, (Object)messageEvent);
                        this._engine.getEventMultiplexer().scheduleEvent((Event)messageEvent);
                    }
                    finally {
                        messageEvent.dispose();
                    }
                }
            } else {
                throw new UnsupportedOperationException("Injection of messages from an event handler thread is not currently supported.");
            }
        }
    }

    @AppInjectionPoint
    private final void setEngineConfiguration(AepEngineDescriptor engineDescriptor) throws Exception {
        this._engineDescriptor = engineDescriptor;
        this._engineName = engineDescriptor.getName();
        this.onEngineDescriptorInjected(engineDescriptor);
        if (!this._engineName.equals(engineDescriptor.getName())) {
            throw new IllegalStateException("Subclass changed engine name from '" + this._engineName + "' to '" + engineDescriptor.getName() + "'!");
        }
        if (this._engineDescriptor.getStore() != null) {
            if (this.getClass().getAnnotation(AppHAPolicy.class) == null) {
                _tracer.log(this.tracePrefix() + "Application must be annotated with an '" + AppHAPolicy.class.getCanonicalName() + "' to be configured for clustering.", Tracer.Level.SEVERE);
                throw new IllegalStateException("Application must be annotated with an '" + AppHAPolicy.class.getCanonicalName() + "' to be configured for clustering.");
            }
        } else if (this.getClass().getAnnotation(AppHAPolicy.class) == null) {
            _tracer.log(this.tracePrefix() + "No '" + AppHAPolicy.class.getCanonicalName() + "' annotation detected on main application class '" + this.getClass().getCanonicalName() + "'. Application will not be clusterable.", Tracer.Level.WARNING);
        }
        this.managedObjectLocator = this.getManagedObjectLocator();
        if (this.managedObjectLocator == null) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + ".getManagedObjectLocator() returned null.");
        }
        this.managedObjectLocator.locateManagedObjects(this.managedObjects);
        if (this.managedObjects.contains(null)) {
            throw new IllegalStateException("Addition of null objects to the set of managed objects is not supported.");
        }
    }

    protected void onEngineDescriptorInjected(AepEngineDescriptor engineDescriptor) throws Exception {
    }

    @AppEventHandlerContainersAccessor
    private final void configure(Set<Object> containers) throws Exception {
        containers.add(this);
        containers.addAll(this.managedObjects);
        LinkedHashSet<URL> services = new LinkedHashSet<URL>();
        this.getServiceDefinitionLocator().locateServices(services);
        this.configureMessaging(services, containers);
        this.onConfigured();
        containers.add(new FirstMessageValidator());
        this.traceConfig(Tracer.Level.CONFIG);
    }

    private final void traceConfig(Tracer.Level level) {
        try {
            if (TopicOrientedApplication._tracer.getLevel().val <= level.val) {
                StringBuffer buf = new StringBuffer();
                buf.append("\n=====================================\n");
                buf.append("Topic Oriented Application Configured\n");
                buf.append("Engine Descriptor:\n");
                buf.append(this._engineDescriptor.toString());
                buf.append("\n");
                if (this._engineDescriptor.getStore() != null) {
                    buf.append("Store Descriptor:\n");
                    StoreDescriptor storeDescriptor = StoreDescriptor.load((String)this._engineDescriptor.getStore());
                    buf.append(storeDescriptor.toString());
                    buf.append("\n");
                }
                buf.append("=====================================");
                _tracer.log(buf.toString(), Tracer.Level.CONFIG);
            }
        }
        catch (Exception e) {
            _tracer.log("Error tracing application configuration: " + UtlThrowable.prepareStackTrace((Throwable)e), level);
        }
    }

    @AppCommandHandlerContainersAccessor
    private final void findCommandHandlers(Set<Object> containers) throws Exception {
        containers.add(this);
        containers.addAll(this.managedObjects);
    }

    @AppStatContainersAccessor
    private final void findStatAccessors(Set<Object> containers) throws Exception {
        containers.add(this);
        containers.addAll(this.managedObjects);
    }

    @AppConfiguredAccessor
    private final void findConfiguredAccessor(Set<Object> containers) throws Exception {
        containers.add(this);
        containers.addAll(this.managedObjects);
    }

    protected void onConfigured() throws Exception {
    }

    @AppInjectionPoint
    private final synchronized void setEngine(AepEngine engine) throws Exception {
        this._engine = engine;
        this._haPolicy = engine.getHAPolicy();
        this.onEngineInjected(engine);
        this.predispatchMessageHandlerDispatcher.closeHandlerAddition();
        if (this.predispatchMessageHandlerDispatcher.handlerList.length > 0) {
            this._engine.setPredispatchMessageHandler((IAepPredispatchMessageHandler)this.predispatchMessageHandlerDispatcher);
        }
        this.postdispatchMessageHandlerDispatcher.closeHandlerAddition();
        if (this.postdispatchMessageHandlerDispatcher.handlerList.length > 0) {
            this._engine.setPostdispatchMessageHandler((IAepPostdispatchMessageHandler)this.postdispatchMessageHandlerDispatcher);
        }
        if (TopicOrientedApplication._tracer.getLevel().val >= Tracer.Level.CONFIG.val) {
            _tracer.log(this.tracePrefix() + " Engine Injected, descriptor" + engine.getDescriptor().toString(), Tracer.Level.CONFIG);
        }
    }

    protected void onEngineInjected(AepEngine engine) throws Exception {
    }

    public final void addPredispatchMessageHandler(IAepPredispatchMessageHandler handler) {
        this.predispatchMessageHandlerDispatcher.addHandler(handler);
    }

    public final void addPostdispatchMessageHandler(IAepPostdispatchMessageHandler handler) {
        this.postdispatchMessageHandlerDispatcher.addHandler(handler);
    }

    @AppInjectionPoint
    private final synchronized void setAppLoader(SrvAppLoader loader) throws Exception {
        this.configurer = (Configurer)SrvController.getInstance((SrvConfigDescriptor)loader.getServerDescriptor()).getBootstrapConfigurer();
        this.onAppLoaderInjected(loader);
    }

    protected void onAppLoaderInjected(SrvAppLoader loader) throws Exception {
    }

    @AppInitializer
    private final void appInitialized() throws Exception {
        this.onAppInitialized();
    }

    protected void onAppInitialized() throws Exception {
    }

    @EventHandler
    private final synchronized void onEngineStarted(AepEngineStartedEvent event) {
        this._role = this._engine.getStore() != null ? this._engine.getStore().getRole() : IStoreBinding.Role.Primary;
    }

    @EventHandler
    private final synchronized void onRoleChanged(IStoreBindingRoleChangedEvent event) {
        this._role = event.getRole();
    }

    @EventHandler
    private final void onChannelUp(AepChannelUpEvent event) {
        MessageChannel channel = event.getMessageChannel();
        String busName = channel.getMessageBusBinding().getName();
        String channelName = channel.getName();
        if (TopicOrientedApplication._tracer.debug) {
            _tracer.log(this.tracePrefix() + "Channel '" + channelName + "' is up.", Tracer.Level.DEBUG);
        }
        if (this._channelMessageMapByBus.get(busName) != null) {
            Map<String, List<Long>> channelMap = this._channelMessageMapByBus.get(busName);
            if (channelMap.get(channelName) != null) {
                if (TopicOrientedApplication._tracer.debug) {
                    _tracer.log(this.tracePrefix() + "...channel is in channel message map. adding channel to message send map for following ids...", Tracer.Level.DEBUG);
                }
                for (Long id : channelMap.get(channelName)) {
                    MessageSendContext context = (MessageSendContext)this._messageChannelMap.get(id.longValue());
                    context.channel = channel;
                    if (!TopicOrientedApplication._tracer.debug) continue;
                    _tracer.log(this.tracePrefix() + "......'" + context.messageType + "' [" + id + "].", Tracer.Level.DEBUG);
                }
            } else if (TopicOrientedApplication._tracer.debug) {
                _tracer.log(this.tracePrefix() + "...channel '" + channelName + "@" + channel.getMessageBusBinding().getName() + "' not in channel message map.", Tracer.Level.DEBUG);
            }
        } else if (TopicOrientedApplication._tracer.debug) {
            _tracer.log(this.tracePrefix() + "...channel bus '" + channelName + "@" + channel.getMessageBusBinding().getName() + "' not in channel message map.", Tracer.Level.DEBUG);
        }
    }

    @AppFinalizer
    private final void appFinalized() throws Exception {
        this.onAppFinalized();
    }

    protected void onAppFinalized() throws Exception {
    }

    @EventHandler
    private final void onApplicationAlert(IAlertEvent alert) {
        if (TopicOrientedApplication._tracer.getLevel().val > this.alertTraceLevel.val) {
            return;
        }
        if (alert instanceof AepBusBindingOpenFailedEvent && this._engineDescriptor.getMessagingStartFailPolicy() == AepEngine.MessagingStartFailPolicy.NeverFail) {
            return;
        }
        MessageView backing = alert.getBackingMessage();
        _tracer.log(this.tracePrefix() + "ALERT: " + alert.toString() + (backing != null ? ": " + backing.toString() : ""), this.alertTraceLevel);
    }

    private final String tracePrefix() {
        if (this._engineName != null) {
            return "<nv.toa> [" + this._engineName + "] ";
        }
        return "<nv.toa> ";
    }

    static {
        ProductInfo productInfo = ManifestProductInfo.loadProductInfo((String)"nvx-hornet");
        _tracer.log("Loaded X Topic Oriented Application Runtime (" + productInfo.getComponentVersionString() + ")", Tracer.Level.INFO);
        TopicOrientedApplication.runtimeCompatibilityCheck();
    }

    public static enum ChannelJoin {
        Default,
        NoJoin,
        Join;

    }

    private final class FirstMessageValidator {
        private FirstMessageValidator() {
        }

        @EventHandler
        public void onMessagingPrestart(AepMessagingPrestartEvent event) {
            MessageView firstMessage = event.getFirstMessage();
            if (firstMessage != null && !TopicOrientedApplication.this._factoryRegisteredTypesById.containsKey(TopicOrientedApplication.this.uniqueMessageId(firstMessage.getVfid(), firstMessage.getType()))) {
                TopicOrientedApplication.this._engine.stop((Exception)new ToaException("Can't use '" + firstMessage.getClass().getName() + "' as a first message it was not registered with the application during initialization. This probably means that you don't have an @EventHandler for it in your application."));
                return;
            }
            List initialMessages = event.getInitialMessages();
            for (int i = 0; i < initialMessages.size(); ++i) {
                MessageView initialMessage = (MessageView)initialMessages.get(i);
                if (TopicOrientedApplication.this._factoryRegisteredTypesById.containsKey(TopicOrientedApplication.this.uniqueMessageId(initialMessage.getVfid(), initialMessage.getType()))) continue;
                TopicOrientedApplication.this._engine.stop((Exception)new ToaException("Can't use '" + initialMessage.getClass().getName() + "' as an initial message it was not registered with the application during initialization. This probably means that you don't have an @EventHandler for it in your application."));
                return;
            }
        }
    }

    private final class PredispatchMessageHandlerDispatcher
    implements IAepPredispatchMessageHandler {
        private final LinkedHashSet<IAepPredispatchMessageHandler> registeredHandlers = new LinkedHashSet();
        private IAepPredispatchMessageHandler[] handlerList;
        private volatile boolean handlerAdditionClosed;

        PredispatchMessageHandlerDispatcher() {
        }

        public final void onMessage(IRogMessage message) {
            for (int i = 0; i < this.handlerList.length; ++i) {
                this.handlerList[i].onMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addHandler(IAepPredispatchMessageHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException("Handler cannot be null");
            }
            if (!this.handlerAdditionClosed) {
                LinkedHashSet<IAepPredispatchMessageHandler> linkedHashSet = this.registeredHandlers;
                synchronized (linkedHashSet) {
                    this.registeredHandlers.add(handler);
                }
            } else {
                throw new IllegalStateException("Pre dispatch message handler addition is closed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void closeHandlerAddition() {
            this.handlerAdditionClosed = true;
            LinkedHashSet<IAepPredispatchMessageHandler> linkedHashSet = this.registeredHandlers;
            synchronized (linkedHashSet) {
                this.handlerList = new IAepPredispatchMessageHandler[this.registeredHandlers.size()];
                int i = 0;
                for (IAepPredispatchMessageHandler handler : this.registeredHandlers) {
                    this.handlerList[i++] = handler;
                }
            }
        }
    }

    private final class PostdispatchMessageHandlerDispatcher
    implements IAepPostdispatchMessageHandler {
        private final LinkedHashSet<IAepPostdispatchMessageHandler> registeredHandlers = new LinkedHashSet();
        private IAepPostdispatchMessageHandler[] handlerList;
        private volatile boolean handlerAdditionClosed;

        PostdispatchMessageHandlerDispatcher() {
        }

        public final void postMessage(IRogMessage message) {
            for (int i = 0; i < this.handlerList.length; ++i) {
                this.handlerList[i].postMessage(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addHandler(IAepPostdispatchMessageHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException("Handler cannot be null");
            }
            if (!this.handlerAdditionClosed) {
                LinkedHashSet<IAepPostdispatchMessageHandler> linkedHashSet = this.registeredHandlers;
                synchronized (linkedHashSet) {
                    this.registeredHandlers.add(handler);
                }
            } else {
                throw new IllegalStateException("Pre dispatch message handler addition is closed.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void closeHandlerAddition() {
            this.handlerAdditionClosed = true;
            LinkedHashSet<IAepPostdispatchMessageHandler> linkedHashSet = this.registeredHandlers;
            synchronized (linkedHashSet) {
                this.handlerList = new IAepPostdispatchMessageHandler[this.registeredHandlers.size()];
                int i = 0;
                for (IAepPostdispatchMessageHandler handler : this.registeredHandlers) {
                    this.handlerList[i++] = handler;
                }
            }
        }
    }

    private final class EngineTimeImpl
    implements EngineClock {
        private EngineTimeImpl() {
        }

        @Override
        public final long getTime() {
            if (TopicOrientedApplication.this._engine != null) {
                return TopicOrientedApplication.this._engine.getEngineTime();
            }
            return System.currentTimeMillis();
        }
    }

    private final class ServiceMessageContext {
        final AdmMessage messageModel;
        final HashMap<String, ToaService> services = new HashMap();

        ServiceMessageContext(AdmMessage messageModel) {
            this.messageModel = messageModel;
        }

        public void addDeclaringService(ToaService service) {
            this.services.put(service.getName(), service);
        }

        public void appendDeclaringServices(String prefix, StringBuilder builder) {
            builder.append(prefix).append("Services declarating '" + this.messageModel.getFullName() + "':\n{\n");
            int i = 0;
            for (ToaService service : this.services.values()) {
                builder.append(prefix).append(" ").append(Integer.toString(i)).append(".) ").append(service.getName());
                ++i;
            }
            builder.append("\n}");
        }

        public void registerTypeWithRuntime() {
            AdmFactory factory = this.messageModel.getFactory();
            try {
                MessageViewFactoryRegistry.getInstance().registerIfNoConflict(factory.getFullName());
                StoreObjectFactoryRegistry.getInstance().registerObjectFactory(factory.getFullName());
                if (TopicOrientedApplication._tracer.debug) {
                    _tracer.log(TopicOrientedApplication.this.tracePrefix() + "......'" + factory.getFullName() + "' for '" + this.messageModel.getFullName() + "'.", Tracer.Level.DEBUG);
                }
                TopicOrientedApplication.this._factoryRegisteredTypesById.put(TopicOrientedApplication.this.uniqueMessageId(factory.calcFactoryId(), this.messageModel.getId()), Class.forName(this.messageModel.getFullName()));
            }
            catch (Exception e) {
                StringBuilder error = new StringBuilder();
                error.append("Failed to register service declared message factory '").append(factory.getFullName());
                error.append("' with the X runtime: [").append(e.getMessage()).append("]");
                this.appendDeclaringServices(" ", error);
                throw new ToaException(error.toString(), e);
            }
        }
    }

    private final class EventHandlerContext {
        final AepEventDispatcher dispatcherPrototype;
        final Class<?> eventClass;
        final boolean isFactoryMessage;
        final boolean localOnly;
        private Class<?> factoryClass;
        private boolean factoryRegistered = false;
        private long uniqueId;

        EventHandlerContext(Class<?> eventClass, AepEventDispatcher dispatcherPrototype) {
            this.dispatcherPrototype = dispatcherPrototype;
            this.eventClass = eventClass;
            this.isFactoryMessage = MessageView.class.isAssignableFrom(eventClass) && eventClass != MessageView.class;
            ArrayList handlerMethods = new ArrayList();
            dispatcherPrototype.getHandlerMethodsFor(eventClass, handlerMethods);
            boolean localOnly = true;
            for (Method handler : handlerMethods) {
                if (handler.isAnnotationPresent(EventHandler.class)) {
                    if (handler.getAnnotation(EventHandler.class).localOnly()) continue;
                    localOnly = false;
                    break;
                }
                localOnly = false;
                break;
            }
            this.localOnly = localOnly;
        }

        final void registerTypeWithRuntime() throws ToaException {
            if (!this.isFactoryMessage) {
                return;
            }
            if (this.factoryClass == null) {
                if (this.eventClass.isAnnotationPresent(AdmFactoryInfo.class)) {
                    AdmFactoryInfo factoryInfo = this.eventClass.getAnnotation(AdmFactoryInfo.class);
                    this.factoryClass = factoryInfo.factoryClass();
                    this.uniqueId = TopicOrientedApplication.this.uniqueMessageId(factoryInfo.vfid(), factoryInfo.typeId());
                } else {
                    if (this.eventClass.isAnnotationPresent(AdmGenerated.class)) {
                        StringBuilder error = new StringBuilder();
                        error.append("'" + this.eventClass + "' is declared in an event handler, but it has no AdmFactoryInfo annotation to provide");
                        error.append(" its factory information. This means its factory can't be registered with the platform which will cause problems deserializing it");
                        error.append(" during recovery and replication. Is its generated source code stale [");
                        AdmCompatibility.getAdmGenerationDetails(this.eventClass, (StringBuilder)error);
                        error.append("]?\n");
                        this.dispatcherPrototype.appendEventHandlerDeclarations(this.eventClass, " ", error);
                        _tracer.log(error.toString(), Tracer.Level.DEBUG);
                        throw new ToaException(error.toString());
                    }
                    StringBuilder error = new StringBuilder();
                    error.append("'" + this.eventClass + "' is declared in an event handler, but was not generated by ADM and has no AdmFactoryInfo annotation to provide");
                    error.append(" its factory information. This means its factory cannot be registered with platform which will cause problems deserializing it");
                    error.append("  during recovery and replication. Annotate the class with AdmFactoryInfo to allow it to be registered with the platform.");
                    this.dispatcherPrototype.appendEventHandlerDeclarations(this.eventClass, " ", error);
                    _tracer.log(error.toString(), Tracer.Level.DEBUG);
                    throw new ToaException(error.toString());
                }
            }
            if (!this.factoryRegistered) {
                try {
                    MessageViewFactoryRegistry.getInstance().registerIfNoConflict(this.factoryClass.getName());
                    StoreObjectFactoryRegistry.getInstance().registerObjectFactory(this.factoryClass.getName());
                    if (TopicOrientedApplication._tracer.debug) {
                        _tracer.log(TopicOrientedApplication.this.tracePrefix() + "......'" + this.factoryClass.getName() + "' for '" + this.eventClass.getName() + "'.", Tracer.Level.DEBUG);
                    }
                }
                catch (Exception e) {
                    StringBuilder error = new StringBuilder();
                    error.append("Failed to register event hander message factory '").append(this.factoryClass.getName());
                    error.append("' with the X runtime: [").append(e.getMessage()).append("]");
                    this.dispatcherPrototype.appendEventHandlerDeclarations(this.eventClass, " ", error);
                    throw new ToaException(error.toString(), e);
                }
                TopicOrientedApplication.this._factoryRegisteredTypesById.put(this.uniqueId, this.eventClass);
                this.factoryRegistered = true;
            }
        }

        public void setFactoryFromModel(AdmMessage message) {
            if (this.factoryClass == null) {
                try {
                    this.factoryClass = Class.forName(message.getFactory().getFullName());
                }
                catch (ClassNotFoundException e) {
                    throw new ToaException("Failed to load factory class for message '" + message.getFullName() + "'", e);
                }
                this.uniqueId = TopicOrientedApplication.this.uniqueMessageId(message.getFactory().calcFactoryId(), message.getId());
            }
        }
    }

    private final class MessageSendContext {
        final XString busName;
        final XString channelName;
        final String messageType;
        final ToaServiceChannel serviceChannel;
        final TopicResolver topicResolver;
        MessageChannel channel;

        MessageSendContext(XString busName, XString channelName, String messageType, ToaServiceChannel serviceChannel, TopicResolver<?> topicResolver) {
            this.busName = busName;
            this.channelName = channelName;
            this.messageType = messageType;
            this.serviceChannel = serviceChannel;
            this.topicResolver = topicResolver;
        }
    }
}

