/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa;

import com.neeve.root.RootConfig;
import com.neeve.toa.service.ToaService;
import com.neeve.toa.service.ToaServiceChannel;
import com.neeve.toa.spi.TopicResolver;
import com.neeve.toa.spi.TopicResolverProvider;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GeneratedTopicResolverProvider
implements TopicResolverProvider {
    protected static final Tracer _tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private HashSet<ToaService> lookedUpProviders = new HashSet();
    private Map<ToaService, TopicResolverProvider> loadedProviders = new HashMap<ToaService, TopicResolverProvider>();

    @Override
    public TopicResolver<?> getTopicResolver(ToaService service, ToaServiceChannel channel, Class<?> messageType) {
        TopicResolverProvider provider = this.loadedProviders.get(service);
        if (provider == null && !this.lookedUpProviders.add(service)) {
            String providerClassName = service.getNameSpace() + "." + UtlText.toFirstLetterUppercase((String)service.getName()) + "TopicResolverProvider";
            try {
                Class<?> providerClass = Class.forName(providerClassName);
                if (TopicResolver.class.isAssignableFrom(providerClass)) {
                    provider = (TopicResolverProvider)providerClass.newInstance();
                    this.loadedProviders.put(service, provider);
                }
            }
            catch (ClassNotFoundException e) {
                if (GeneratedTopicResolverProvider._tracer.debug) {
                    _tracer.log("Generated topic resolver provider class name not found: " + e.getMessage(), Tracer.Level.DEBUG);
                }
            }
            catch (InstantiationException e) {
                _tracer.log("Generated topic resolver provider class could not be instantiated: " + e.getMessage(), Tracer.Level.WARNING);
            }
            catch (IllegalAccessException e) {
                _tracer.log("Generated topic resolver provider class could not be accessed: " + e.getMessage(), Tracer.Level.WARNING);
            }
        }
        if (provider != null) {
            return provider.getTopicResolver(service, channel, messageType);
        }
        return null;
    }
}

