/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa;

import com.neeve.ci.XRuntime;
import com.neeve.toa.spi.AbstractServiceDefinitionLocator;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlResource;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public final class DefaultServiceDefinitionLocator
extends AbstractServiceDefinitionLocator {
    public static final String PROP_STRICT_SERVICE_VALIDATION = "nv.toa.strictServiceLocatorValidation";
    public static final boolean PROP_STRICT_SERVICE_VALIDATION_DEFAULT = false;
    private final boolean strictValidation = XRuntime.getValue((String)"nv.toa.strictServiceLocatorValidation", (boolean)false);
    private static final UtlResource.URLFilter SERVICE_FILTER = new UtlResource.URLFilter(){

        public boolean filter(URL url) {
            if (XRuntime.getValue((String)DefaultServiceDefinitionLocator.PROP_STRICT_SERVICE_VALIDATION, (boolean)false)) {
                if (url.getPath().endsWith(".xml")) {
                    AbstractServiceDefinitionLocator.validateServiceDefinitionFile(url);
                } else if (tracer.debug) {
                    tracer.log("Ignoring service definition candidate, no xml suffix: " + url, Tracer.Level.DEBUG);
                }
                return true;
            }
            return !AbstractServiceDefinitionLocator.isServiceDefinitionFile(url);
        }
    };

    @Override
    public final void locateServices(Set<URL> urls) throws Exception {
        this.findFileSystemServices(new File(XRuntime.getRootDirectory().toString() + File.separator + "conf" + File.separator + "services"), urls);
        String appName = XRuntime.getValue((String)"application.name", null);
        if (appName != null) {
            this.findFileSystemServices(new File(XRuntime.getRootDirectory().toString() + File.separator + "resources" + File.separator + appName + File.separator + "services"), urls);
        }
        UtlResource.findClasspathResourcesIn((String)"services", urls, (UtlResource.URLFilter)SERVICE_FILTER);
    }

    private final void findFileSystemServices(File directory, Set<URL> urls) throws MalformedURLException {
        File[] files;
        if (DefaultServiceDefinitionLocator.tracer.debug) {
            tracer.log("Looking for service definitions in " + directory, Tracer.Level.DEBUG);
        }
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        for (File file : files = directory.listFiles(new FilenameFilter(){

            @Override
            public final boolean accept(File dir, String name) {
                return !new File(name).isDirectory() && name.endsWith(".xml");
            }
        })) {
            URL url = file.toURI().toURL();
            if (this.strictValidation) {
                DefaultServiceDefinitionLocator.validateServiceDefinitionFile(url);
                urls.add(url);
                continue;
            }
            if (!DefaultServiceDefinitionLocator.isServiceDefinitionFile(url)) continue;
            urls.add(url);
        }
    }
}

