/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.service;

import com.neeve.adm.AdmMessage;
import com.neeve.sma.MessageView;
import com.neeve.toa.service.ToaService;
import com.neeve.toa.service.ToaServiceChannel;
import com.neeve.trace.Tracer;
import java.util.Collection;
import java.util.HashMap;

public class ToaServiceToRole {
    private final String name;
    private final HashMap<String, AdmMessage> messagesByName = new HashMap();
    private final HashMap<String, ToaServiceChannel> messageChannelMap = new HashMap();
    private final HashMap<String, Class<? extends MessageView>> messageClassMap = new HashMap();

    ToaServiceToRole(String name) {
        this.name = name;
    }

    final void addMessage(AdmMessage admMessage, ToaServiceChannel toaChannel) {
        block2: {
            this.messagesByName.put(admMessage.getFullName(), admMessage);
            this.messageChannelMap.put(admMessage.getFullName(), toaChannel);
            try {
                Class<?> messageClass = Thread.currentThread().getContextClassLoader().loadClass(admMessage.getFullName());
                this.messageClassMap.put(admMessage.getFullName(), messageClass);
            }
            catch (Exception e) {
                if (!ToaService._tracer.debug) break block2;
                ToaService._tracer.log("Couldn't resolve message class: " + admMessage.getFullName(), Tracer.Level.DEBUG);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<AdmMessage> getMessages() {
        return this.messagesByName.values();
    }

    public ToaServiceChannel getChannel(String fullMessageName) {
        return this.messageChannelMap.get(fullMessageName);
    }

    public Collection<Class<? extends MessageView>> getMessageClasses() {
        return this.messageClassMap.values();
    }
}

