/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.toa.service;

import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmType;
import com.neeve.adm.AdmXMLParser;
import com.neeve.ci.XRuntime;
import com.neeve.root.RootConfig;
import com.neeve.toa.ToaException;
import com.neeve.toa.service.ToaServiceChannel;
import com.neeve.toa.service.ToaServiceModelException;
import com.neeve.toa.service.ToaServiceToRole;
import com.neeve.toa.service.jaxb.Service;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;

public class ToaService {
    public static final String PROP_PREFIX_CHANNEL_NAMES = "nv.toa.prefixchannelnames";
    protected static final Tracer _tracer = RootConfig.ObjectConfig.createTracer((RootConfig.ObjectConfig)RootConfig.ObjectConfig.get((String)"nv.toa"));
    private final String name;
    private final String namespace;
    private final Date lastModified;
    private final boolean prefixChannelNames;
    private final Map<String, AdmModel> messageModels = new HashMap<String, AdmModel>();
    private final Map<String, ToaServiceChannel> channelsBySimpleName = new HashMap<String, ToaServiceChannel>();
    private final Map<String, ToaServiceToRole> roles = new HashMap<String, ToaServiceToRole>();
    private final HashMap<Short, AdmFactory> factoriesById = new HashMap();
    private ToaServiceChannel defaultChannel;

    public ToaService(Date lastModified, String namespace, String name, boolean prefixChannelNames) {
        this.namespace = namespace;
        this.name = name;
        this.lastModified = lastModified == null ? new Date() : lastModified;
        this.prefixChannelNames = prefixChannelNames;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void addMessageModel(AdmModel model) {
        this.messageModels.put(model.getFullName(), model);
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public String getName() {
        return this.namespace + "." + this.name;
    }

    public ToaServiceChannel getDefaultChannel() {
        return this.defaultChannel;
    }

    public boolean isPrefixChannelNames() {
        return this.prefixChannelNames;
    }

    public Collection<AdmModel> getMessageModels() {
        return this.messageModels.values();
    }

    public Collection<AdmFactory> getAdmFactories() {
        return this.factoriesById.values();
    }

    public Collection<ToaServiceChannel> getChannels() {
        return this.channelsBySimpleName.values();
    }

    public Collection<ToaServiceToRole> getToRoles() {
        return this.roles.values();
    }

    public ToaServiceToRole getToRole(String roleName) {
        return this.roles.get(roleName);
    }

    public boolean equals(Object other) {
        if (other instanceof ToaService) {
            return this.equals((ToaService)other);
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(ToaService other) {
        if (other == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    public static final ToaService unmarshal(URL url) throws Exception {
        if (url == null) {
            throw new IllegalArgumentException("Service url to unmarshal must not be null");
        }
        Date lastModified = null;
        URLConnection urlConnection = url.openConnection();
        long lastModifiedTime = urlConnection.getLastModified();
        if (lastModifiedTime > 0L) {
            lastModified = new Date(lastModifiedTime);
        }
        Service service = (Service)JAXBContext.newInstance((Class[])new Class[]{Service.class}).createUnmarshaller().unmarshal((InputStream)new BufferedInputStream(urlConnection.getInputStream()));
        ToaService rc = new ToaService(lastModified, service.getNamespace(), service.getName(), XRuntime.getValue((String)PROP_PREFIX_CHANNEL_NAMES, (boolean)service.getChannels().isPrefixChannelNames()));
        for (Service.Models.Model messageModel : service.getModels().getModel()) {
            try {
                AdmModel admModel = AdmXMLParser.parse((File)ToaService.resolveMessageModelFile(messageModel.getFile()));
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] ......'" + messageModel.getFile() + "' (" + admModel.getName() + ").", Tracer.Level.DEBUG);
                }
                rc.messageModels.put(admModel.getFullName(), admModel);
            }
            catch (Exception e) {
                throw new ToaServiceModelException(e);
            }
        }
        for (Service.Channels.Channel channel : service.getChannels().getChannel()) {
            ToaServiceChannel prev;
            ToaServiceChannel toaChannel = new ToaServiceChannel(rc, channel.getBus(), channel.getName(), channel.getKey());
            if (channel.isDefault() != null && channel.isDefault().booleanValue()) {
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] ......'" + toaChannel.getName() + "'.", Tracer.Level.DEBUG);
                }
                if (rc.defaultChannel != null) {
                    throw new ToaException("channel '" + rc.defaultChannel.getName() + "' and '" + toaChannel.getName() + "' are both configured as default channels in the '" + service.getName() + "' service");
                }
                rc.defaultChannel = toaChannel;
            }
            if ((prev = rc.channelsBySimpleName.put(toaChannel.getSimpleName(), toaChannel)) == null || (prev.getKey() != null || toaChannel.getKey() == null) && prev.getKey().equals(toaChannel.getKey())) continue;
            throw new ToaServiceModelException("Conflicting channel definitions for '" + toaChannel.getName() + "' two channels with same name but different keys: '" + prev.getKey() + "' vs '" + toaChannel.getKey() + "'.");
        }
        HashMap<Short, AdmFactory> factoriesById = new HashMap<Short, AdmFactory>();
        for (Service.Roles.To to : service.getRoles().getTo()) {
            ToaServiceToRole role = new ToaServiceToRole(to.getRole());
            rc.roles.put(role.getName(), role);
            for (Service.Roles.To.Message message : to.getMessage()) {
                AdmFactory prevFactory;
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] ......message '" + message.getName() + "...", Tracer.Level.DEBUG);
                }
                AdmMessage admMessage = rc.resolveMessage(message.getName(), message.getModel());
                AdmFactory admFactory = admMessage.getFactory();
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] .........<message='" + admMessage.getFullName() + ">.", Tracer.Level.DEBUG);
                }
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] .........<factory='" + admFactory.getFullName() + "[vfid=" + admFactory.calcFactoryId() + "]>.", Tracer.Level.DEBUG);
                }
                ToaServiceChannel messageChannel = rc.resolveMessageChannel(admMessage, message.getChannel());
                if (ToaService._tracer.debug) {
                    _tracer.log("<nv.toa> [" + rc.getName() + "] .........<channel='" + messageChannel.getName() + ">.", Tracer.Level.DEBUG);
                }
                if ((prevFactory = factoriesById.put(admFactory.calcFactoryId(), admFactory)) != null && !prevFactory.getFullName().equals(admFactory.getFullName())) {
                    throw new ToaServiceModelException("Factory id collision detected: '" + prevFactory + "' and '" + admFactory.getFullName() + "' both have factory id of " + prevFactory.calcFactoryId());
                }
                role.addMessage(admMessage, messageChannel);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File resolveMessageModelFile(String modelFilename) throws IOException {
        URL url = ToaService.class.getResource("/" + modelFilename);
        if (url != null) {
            InputStream is = url.openStream();
            try {
                File file = UtlFile.copyToTempFile((InputStream)is);
                return file;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new FileNotFoundException("model file '" + modelFilename + "' could not be located");
    }

    private final AdmMessage resolveMessage(String messageName, String admModelName) {
        String simpleMessageName = messageName;
        String messageNamespace = null;
        if (messageName.indexOf(".") > 0) {
            simpleMessageName = messageName.substring(messageName.lastIndexOf(".") + 1);
            messageNamespace = messageName.substring(0, messageName.lastIndexOf("."));
        }
        if (admModelName != null) {
            AdmModel resolvedModel = this.messageModels.get(admModelName);
            if (resolvedModel == null) {
                for (AdmModel model : this.messageModels.values()) {
                    if (!admModelName.equals(model.getName())) continue;
                    if (resolvedModel == null) {
                        if (model.getMessage(simpleMessageName) == null) continue;
                        if (messageNamespace != null && !messageNamespace.equals(model.getNamespace())) {
                            if (!ToaService._tracer.debug) continue;
                            _tracer.log("Found model with matching name for message '" + messageName + "', but namespace doesn't match: " + model.getFullName(), Tracer.Level.DEBUG);
                            continue;
                        }
                        resolvedModel = model;
                        continue;
                    }
                    if (model.getMessage(simpleMessageName) == null) continue;
                    throw new ToaServiceModelException("Ambiguous model for message '" + messageName + "'defined in service '" + this.getName() + "'. Both '" + resolvedModel.getFullName() + "' and '" + model.getFullName() + "' contain the message type. A qualified model or message name must be specified.");
                }
                if (resolvedModel != null) {
                    return resolvedModel.getMessage(simpleMessageName);
                }
            } else {
                if (resolvedModel.getMessage(simpleMessageName) != null) {
                    return resolvedModel.getMessage(simpleMessageName);
                }
                throw new ToaServiceModelException("'" + admModelName + "' does not contain message '" + messageName + "' defined in service '" + this.getName() + "'.");
            }
            throw new ToaServiceModelException("Could not resolve message model '" + admModelName + "' with message '" + messageName + "' defined in service '" + this.getName() + "'.");
        }
        AdmModel resolvedModel = null;
        for (AdmModel model : this.messageModels.values()) {
            if (resolvedModel == null) {
                AdmType type = model.getType(messageName);
                if (type instanceof AdmMessage) {
                    if (messageNamespace != null) {
                        return (AdmMessage)type;
                    }
                    resolvedModel = model;
                    continue;
                }
                if (!ToaService._tracer.debug) continue;
                _tracer.log("Found type in model '" + model.getFullName() + "' that was not a message: '" + type + "', ignoring...", Tracer.Level.DEBUG);
                continue;
            }
            if (model.getMessage(simpleMessageName) == null) continue;
            throw new ToaServiceModelException("Ambiguous model for message '" + messageName + "'defined in service '" + this.getName() + "'. Both '" + resolvedModel.getFullName() + "' and '" + model.getFullName() + "' contain the message type. A qualified qualified model or message name must be specified.");
        }
        if (resolvedModel != null) {
            return resolvedModel.getMessage(simpleMessageName);
        }
        throw new ToaServiceModelException("Could not resolve message '" + messageName + "' from any of the models defined in service '" + this.getName() + "'.");
    }

    private final ToaServiceChannel resolveMessageChannel(AdmMessage message, String channelName) {
        ToaServiceChannel messageChannel = null;
        if (channelName != null) {
            messageChannel = this.channelsBySimpleName.get(channelName);
            if (messageChannel == null) {
                throw new ToaServiceModelException("could not find channel '" + channelName + "' defined as the channel for message '" + message.getFullName() + "' in service '" + this.getName() + "'");
            }
        } else {
            messageChannel = this.channelsBySimpleName.get(message.getName());
            if (messageChannel == null && (messageChannel = this.defaultChannel) == null) {
                throw new ToaServiceModelException("Could not resolve the channel for message '" + message.getName() + "' in service '" + this.getName() + "'. No channel specified for the message, no default channel for the service, and no channel matching the message name.");
            }
        }
        return messageChannel;
    }

    public String toString() {
        return "ToaService [name=" + this.getName() + " prefixChannelNames=" + this.isPrefixChannelNames() + "]";
    }
}

